<?php $__env->startSection('main_content'); ?>
    
    <section class="page-title" style="background-image:url(<?php echo e(asset('images/blogs/Header-Blog.png')); ?>)">
        <div class="auto-container">
            <h1 class="d-none"> Welcome to Our Blog - <?php echo e($blog->translation->name); ?> </h1>
            <ul class="bread-crumb clearfix">
                <li><a href="<?php echo e(route('home.index')); ?>"><?php echo e(__('messages.home')); ?> </a></li>
                <li><?php echo e(__('messages.blog-detail')); ?> </li>
            </ul>
            <h2><?php echo e($blog->translation->name); ?> </h2>
        </div>
    </section>
    <!-- End Page Title -->
    <!-- Sidebar Page Container -->
    <div class="sidebar-page-container">
        
        <div class="auto-container">
            <div class="row clearfix">
                <!-- Content Side -->
                <div class="content-side col-lg-8 col-md-12 col-sm-12">
                    <!-- News Detail -->
                    <div class="news-detail">
                        <div class="inner-box">
                            <div class="image">
                                <img src="<?php echo e(asset('/images/blogs/' . $blog->image->image_large)); ?>" alt="" />
                            </div>
                            <div class="lower-content">
                                <ul class="post-info">
                                    <li><?php echo e($blog->blogCategory->translation->name); ?> </li>
                                    <li><span
                                            class="icon flaticon-calendar"></span><?php echo e($blog->created_at->format('M d, Y')); ?>

                                    </li>
                                    <li><span class="icon flaticon-user-2"></span><?php echo e($blog->views); ?> Views</li>
                                </ul>
                                <h3><?php echo e($blog->translation->name); ?></h3>
                                <?php echo $blog->translation->description; ?>

                                <div class="lower-content2">
                                </div>


                                <div class="gallery-box">
									<div class="row clearfix">
										<!-- Carousel Column -->
										<div class="carousel-column col-lg-6 col-md-6 col-sm-12">
											<div class="single-item-carousel owl-carousel owl-theme">
                                                <?php $__currentLoopData = $blog->blogImages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $imageGallery): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>      
												<div class="slide">
													<div class="image">
														<img src="<?php echo e(asset('images/blogs/'. $imageGallery->name)); ?>" alt="<?php echo e($imageGallery->name); ?>" />
													</div>
												</div>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
											</div>
										</div>
									</div>
								</div>

                                
                            </div>
                            <!-- Post Share Options-->
                            <div class="post-share-options px-3">
                                <div class="post-share-inner clearfix">
                                    
                                    <ul class="social-box">
                                        <span class="share"><?php echo e(__('messages.share-article')); ?> </span>
                                        <li><a href="https://www.facebook.com/sharer/sharer.php?u=<?php echo e(urlencode(url()->current())); ?>"
                                                target="_blank"><span class="fa fa-facebook-f"></span></a></li>
                                        <li>
                                            <a href="https://www.linkedin.com/sharing/share-offsite/?url=<?php echo e(urlencode(url()->current())); ?>"
                                                target="_blank"><span class="fa fa-linkedin"></span></a>
                                            </li>
                                        <li><a href="https://api.whatsapp.com/send?text=ITG%20Blog%20<?php echo e(urlencode(url()->current())); ?>"
                                                target="_blank"><span class="fa fa-whatsapp f-size-10"></span></a></li>
                                        
                                    </ul>
                                </div>
                            </div>
                            <!-- End Post Share Options-->
                        </div>
                    </div>
                    <!-- Related Post -->
                    
                    <!-- End Related Post -->
                </div>
                <!-- Sidebar Side -->
                <?php echo $__env->make('blogs.blog-nav-right', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('styles'); ?>
    <style>
        .f-size-10 {
            font-size: 20px;
        }

        .lower-content2 span {
            color: var(--color-five) !important;
            font-weight: 400;
            text-decoration: auto;
        }
    </style>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.general', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/group-itg.com/resources/views/blogs/blog-show.blade.php ENDPATH**/ ?>