<?php $__env->startSection('main_content'); ?>
    
    <section class="page-title"
        style="background-image: url(<?php echo e(asset('images/machinery/general/General-Machinery/Header.png')); ?>" id="about">
        <div class="auto-container">
            <h1 class="d-none">Catalog of Machinery for Sale</h1>
            <ul class="bread-crumb clearfix">
                <li><a href="<?php echo e(route('home.index')); ?>"><?php echo e(__('messages.home')); ?> </a></li>
                <li><?php echo e(__('messages.machinery')); ?> </li>
            </ul>
            <h2><?php echo e(__('messages.machinery')); ?> </h2>
        </div>
    </section>>
    <!-- End Page Title -->

    <!-- Project Page Section -->
    <div class="project-page-section">
        
        <div class="auto-container">
            <div class="sec-title alternate centered">
                <div class="title style-two text-dark"><?php echo e(__('messages.machinery-title')); ?> </div>
                <h3 class="_h2 color-green1"><?php echo e(__('messages.machinery-subtitle')); ?> </h3>
            </div>
            <!-- MixitUp Galery -->
            <div class="mixitup-gallery">
                <!-- Filter -->
                <div class="filters clearfix">
                    <ul class="filter-tabs filter-btns text-center clearfix">
                        <a href="<?php echo e(route('machinery.index')); ?>">
                            <li class="<?php if($condition == 0): ?> active <?php endif; ?>  filter"> <?php echo e(__('messages.new')); ?>

                            </li>
                        </a>
                        <a href="javascript:void(0;)">
                            <li class="filter"> <?php echo e(__('messages.used')); ?> </li>
                        </a>
                    </ul>
                </div>

                <div class="filters clearfix">
                    <ul class="filter-tabs filter-btns text-center clearfix">
                        <a href="<?php echo e(route('machinery.index')); ?>">
                            <li class="<?php if(empty($category)): ?> active <?php endif; ?>  filter">
                                <?php echo e(__('messages.view-all')); ?> </li>
                        </a>
                        <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $categoryF): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <a href="<?php echo e(route('machinery.category', $categoryF)); ?>">
                                <li class="<?php if($category && $categoryF->id == $category->id): ?> active <?php endif; ?>  filter">
                                    <?php echo e($categoryF->translation->name); ?> </li>
                            </a>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>

                <div class="filter-list row clearfix justify-content-center">
                    <?php $__empty_1 = true; $__currentLoopData = $machines; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $machine): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <div class="project-block-two mix all col-lg-6 col-md-6 col-sm-12">
                            <div class="inner-box">
                                <div class="image">
                                    <img src="<?php echo e(asset('images/' . $machine->main_image)); ?>" alt="" />
                                    <div class="overlay-box">
                                        <a class="plus flaticon-plus" href="<?php echo e(route('machinery.show', $machine)); ?>"></a>
                                        <div class="content">
                                            <div class="title"><?php echo e($machine->machineCategory->translation->name); ?> </div>
                                            <div class="pr-5">
                                                <h4><a href="<?php echo e(route('machinery.show', $machine)); ?>"><?php echo e($machine->translation->name); ?>

                                                    </a></h4>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <p><?php echo __('messages.no-machinery'); ?> </p>
                    <?php endif; ?>
                </div>

                <div class="mt-10 d-flex justify-content-end">
                    <?php echo e($machines->links('vendor.pagination.blog')); ?>

                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('styles'); ?>
    <style>
        .project-block-two .inner-box .overlay-box:before {
            opacity: 0.52;
            background-color: var(--black-color);
        }

        .project-page-section .filters li {
            background: var(--color-green-one);
            color: var(--white-color);
        }
    </style>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.general', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/group-itg.com/resources/views/machinery/machinery.blade.php ENDPATH**/ ?>