<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">

<head>
    <meta charset="utf-8">
    
    <link href="<?php echo e(asset('css/bootstrap.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('css/style.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('css/responsive.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('css/style-own.css')); ?>" rel="stylesheet">
    
    
    <?php echo $__env->yieldPushContent('styles'); ?>

    <link rel="canonical" href="<?php echo e(url()->current()); ?>" />


    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@300;400;500;700;900&display=swap" rel="stylesheet">
    <link
        href="https://fonts.googleapis.com/css2?family=Be+Vietnam+Pro:wght@100;200;300;400;500;600;700;800;900&display=swap"
        rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@100;200;300;400;500;600;700;800;900&display=swap"
        rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@100;300;400;500;600;700;800;900&display=swap"
        rel="stylesheet">

    <link rel="shortcut icon" href="<?php echo e(asset('images/favicon_.png')); ?>" type="image/x-icon">
    <link rel="icon" href="<?php echo e(asset('images/favicon_.png')); ?>" type="image/x-icon">

    <!-- Responsive -->
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=yes">

            <!-- Google tag (gtag.js) -->
            <script async src="https://www.googletagmanager.com/gtag/js?id=G-ZT8SWHKF6X"></script>
            <script>
                    window.dataLayer = window.dataLayer || [];
                    function gtag(){dataLayer.push(arguments);}
                    gtag('js', new Date());
                    gtag('config', 'G-ZT8SWHKF6X');
            </script>
    


    <?php echo SEOMeta::generate(); ?>

    <?php echo OpenGraph::generate(); ?>

</head>

<body>

    <div class="cursor"></div>

    <div class="page-wrapper">


        <?php echo $__env->yieldContent('preloader'); ?>


        <!-- scrollToTop start -->
        <div class="progress-wrap active-progress">
            <svg class="progress-circle svg-content" width="100%" height="100%" viewBox="-1 -1 102 102">
                <path d="M50,1 a49,49 0 0,1 0,98 a49,49 0 0,1 0,-98"
                    style="transition: stroke-dashoffset 10ms linear 0s; stroke-dasharray: 307.919px, 307.919px; stroke-dashoffset: 228.265px;">
                </path>
            </svg>
        </div>
        <!-- scrollToTop end -->

        <!-- Main Header-->
        <header class="main-header">

            <!-- Header Top -->
            <div class="header-top">
                <div class="auto-container">
                    <div class="clearfix">
                        <!-- Top Left -->
                        <div class="top-left">
                            <div class="text text-uppercase"> 
                                <?php echo e(__('messages.text-top-left')); ?> </div>
                        </div>

                        <!-- Top Right -->
                        <div class="top-right pull-right">
                            
                            <div class="social-box">
                                <a href=" https://www.instagram.com/group_itg/"
                                    target=”_blank”><?php echo e(__('messages.instagram')); ?> </a>
                                <a href="https://www.facebook.com/GROUPITG/" target=”_blank”>
                                    <?php echo e(__('messages.facebook')); ?> </a>
                                <a href=" https://www.linkedin.com/company/groupitg/mycompany/?viewAsMember=true"
                                    target=”_blank”><?php echo e(__('messages.linkedin')); ?> </a>
                                <a href="https://www.youtube.com/@groupitg"
                                    target=”_blank”><?php echo e(__('messages.youtube')); ?> </a>
                            </div>
                        </div>

                    </div>
                </div>
            </div>

            <!-- Header Upper -->
            <div class="header-upper">
                <div class="auto-container">
                    <div class="clearfix">

                        <div class="pull-left logo-box">
                            <div class="logo"><a href="<?php echo e(route('home.index')); ?> ">
                                    <img src="<?php echo e($division->logo->url_logo); ?>" alt="Image Logo">
                                </a></div>
                        </div>

                        <div class="pull-right upper-right clearfix">


                            <!--Info Box-->

                            <a class="upper-column info-box mr-3" href="https://wa.me/522223628956" target=”_blank”>
                                <div class="icon-box"><span class="flaticon-whatsapp"></span></div>
                                <ul class="py-1 max-w-150px">
                                    <li><strong><?php echo e(__('messages.chat-us')); ?> </strong></li>
                                    <li><?php echo e(__('messages.chat-us-subtitle')); ?> </li>
                                </ul>
                            </a>


                            <!--Info Box-->

                            <a class="upper-column info-box" href="mailto:info@group-itg.com" target=”_blank”>
                                <div class="icon-box"><span class="flaticon-message"></span></div>
                                <ul class="py-1 max-w-150px">
                                    <li><strong><?php echo e(__('messages.mail-us')); ?> </strong></li>
                                    <li class="text-lowercase text-truncate"><?php echo e(__('messages.mail-us-subtitle')); ?>

                                    </li>
                                </ul>
                            </a>




                            <!--Info Box-->
                            <div class="upper-column info-box d-inline px-2">
                                <div class="outer-box p-0">
                                    <a class="btn-web-catalog"
                                        href="https://textilecatalogues.group-itg.com/"><?php echo e(__('messages.btn-catalog')); ?>

                                        </span></a>
                                </div>
                            </div>

                            <div class="upper-column info-box d-inline px-2 m-0">
                                <div class="outer-box p-0">
                                    <div class="drop-responsive">
                                        <div class="dropdown">
                                            <button class="btn dropdown-toggle" type="button"
                                                id="dropdownMenuButton" data-toggle="dropdown" aria-haspopup="true"
                                                aria-expanded="false">
                                                
                                                <img src=" <?php echo e($info_language->flag_image); ?>"
                                                    class="img-fluid"><?php echo e(__('nationality.' . $info_language->language)); ?>

                                            </button>
                                            <div class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                                                <?php $__currentLoopData = $division->languages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <a class="dropdown-item"
                                                        href="<?php echo e(url('locale/' . $language->language_code)); ?> "><img
                                                            src="<?php echo e($language->flag_image); ?>"
                                                            class="img-fluid"><?php echo e(__('nationality.' . $language->language)); ?>

                                                    </a>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>


                        </div>

                    </div>
                </div>
            </div>
            <!-- End Header Upper -->

            <!-- Header Upper -->
            <div class="header-lower">
                <div class="auto-container">
                    <div class="inner-container clearfix">

                        <?php echo $__env->make('layouts.navbar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                    </div>
                </div>
            </div>
            <!--End Header Upper-->

            <!-- Sticky Header  -->
            <div class="sticky-header">
                <div class="auto-container clearfix">
                    <!--Logo-->
                    <div class="logo pull-left" style="max-width: 150px">
                        <a href="<?php echo e(route('home.index')); ?>" title=""><img
                                src=" <?php echo e($division->logo->url_logo_white); ?>" alt="Image Logo White" style="width: 100%;"></a>
                    </div>
                    <!--Right Col-->
                    <div class="pull-right">
                        <!-- Main Menu -->
                        <nav class="main-menu">
                            <!--Keep This Empty / Menu will come through Javascript-->
                            <div class="outer-box">
                                <div class="dropdown">
                                    <button class="btn dropdown-toggle" type="button" id="dropdownMenuButton"
                                        data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                        
                                        <img src=" <?php echo e($info_language->flag_image); ?>"
                                            class="img-fluid"><?php echo e(__('nationality.' . $info_language->language)); ?>

                                    </button>
                                    <div class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                                        <?php $__currentLoopData = $division->languages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <a class="dropdown-item"
                                                href="<?php echo e(url('locale/' . $language->language_code)); ?> "><img
                                                    src="<?php echo e($language->flag_image); ?>"
                                                    class="img-fluid"><?php echo e(__('nationality.' . $language->language)); ?>

                                            </a>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                </div>
                            </div>
                            

                        </nav><!-- Main Menu End-->

                        <!-- Mobile Navigation Toggler -->
                        <div class="mobile-nav-toggler"><span class="icon flaticon-menu-3"></span></div>

                    </div>
                </div>
            </div><!-- End Sticky Menu -->

            <!-- Mobile Menu  -->
            <div class="mobile-menu">
                <div class="menu-backdrop"></div>
                <div class="close-btn"><span class="icon fa fa-close"></span></div>

                <nav class="menu-box">
                    <div class="nav-logo"><a href="<?php echo e(route('home.index')); ?>"><img
                                src=" <?php echo e($division->logo->logo_url); ?>" alt="" title=""></a></div>
                    <div class="menu-outer">
                        <!--Here Menu Will Come Automatically Via Javascript / Same Menu as in Header-->
                        <div class="outer-box">
                            <a class="btn-web-catalog"
                                href="https://textilecatalogues.group-itg.com/"><?php echo e(__('messages.btn-catalog')); ?>

                                </span></a>
                        </div>

                        <div class="upper-column info-box d-inline px-2 m-0">
                            <div class="outer-box p-0">
                                <div class="drop-responsive">
                                    <div class="dropdown">
                                        <button class="btn dropdown-toggle" type="button" id="dropdownMenuButton"
                                            data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                            
                                            <img src=" <?php echo e($info_language->flag_image); ?>"
                                                class="img-fluid"><?php echo e(__('nationality.' . $info_language->language)); ?>

                                        </button>
                                        <div class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                                            <?php $__currentLoopData = $division->languages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <a class="dropdown-item"
                                                    href="<?php echo e(url('locale/' . $language->language_code)); ?> "><img
                                                        src="<?php echo e($language->flag_image); ?>"
                                                        class="img-fluid"><?php echo e(__('nationality.' . $language->language)); ?>

                                                </a>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                    </div>
                </nav>


            </div><!-- End Mobile Menu -->

        </header>
        <!-- End Main Header -->

        <?php echo $__env->yieldContent('main_content'); ?>

        <!-- Footer Style Two -->
        <footer class="main-footer" style="background-image:url(<?php echo e(asset('images/resource/Footer.png')); ?>)"
            id="footer-main">
            <div class="auto-container">
                <!-- Widgets Section -->
                <div class="widgets-section">
                    <div class="row clearfix">

                        <!-- Big Column -->
                        <div class="big-column col-lg-6 col-md-12 col-sm-12">
                            <div class="row clearfix">

                                <!-- Footer Column -->
                                <div class="footer-column col-lg-6 col-md-6 col-sm-12">
                                    <div class="footer-widget logo-widget">
                                        <div class="logo">
                                            <a href="<?php echo e(route('home.index')); ?>"><img
                                                    src="<?php echo e($division->logo->url_logo_white); ?> "
                                                    alt="" /></a>
                                        </div>
                                        <div class="text">
                                            <p class="color-yellow1 text-uppercase font-weight-bold">
                                                <?php echo e(__('messages.weaving-success')); ?> </p>
                                        </div>
                                        <a href="<?php echo e(route('about.index')); ?>"
                                            class="theme-btn about-btn"><?php echo e(__('messages.about-us')); ?> </a>
                                    </div>
                                </div>

                                <!-- Footer Column -->
                                

                            </div>
                        </div>

                        <!-- Big Column -->
                        <div class="big-column col-lg-6 col-md-12 col-sm-12">
                            <div class="row clearfix">

                                <!-- Footer Column -->
                                <div class="footer-column col-lg-6 col-md-6 col-sm-12">
                                    <div class="footer-widget contact-widget">


                                        <div class="col-md-12" style="position: relative;">
                                            <a href="https://textilecatalogues.group-itg.com/"
                                                style="position: relative; display: inline-block;">
                                                <img src="<?php echo e(asset('/images/products/img-catalog.jpeg')); ?>"
                                                    alt="Image Catalogue" style="max-width: 220px">
                                                <p class="btn-web-catalog btn-footer-webcat">
                                                    <?php echo e(__('messages.btn-catalog')); ?> > </p>
                                            </a>
                                        </div>

                                        <div class="col-md-10 mt-2">
                                            <div class="dropdown">
                                                <button class="btn dropdown-toggle" type="button"
                                                    id="dropdownMenuButton" data-toggle="dropdown"
                                                    aria-haspopup="true" aria-expanded="false">
                                                    
                                                    <img src=" <?php echo e($info_language->flag_image); ?>"
                                                        class="img-fluid"><?php echo e(__('nationality.' . $info_language->language)); ?>

                                                </button>
                                                <div class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                                                    <?php $__currentLoopData = $division->languages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <a class="dropdown-item"
                                                            href="<?php echo e(url('locale/' . $language->language_code)); ?> "><img
                                                                src="<?php echo e($language->flag_image); ?>"
                                                                class="img-fluid"><?php echo e(__('nationality.' . $language->language)); ?></a>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </div>
                                            </div>
                                        </div>


                                    </div>
                                </div>

                                <!-- Footer Column -->
                                <div class="footer-column col-lg-6 col-md-6 col-sm-12">
                                    <div class="footer-widget instagram-widget">
                                        <h2 class="_h4 text-white"><?php echo e(__('messages.contacts-us')); ?>!</h2>
                                        <div class="widget-content">
                                            <div class="images-outer clearfix">
                                                <!--Image Box-->
                                                <figure class="image-box w-imge-box">
                                                    <a href="#footer-main" class="color-yellow1">
                                                        <svg xmlns="http://www.w3.org/2000/svg"
                                                            class="icon icon-tabler icon-tabler-phone" width="44"
                                                            height="44" viewBox="0 0 24 24" stroke-width="1.5"
                                                            stroke="#CFD989" fill="none" stroke-linecap="round"
                                                            stroke-linejoin="round">
                                                            <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                                                            <path
                                                                d="M5 4h4l2 5l-2.5 1.5a11 11 0 0 0 5 5l1.5 -2.5l5 2v4a2 2 0 0 1 -2 2a16 16 0 0 1 -15 -15a2 2 0 0 1 2 -2" />
                                                        </svg>
                                                    </a>
                                                </figure>
                                                <!--Image Box-->
                                                <figure class="image-box w-imge-box">
                                                    <a href="mailto:info@group-itg.com" target=”_blank”
                                                        class="color-yellow1">
                                                        <svg xmlns="http://www.w3.org/2000/svg"
                                                            class="icon icon-tabler icon-tabler-mail" width="44"
                                                            height="44" viewBox="0 0 24 24" stroke-width="1.5"
                                                            stroke="#CFD989" fill="none" stroke-linecap="round"
                                                            stroke-linejoin="round">
                                                            <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                                                            <path
                                                                d="M3 7a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v10a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2v-10z" />
                                                            <path d="M3 7l9 6l9 -6" />
                                                        </svg>
                                                    </a>
                                                </figure>
                                                <!--Image Box-->
                                                <figure class="image-box w-imge-box">
                                                    <a href="https://wa.me/522223628956" target=”_blank”
                                                        class="color-yellow1">
                                                        <svg xmlns="http://www.w3.org/2000/svg"
                                                            class="icon icon-tabler icon-tabler-brand-whatsapp"
                                                            width="44" height="44" viewBox="0 0 24 24"
                                                            stroke-width="1.5" stroke="#CFD989" fill="none"
                                                            stroke-linecap="round" stroke-linejoin="round">
                                                            <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                                                            <path d="M3 21l1.65 -3.8a9 9 0 1 1 3.4 2.9l-5.05 .9" />
                                                            <path
                                                                d="M9 10a.5 .5 0 0 0 1 0v-1a.5 .5 0 0 0 -1 0v1a5 5 0 0 0 5 5h1a.5 .5 0 0 0 0 -1h-1a.5 .5 0 0 0 0 1" />
                                                        </svg>
                                                </figure>
                                            </div>
                                        </div>


                                        <h2 class="_h4 text-white"><?php echo e(__('messages.follow-us')); ?>!</h2>
                                        <div class="widget-content">
                                            <div class="images-outer clearfix">
                                                <!--Image Box-->
                                                <figure class="image-box w-imge-box">
                                                    <a href=" https://www.instagram.com/group_itg/" target="_blank">
                                                        <img src="<?php echo e(asset('images/icons/instagram.png')); ?>"
                                                            alt="">
                                                    </a>
                                                </figure>
                                                <!--Image Box-->
                                                <figure class="image-box w-imge-box">
                                                    <a href="https://www.facebook.com/GROUPITG/" target="_blank">
                                                        <img src="<?php echo e(asset('images/icons/facebook.png')); ?>"
                                                            alt="">
                                                    </a>
                                                </figure>
                                                <!--Image Box-->
                                                <figure class="image-box w-imge-box">
                                                    <a href=" https://www.linkedin.com/company/groupitg/mycompany/?viewAsMember=true"
                                                        target="_bank">
                                                        <img src="<?php echo e(asset('images/icons/linkedin.png')); ?>"
                                                            alt="">
                                                    </a>
                                                </figure>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </footer>

    </div>
    <!--End pagewrapper-->

    <!-- Search Popup -->
    <div class="search-popup">
        <button class="close-search style-two"><span class="fa fa-remove"></span></button>
        <button class="close-search"><span class="fa fa-arrow-up"></span></button>
        <form method="post" action="blog.html">
            <div class="form-group">
                <input type="search" name="search-field" value="" placeholder="Search Here" required="">
                <button type="submit"><i class="fa fa-search"></i></button>
            </div>
        </form>
    </div>
    <!-- End Header Search -->
    <script src="<?php echo e(asset('js/jquery.js')); ?>"></script>
    <script src="<?php echo e(asset('js/popper.min.js')); ?> "></script>
    <script src="<?php echo e(asset('js/bootstrap.min.js')); ?> "></script>
    <script src="<?php echo e(asset('js/jquery.mCustomScrollbar.concat.min.js')); ?> "></script>
    <script src="<?php echo e(asset('js/magnific-popup.min.js')); ?> "></script>
    <script src="<?php echo e(asset('js/appear.js')); ?> "></script>
    <script src="<?php echo e(asset('js/parallax.min.js')); ?> "></script>
    <script src="<?php echo e(asset('js/tilt.jquery.min.js')); ?> "></script>
    <script src="<?php echo e(asset('js/jquery.paroller.min.js')); ?>"></script>
    <script src="<?php echo e(asset('js/owl.js')); ?>"></script>
    <script src="<?php echo e(asset('js/wow.js')); ?>"></script>
    <script src="<?php echo e(asset('js/mixitup.js')); ?>"></script>
    <script src="<?php echo e(asset('js/odometer.js')); ?>"></script>
    <script src="<?php echo e(asset('js/slick.js')); ?>"></script>
    <script src="<?php echo e(asset('js/backToTop.js')); ?>"></script>
    <script src="<?php echo e(asset('js/jquery-ui.js')); ?>"></script>
    <script src="<?php echo e(asset('js/cursor-script.js')); ?>"></script>
    <script src="<?php echo e(asset('js/script.js')); ?>"></script>




    
    <?php echo \Livewire\Mechanisms\FrontendAssets\FrontendAssets::scripts(); ?>

    <script src="//cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <?php if (isset($component)) { $__componentOriginal8344cca362e924d63cb0780eb5ae3ae6 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal8344cca362e924d63cb0780eb5ae3ae6 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'livewire-alert::components.scripts','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('livewire-alert::scripts'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal8344cca362e924d63cb0780eb5ae3ae6)): ?>
<?php $attributes = $__attributesOriginal8344cca362e924d63cb0780eb5ae3ae6; ?>
<?php unset($__attributesOriginal8344cca362e924d63cb0780eb5ae3ae6); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal8344cca362e924d63cb0780eb5ae3ae6)): ?>
<?php $component = $__componentOriginal8344cca362e924d63cb0780eb5ae3ae6; ?>
<?php unset($__componentOriginal8344cca362e924d63cb0780eb5ae3ae6); ?>
<?php endif; ?>
    
    <?php echo $__env->yieldPushContent('scripts'); ?>


</body>

</html>
<?php /**PATH /var/www/html/group-itg.com/resources/views/layouts/general.blade.php ENDPATH**/ ?>