<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\BlogController;
use Illuminate\Support\Facades\Redirect;
use App\Http\Controllers\ProductController;
use App\Http\Controllers\MachineryController;
use App\Http\Controllers\ViewManagerController;

#general views
Route::controller(ViewManagerController::class)->group(function () {
    #home
    Route::get('/', 'home')->name('home.index');
    #about
    Route::get('/about', 'about')->name('about.index');
    #contact
    Route::get('/contact', 'contact')->name('contact.index');
    #partners
    Route::get('/partners', 'partners')->name('partners.index');
    #sitemap
    Route::get('/sitemap', 'sitemap')->name('sitemap.index');

});

#products
Route::controller(ProductController::class)->group(function () {
    Route::get('/products', 'index')->name('products.index');
    Route::get('/products/{sector:name}/sector', 'index')->name('products.sector');
});

#machinery
Route::controller(MachineryController::class)->group(function () {
    Route::get('/machinery', 'index')->name('machinery.index');
    Route::get('/machinery/new-machinery', 'newMachinery')->name('machinery.new-machinery');
    Route::get('/machinery/{category:name}/category', 'index')->name('machinery.category');
    Route::get('/machinery/{machine:name}/detail', 'show')->name('machinery.show');



    // Route::get('/machinery/used/{category}', 'used')->name('machinery.used');
    // Route::get('/machinery/used', 'used')->name('machinery.used');
});


#Blogs
Route::controller(BlogController::class)->group(function () {
    Route::get('/blogs', 'index')->name('blog.index');
    Route::get('/blogs/{blogCategory:name}', 'index')->name('blog.category');
    Route::get('/blogs/{blog:name}/detail', 'show')->name('blog.show');
});



#change of language
Route::get('/locale/{locale}', function ($locale) {
    session()->put('locale', $locale);
    return Redirect::back();
});


Route::fallback(function () {
    return response()->view('errors.404', [], 404);
});
