@if ($paginator->hasPages())
    <div class="styled-pagination" role="navigation">
        {{-- Previous Page Link --}}
        @if ($paginator->onFirstPage())
        <li class="next"> <a class="icon item disabled" aria-disabled="true" aria-label="@lang('pagination.previous')"><span class="fa fa-angle-left"></span></a></li>
        @else
        <li class="next">  <a class="icon item" href="{{ $paginator->previousPageUrl() }}" rel="prev" aria-label="@lang('pagination.previous')"> <span class="fa fa-angle-left"></span></a></li>
            
        @endif

        {{-- Pagination Elements --}}
        @foreach ($elements as $element)
            {{-- "Three Dots" Separator --}}
            @if (is_string($element))
            <li><a class="icon item disabled" >{{ $element }}</a></li> 
                {{-- <li><a href="#" aria-disabled="true">...</a></li> --}}
            @endif

            {{-- Array Of Links --}}
            @if (is_array($element))
                @foreach ($element as $page => $url)
                    @if ($page == $paginator->currentPage())
                    <li><a class="item active" href="{{ $url }}" aria-current="page">{{ $page }} </a></li>
                    @else
                    <li> <a class="item" href="{{ $url }}">{{ $page }}</a></li>
                    @endif
                @endforeach
            @endif
        @endforeach

        {{-- Next Page Link --}}
        @if ($paginator->hasMorePages())
        {{-- <li class="next"><a href="#"><span class="fa fa-angle-right"></span></a></li> --}}

        <li class="next"> <a class="icon item" href="{{ $paginator->nextPageUrl() }}" rel="next" aria-label="@lang('pagination.next')"><span class="fa fa-angle-right"></span></li> </a>
        @else
        <li class="next"><a class="icon item disabled" aria-disabled="true" aria-label="@lang('pagination.next')"><span class="fa fa-angle-right"></span></li> </a>
        @endif
    </div>
@endif
