@extends('layouts.general')

@section('main_content')
    {{-- nav --}}
    <section class="page-title" style="background-image: url('{{ asset('images/products/' . $selectedSector->img_banner) }}')"
        id="about">
        <h1 class="d-none">Our Exclusive Products - ITG Group</h1>
        <div class="auto-container">
            <ul class="bread-crumb clearfix">
                <li><a href="{{ route('home.index') }}">{{ __('messages.home') }} </a></li>
                <li>{{ __('messages.products') }} </li>
                <li>{{ $selectedSector->translation->name }} </li>
            </ul>
            <h2>{{ __('messages.title-products') }} </h2>
        </div>
    </section>

    {{-- SECTION OF PRODUCTS --}}
    <div class="sidebar-page-container">
        {{-- <div class="pattern-layer" style="background-image:url({{ asset('images/background/pattern-9.png') }})"></div> --}}
        <div class="auto-container">
            <div class="row clearfix">
                <!-- Sidebar Side -->
                <div class="sidebar-side left-sidebar col-lg-4 col-md-12 col-sm-12">
                    <aside class="sidebar sticky-top">
                        <!-- Service Widget -->
                        <div class="sidebar-widget service-widget">
                            <div class="widget-content bg-main-color">
                                <div class="sidebar-title">
                                    <h2 class="_h4 color-green1">{{ __('messages.sectors') }} </h2>
                                </div>
                                <ul class="service-list">
                                    @foreach ($sectors as $sector)
                                        <li class="current"><a
                                                class="{{ $sector->name == $selectedSector->name ? 'active-sector' : '' }}"
                                                href="{{ route('products.sector', $sector) }}">{{ $sector->translation->name }}
                                            </a></li>
                                    @endforeach
                                </ul>
                            </div>
                        </div>
                        <!-- Support Widget -->
                        <div class="sidebar-widget support-widget">
                            <div class="support-content">
                                <div class="title-box">
                                    <h2 class="_h4 text-white">{{ __('messages.product-title-form') }} </h2>
                                    <div class="text">{{ __('messages.product-subtitle-form') }} </div>
                                </div>
                                <!-- Support Form -->
                                <div class="support-form">
                                    @livewire('contact-products-post', ['dataDivision' => $division])
                                </div>
                            </div>
                        </div>
                        <!-- Download Widget -->
                        @if (in_array($selectedSector->name, $catalogue))
                            <div class="sidebar-widget download-widget">
                                <div class="widget-content">
                                    <div class="sidebar-title">
                                        <h2 class="_h4 color-green1">{{ __('messages.download-now') }} </h2>
                                    </div>
                                    <ul class="download-list">
                                        <li>
                                            <a data-toggle="modal" href="#" data-target="#catalogueContact">
                                                {{ __('messages.catalogue') }} <span class="icon flaticon-edit"></span>
                                            </a>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                            <!-- Modal para el formulario de registro -->
                        @else
                            <div class="sidebar-widget download-widget">
                                <div class="widget-content download-widget">
                                    <div class="sidebar-title">
                                        {{-- <h4>{{ __('messages.download-now') }} </h4> --}}
                                        <img src="{{ asset('images/products/img-catalog.jpeg') }}" alt="">
                                    </div>
                                    <ul class="download-list">
                                        <li><a href="https://textilecatalogues.group-itg.com" class="button-main"
                                                target="_blank"> {{ __('messages.btn-go-cataloge') }}
                                            </a>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        @endif


                    </aside>
                </div>
                <!-- Content Side -->
                <div class="content-side right-sidebar col-lg-8 col-md-12 col-sm-12">
                    <div class="service-detail">
                        <div class="inner-box">
                            <div class="image">
                                <img src="{{ asset('images/products/' . $selectedSector->image) }}" alt="" />
                            </div>
                            <div class="lower-content">
                                <h3>{{ $selectedSector->translation->name }} </h3>
                                <p class="color-r-black"> {!! nl2br(e($selectedSector->translation->description)) !!} </p>

                                @if (View::exists($selectedNameView))
                                    @include($selectedNameView)
                                @endif

                                    {{-- FREQUENTLY ASKED --}}
                                    <div class="accordion-outer">
                                        <div class="title-box">
                                            <h4>{{ __('messages.frequently-ask') }} </h4>
                                            <div class="text">{{ __('messages.frequently-ask-decription') }} </div>
                                        </div>
                                        <!-- Accordian Box -->
                                        <ul class="accordion-box">
                                            <!--Block-->
                                            <li class="accordion block">
                                                <div class="acc-btn">
                                                    <div class="icon-outer"><span class="icon icon-plus fa fa-plus"></span>
                                                        <span class="icon icon-minus fa fa-minus"></span>
                                                    </div>
                                                    {{ __('messages.frequenty-ask-1') }}
                                                </div>
                                                <div class="acc-content">
                                                    <div class="content">
                                                        <div class="text-ask-desk">{!! __('messages.frequenty-ask-desc-1') !!}
                                                        </div>
                                                    </div>
                                                </div>
                                            </li>
                                            <!--Block-->
                                            <li class="accordion block">
                                                <div class="acc-btn">
                                                    <div class="icon-outer"><span class="icon icon-plus fa fa-plus"></span>
                                                        <span class="icon icon-minus fa fa-minus"></span>
                                                    </div>
                                                    {{ __('messages.frequenty-ask-2') }}
                                                </div>
                                                <div class="acc-content">
                                                    <div class="content">
                                                        <div class="text-ask-desk">{!! __('messages.frequenty-ask-desc-2') !!}
                                                        </div>
                                                    </div>
                                                </div>
                                            </li>
                                            <!--Block-->
                                            <li class="accordion block">
                                                <div class="acc-btn">
                                                    <div class="icon-outer"><span class="icon icon-plus fa fa-plus"></span>
                                                        <span class="icon icon-minus fa fa-minus"></span>
                                                    </div>
                                                    {{ __('messages.frequenty-ask-3') }}
                                                </div>
                                                <div class="acc-content">
                                                    <div class="content">
                                                        <div class="text-ask-desk">{!! __('messages.frequenty-ask-desc-3') !!}
                                                        </div>
                                                    </div>
                                                </div>
                                            </li>
                                            <li class="accordion block">
                                                <div class="acc-btn">
                                                    <div class="icon-outer"><span class="icon icon-plus fa fa-plus"></span>
                                                        <span class="icon icon-minus fa fa-minus"></span>
                                                    </div>
                                                    {{ __('messages.frequenty-ask-4') }}
                                                </div>
                                                <div class="acc-content">
                                                    <div class="content">
                                                        <div class="text-ask-desk">{!! __('messages.frequenty-ask-desc-4') !!}
                                                        </div>
                                                    </div>
                                                </div>
                                            </li>
                                            <li class="accordion block">
                                                <div class="acc-btn">
                                                    <div class="icon-outer"><span class="icon icon-plus fa fa-plus"></span>
                                                        <span class="icon icon-minus fa fa-minus"></span>
                                                    </div>
                                                    {{ __('messages.frequenty-ask-5') }}
                                                </div>
                                                <div class="acc-content">
                                                    <div class="content">
                                                        <div class="text-ask-desk">{!! __('messages.frequenty-ask-desc-5') !!}
                                                        </div>
                                                    </div>
                                                </div>
                                            </li>
                                        </ul>

                                    </div>


                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>


    <!-- Products Section -->
    <section class="products-section mb-1">
        <div class="pattern-layer" style="background-image:url({{ asset('images/background/pattern-5.png') }})"></div>
        <div class="pattern-layer-two" style="background-image:url({{ asset('images/background/pattern-9.png') }})"></div>
        <div class="pattern-layer-three" style="background-image:url({{ asset('images/background/pattern-7.png') }})">
        </div>
        <div class="pattern-layer-four" style="background-image:url({{ asset('images/background/pattern-8.png') }})"></div>
        <div class="pattern-layer-five" style="background-image:url({{ asset('images/background/pattern-11.png') }})">
        </div>
        <div class="auto-container">
            {{-- POPULAR PRODUCTS --}}
            <div class="sec-title centered">
                <div class="title text-title2 text-uppercase color-blue1">{{ __('messages.popular-product') }} </div>
                <div class="px-5 d-flex justify-content-center">
                    <h4 class="text-white w-50  h4 font-weight-bold text-center">
                        {{ __('messages.popuplar-product-subtitle') }} </h4>
                </div>
            </div>
            <div class="products-carousel owl-carousel owl-theme">
                {{-- carousel --}}
                @foreach ($util->popularProductsHome as $key => $popularProduct)
                    <!-- Product Block -->
                    <div class="product-block">
                        <div class="inner-box">
                            <div class="color-layer"></div>
                            <div class="image-box">
                                <div class="image">
                                    <a href="javascript:void(0)"><img src="{{ $popularProduct->img }}"
                                            alt="Popular product image" /></a>
                                </div>
                            </div>
                            <div class="lower-box clearfix mt-4 m-0">
                                <h4><a class="color-black1 text-capitalize" style="color: #000000 !important;"
                                        href="javascript:void(0)">{{ __('messages.products-' . $key) }} </h3>
                            </div>
                            <div class="btn-box text-center">
                                <a class="read-more bg-green3 text-uppercase"
                                    href="{{ route('contact.index') }}#contactform">{{ __('messages.order-now') }}
                                    <span class="flaticon-next-3"></span></a>
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>
            {{-- END POPULAR PRODUCTS --}}
        </div>
    </section>
@endsection

@push('styles')
    <style>
        .btn-style-one {
            background-color: var(--color-green-one);
        }

        .products-section2 {
            padding: 50px 0px 50px;
        }

        .flaticon-left-arrow {
            color: black;
        }

        .owl-next {
            color: black;

        }

        .products-section .owl-dots .owl-dot span {
            color: black;
        }

        .products-section .owl-dots .owl-dot span:after {
            color: black;
        }

        .products-section .owl-dots .owl-dot:hover span,
        .products-section .owl-dots .owl-dot.active span {
            color: var(--color-green-one);
        }

        .product-block .inner-box .image {
            box-shadow: none;
        }

        .product-block .inner-box .color-layer:before {
            background: none;
        }

        .product-block .inner-box .image-box:before {
            background: none;

        }

        .products-section3 {
            background-color: var(--color-background-body) !important;
        }

        .color-layer2 {
            background-color: var(--color-background-body) !important;
        }

        .image2 {
            background-color: var(--color-background-body) !important;
        }



        @media only screen and (max-width: 767px) {


            .products-carousel3 {
                width: 70%;
            }

            .products-section3 {
                justify-content: center;
                display: flex;
            }

        }
    </style>
@endpush


@if (in_array($selectedSector->name, $catalogue))
    @push('scripts')
        <x-modal modalId="catalogueContact" title="{{ __('messages.download-now') }}">
            @livewire('catalogue-contact-form', ['product_name' => $selectedSector->name, 'product_type' => 'product', 'dataDivision' => $division, 'urlCatalogue' => $selectedSector->cataloguePdf->pdf_catalogue ?? null])
        </x-modal>

        <script>
            $('#catalogueContact').on('hidden.bs.modal', function(e) {
                $(this).find('form').trigger('reset');
                $(this).find('.alert-danger').remove();
            });

            Livewire.on('postForm', function() {
                $('#catalogueContact').modal('hide');
                $('#catalogueContact').on('hidden.bs.modal', function() {
                    $(this).find('form').trigger('reset');
                });
            });
        </script>
    @endpush
@endif
