@extends('layouts.general')

@section('main_content')
    {{-- NAVIGATION --}}
    <section class="page-title"
        style="background-image: url({{ asset('/images/machinery/general/General-Machinery/Header.png') }}" id="about">
        <div class="auto-container">
            <h1 class="d-none">Sale of - {{ $machine->translation->name }}</h1>
            <ul class="bread-crumb clearfix">
                <li><a href="{{ route('home.index') }}">{{ __('messages.home') }} </a></li>
                <li> <a
                        href="{{ route('machinery.category', $machine->machineCategory) }}">{{ __('messages.machinery') }}</a>
                </li>
            </ul>
            <h2> {{ $machine->translation->name }} </h2>
        </div>
    </section>>
    <!-- End Page Title -->
    <div class="project-detail-section">
        <div class="auto-container">
            <!-- Upper Box -->
            <div class="upper-box">
                <div class="image">
                    <img src="{{ asset('images/' . $machine->main_image) }}" alt="" />
                </div>
                <!-- Info Box -->
                <div class="info-box">
                    <div class="title">{{ __('messages.details') }} </div>
                    <ul class="info-list list-value">
                        <p class="model-title">{{ __('messages.model') }} </p>
                        @if (
                            $machine->machineDetails->isEmpty() ||
                                $machine->machineDetails->every(fn($detail) => empty($detail->translation->description)))
                            <li class="color-black1"> {{ __('messages.no-detail') }}</li>
                        @else
                            @foreach ($machine->machineDetails as $detail)
                                @if (!empty($detail->translation->description))
                                    <li class="color-black1">{{ $detail->translation->description }}</li>
                                @endif
                            @endforeach
                        @endif
                    </ul>
                </div>
            </div>
            <!-- End Upper Box -->

            <!-- Middle Box -->
            <div class="middle-box">
                <h3> {{ $machine->translation->name }} </h3>
                <p> {{ $machine->translation->description }} </p>
                <div class="gallery-box">
                    <div class="row clearfix">
                        @foreach ($machine->machineImages as $image)
                            <div class="col-lg-4 col-md-4 col-sm-12">
                                <div class="image">
                                    <img src="{{ asset('images/' . $image->image) }}" alt="" />
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>

                @include('machinery.machinery-video')

                <h4>{{ __('messages.main-features') }} </h4>
                <div class="row clearfix">
                    @foreach ($machine->machineFeatures->chunk(ceil($machine->machineFeatures->count() / 2)) as $div)
                        <div class="col-lg-6 col-md-12 col-sm-12">
                            <ul class="option-list">
                                @foreach ($div as $feature)
                                    <li>{{ $feature->translation->description }} </li>
                                @endforeach
                            </ul>
                        </div>
                    @endforeach
                </div>
                @include('machinery.braiding-complementary')


                @if (in_array($machine->name, ['braiding-machines', 'needle-machines', 'winding-machines', 'tipping-machines']) &&
                        $division->name == 'mexico')
                    @include('components.agent.henghui')
                @endif




                @if (in_array($machine->name, ['sectional-warping-machine', 'direct-warping-machines']) &&
                        ($division->name == 'colombia' || $division->name == 'argentina'))
                    @include('components.agent.comsat')
                @endif


                <div>
                    <h3>{{ __('messages.more-information') }} </h3>
                    <div class="row py-3">
                        <div class="col-6 col-md-3">
                            <a href="#" data-toggle="modal" class="btn-web-catalog"
                                style="color: var(--white-color) !important;"
                                data-target="#catalogueContact">{{ __('messages.data-sheet') }} </a>

                        </div>
                        <div class="col-6 col-md-3">
                            <a class="btn-web-catalog" style="color: var(--white-color) !important;"
                                href="{{ route('contact.index') }}#contactform">{{ __('messages.ask-quotation') }} </a>
                        </div>
                    </div>

                    @if (in_array($machine->id, $representation))
                        <div class="welcome-section style-two">
                            <div class="row clearfix">
                                <!-- Content Column -->
                                <div class="content-column col-lg-7 col-md-7 col-sm-12">
                                    <div class="inner-column">
                                        <!-- Quality Box -->
                                        <div class="quality-box">
                                            <div class="quality-inner">
                                                <span class="icon flaticon-trophy-2"></span>
                                                <h4>{{ __('messages.offi-representation') }} </h4>
                                                <div class="text">{{ __('messages.offic-repre-text') }} </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endif
                </div>
            </div>
        </div>

        <!-- Modal para el formulario de descarga PDF-->
        <x-modal modalId="catalogueContact" title="{{ __('messages.download-now') }}">
            @livewire('catalogue-contact-form', ['product_name' => $machine->name, 'product_type' => 'machinery', 'dataDivision' => $division, 'urlCatalogue' => $machine->cataloguePdf->url ?? null])
        </x-modal>
    @endsection

    @push('styles')
        <style>
            .model-title {
                font-size: var(--font-20);
                font-weight: bold;
            }

            .btn-style-one {
                background-color: var(--color-green-one);
            }
        </style>
    @endpush



    @push('scripts')
        <script>
            $('#catalogueContact').on('hidden.bs.modal', function(e) {
                $(this).find('form').trigger('reset');
                $(this).find('.alert-danger').remove();
            });

            Livewire.on('postForm', function() {
                $('#catalogueContact').modal('hide');
                $('#catalogueContact').on('hidden.bs.modal', function() {
                    $(this).find('form').trigger('reset');
                });
            });
        </script>
    @endpush
