<div>

    <div wire:loading.flex style="display: none">
        <div class="cont-loader">
            <div class="loader"></div>
        </div>
    </div>

    <form wire:submit.prevent="store" novalidate="novalidate">

        <!-- Campo Nombre -->
        <div class="form-group mb-3">
            <label for="name" class="form-label color-dark">{{ __('messages.name') }} <span
                    class="text-danger">*</span></label>
            <input type="text" id="name" class="form-control" wire:model="name"
                placeholder="{{ __('messages.name') }} *">
            @error('name')
                <div class="alert alert-danger mt-2 rounded-lg">
                    {{ $message }}
                </div>
            @enderror
        </div>

        <!-- Campo País -->
        <div class="form-group mb-3">
            <label for="country" class="form-label color-dark">{{ __('messages.country') }} <span
                    class="text-danger">*</span></label>
            <input type="text" id="country" class="form-control" wire:model="country"
                placeholder="{{ __('messages.country') }} *">
            @error('country')
                <div class="alert alert-danger mt-2 rounded-lg">
                    {{ $message }}
                </div>
            @enderror
        </div>

        <!-- Campo Email -->
        <div class="form-group mb-3">
            <label for="email" class="form-label color-dark color-dark">{{ __('messages.email') }} <span
                    class="text-danger">*</span></label>
            <input type="email" id="email" class="form-control" wire:model="email"
                placeholder="{{ __('messages.email') }} *">
            @error('email')
                <div class="alert alert-danger mt-2 rounded-lg">
                    {{ $message }}
                </div>
            @enderror
        </div>

        <!-- Botón de envío -->
        <div class="form-group">
            <button type="submit" class="theme-btn btn-style-one text-white" style="padding: 8px 15px;"  wire:loading.attr="disabled">
                <span class="txt">{{ __('messages.send-message') }} </span>
            </button>
        </div>
    </form>
</div>



