@php
switch ($division->name) {
    case 'brasil':
        $data = $util->partnersBrazil;
        break;
    case 'argentina':
        $data = $util->partnersArgentina;
        break;
    case 'mexico':
        $data = $util->partnersMexico;
        break;
    case 'colombia':
        $data = $util->partnersColombia;
        break;
    default:
        $data = $util->partners;
        break;
}
@endphp

@foreach ($data as $partner)
<!-- Service Block Two -->
<div class="service-block-two">
    <div class="inner-box">
        <div class="image">

            <img src="{{ $partner->img }}" alt="Image Our Partners {{ $partner->id }}" />
            <div class="overlay-box">
                <span class="icon">
                    <img class="icon-center icon-partner" src="{{ $partner->icon }} "
                        alt="Icon {{ $partner->id }}">
                </span>
                <div class="content">
                    <h4>{{ $partner->title }} </h4>
                    <div class="title text-capitalize">{{ __('messages.partner-' . $partner->id) }}
                    </div>
                </div>
            </div>
            <div class="overlay-box-two">
                <span class="icon-two">
                    <img class="icon-center icon-partner" src="{{ $partner->icon }} "
                        alt="Icon {{ $partner->id }}">
                </span>
                <div class="overlay-inner">
                    <div class="overlay-content">
                        <p class="_h4">{{ __('messages.partner-' . $partner->id) }}</p>
                        <div class="text">{{ __('messages.partner-text-' . $partner->id) }} </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endforeach