@extends('layouts.general')

@section('main_content')
    {{-- nav --}}
    <section class="page-title" style="background-image:url({{ asset('images/blogs/Header-Blog.png') }})">
        <div class="auto-container">
            <h1 class="d-none"> Welcome to Our Blog - {{ $blog->translation->name }} </h1>
            <ul class="bread-crumb clearfix">
                <li><a href="{{ route('home.index') }}">{{ __('messages.home') }} </a></li>
                <li>{{ __('messages.blog-detail') }} </li>
            </ul>
            <h2>{{ $blog->translation->name }} </h2>
        </div>
    </section>
    <!-- End Page Title -->
    <!-- Sidebar Page Container -->
    <div class="sidebar-page-container">
        {{-- <div class="pattern-layer" style="background-image:url({{ asset('images/background/pattern-9.png') }})"></div> --}}
        <div class="auto-container">
            <div class="row clearfix">
                <!-- Content Side -->
                <div class="content-side col-lg-8 col-md-12 col-sm-12">
                    <!-- News Detail -->
                    <div class="news-detail">
                        <div class="inner-box">
                            <div class="image">
                                <img src="{{ asset('/images/blogs/' . $blog->image->image_large) }}" alt="" />
                            </div>
                            <div class="lower-content">
                                <ul class="post-info">
                                    <li>{{ $blog->blogCategory->translation->name }} </li>
                                    <li><span
                                            class="icon flaticon-calendar"></span>{{ $blog->created_at->format('M d, Y') }}
                                    </li>
                                    <li><span class="icon flaticon-user-2"></span>{{ $blog->views }} Views</li>
                                </ul>
                                <h3>{{ $blog->translation->name }}</h3>
                                {!! $blog->translation->description !!}
                                <div class="lower-content2">
                                </div>


                                <div class="gallery-box">
									<div class="row clearfix">
										<!-- Carousel Column -->
										<div class="carousel-column col-lg-6 col-md-6 col-sm-12">
											<div class="single-item-carousel owl-carousel owl-theme">
                                                @foreach ($blog->blogImages as $imageGallery)      
												<div class="slide">
													<div class="image">
														<img src="{{ asset('images/blogs/'. $imageGallery->name)}}" alt="{{$imageGallery->name}}" />
													</div>
												</div>
                                                @endforeach
											</div>
										</div>
									</div>
								</div>

                                {{-- <div class="gallery-box">
                                    <div class="row clearfix">
                                        <div class="carousel-column col-lg-6 col-md-6 col-sm-12">
                                            <div class="single-item-carousel owl-carousel owl-theme">
                                                @foreach ($blog->blogImages as $image)
                                                    <div class="slide">
                                                        <div class="image">
                                                            <img src="{{ asset('images/blogs/' . $image->image) }}"
                                                                alt="Image blog" />
                                                        </div>
                                                    </div>
                                                @endforeach
                                            </div>
                                        </div>

                                        <div class="video-column col-lg-6 col-md-6 col-sm-12">
                                            <div class="video-box-two">
                                                <figure class="video-image">
                                                    <img class="transition-500ms"
                                                        src="{{ asset('images/blogs/' . $blog->image->image) }}"
                                                        alt="">
                                                </figure>
                                                <a href="https://www.youtube.com/watch?v=kxPCFljwJws"
                                                    class="lightbox-video overlay-box"><span
                                                        class="flaticon-media-play-symbol transition-900ms"><i
                                                            class="ripple"></i></span></a>
                                            </div>
                                        </div>

                                    </div>
                                </div> --}}
                            </div>
                            <!-- Post Share Options-->
                            <div class="post-share-options px-3">
                                <div class="post-share-inner clearfix">
                                    {{-- <div class="tags"><span class="tags">{{ __('messages.tags') }} </span>
                                        @foreach ($blog->blogTags as $tag)
                                            <a href="#">{{ $tag->translation->name }} </a>
                                        @endforeach
                                    </div> --}}
                                    <ul class="social-box">
                                        <span class="share">{{ __('messages.share-article') }} </span>
                                        <li><a href="https://www.facebook.com/sharer/sharer.php?u={{ urlencode(url()->current()) }}"
                                                target="_blank"><span class="fa fa-facebook-f"></span></a></li>
                                        <li>
                                            <a href="https://www.linkedin.com/sharing/share-offsite/?url={{ urlencode(url()->current()) }}"
                                                target="_blank"><span class="fa fa-linkedin"></span></a>
                                            </li>
                                        <li><a href="https://api.whatsapp.com/send?text=ITG%20Blog%20{{ urlencode(url()->current()) }}"
                                                target="_blank"><span class="fa fa-whatsapp f-size-10"></span></a></li>
                                        {{-- <li><a href="http://pinterest.com/pin/create/button/?url=URL_DE_TU_BLOG&media=URL_DE_LA_IMAGEN&description=Descripción%20de%20la%20imagen" target="_blank">><span class="fa fa-pinterest-p"></span></a></li> --}}
                                    </ul>
                                </div>
                            </div>
                            <!-- End Post Share Options-->
                        </div>
                    </div>
                    <!-- Related Post -->
                    {{-- @if ($blogsRel->count())
                        <div class="related-posts">
                            <h4>{{ __('messages.related-post') }} </h4>
                            <div class="related-post-carousel owl-carousel owl-theme">
                                @foreach ($blogsRel as $blogrel)
                                    <!-- News Block Three -->
                                    <div class="news-block-three">
                                        <div class="inner-box wow fadeInLeft" data-wow-delay="0ms"
                                            data-wow-duration="1500ms">
                                            <div class="image">
                                                <a href="blog-detail.html"><img
                                                        src="{{ asset('images/blogs/' . $blogrel->image->image) }}"
                                                        alt="" /></a>
                                            </div>
                                            <div class="lower-content">
                                                <ul class="post-info">
                                                    <li><span
                                                            class="icon flaticon-calendar"></span>{{ $blogrel->created_at->format('M d, Y') }}
                                                    </li>
                                                    <li><span class="icon flaticon-user-2"></span>{{ $blogrel->views }}
                                                    </li>
                                                </ul>
                                                <h4><a href="javascript:void(0)">{{ $blogrel->translation->name }} </a>
                                                </h4>
                                                <a class="explore"
                                                    href="{{ route('blog.show', $blogrel) }}">{{ __('messages.explore-more') }}
                                                    <span class="flaticon-plus"></span></a>
                                            </div>
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                        </div>
                    @endif --}}
                    <!-- End Related Post -->
                </div>
                <!-- Sidebar Side -->
                @include('blogs.blog-nav-right')
            </div>
        </div>
    </div>
@endsection

@push('styles')
    <style>
        .f-size-10 {
            font-size: 20px;
        }

        .lower-content2 span {
            color: var(--color-five) !important;
            font-weight: 400;
            text-decoration: auto;
        }
    </style>
@endpush
