<div class="sidebar-side col-lg-4 col-md-12 col-sm-12">
    <aside class="sidebar padding-left sticky-top">
        <!-- Search -->
        <div class="sidebar-widget search-box">
            <form method="GET" action="{{ route('blog.index') }}">
                <div class="form-group">
                    <input type="search" name="query" placeholder="{{ __('messages.search-here') }}"   value="{{$query ?? null}}" >
                    <button type="submit"><span class="icon fa fa-search"></span></button>
                </div>
            </form>
        </div>
        <!-- Service Widget -->
        <div class="sidebar-widget service-widget">
            <div class="widget-content">
                <div class="sidebar-title-two">
                    <h4>{{ __('messages.categories') }} </h4>
                </div>
                <ul class="service-list-two">
                    @foreach ($categories as $category)
                        <li><a class="@if (isset($blogCategory) && $category->id == $blogCategory->id) active-category-blog font-weight-bold @endif"
                                href="{{ route('blog.category', $category) }} ">{{ $category->translation->name }}
                                <span>{{ $category->blogs_count }} </span></a></li>
                    @endforeach
                </ul>
            </div>
        </div>

        <!-- Popular Posts -->
        <div class="sidebar-widget popular-posts">
            <div class="widget-content">
                <div class="sidebar-title-two">
                    <h4>{{ __('messages.latest-post') }} </h4>
                </div>
                @foreach ($latestBlog as $latest)
                    <article class="post">
                        <figure class="post-thumb"><img src="{{ asset('images/blogs/' . $latest->image->image) }} "
                                alt=""><a href="{{ route('blog.show', $latest) }}" class="overlay-box"><span
                                    class="icon fa fa-link"></span></a></figure>
                        <div class="text"><a
                                href="{{ route('blog.show', $latest) }}">{{ $latest->translation->name }} </a>
                        </div>
                        <div class="post-info">{{ $latest->created_at->format('M d, Y') }} </div>
                    </article>
                @endforeach
            </div>
        </div>

        <!-- Archive Widget -->
        {{-- <div class="sidebar-widget service-widget">
            <div class="widget-content">
                <div class="sidebar-title-two">
                    <h4>{{ __('messages.blog-title-promotion') }} </h4>
                </div>
                <ul class="service-list-two">
                    <li><a href="#">November 2019 <span>5</span></a></li>
                    <li><a href="#">February 2020 <span>6</span></a></li>
                    <li><a href="#">September 2019 <span>8</span></a></li>
                </ul>
            </div>
        </div> --}}

        <!-- Gallery Widget -->
        {{-- <div class="sidebar-widget gallery-widget">
            <div class="widget-content">
                <div class="sidebar-title-two">
                    <h4>{{ __('messages.galery') }} </h4>
                </div>
                <div class="images-outer clearfix">
                    <!--Image Box-->
                    <figure class="image-box"><a class="lightbox-image" href="{{ asset('images/gallery/1.jpg') }}"><img
                                src="{{ asset('images/gallery/gallery-1.jpg') }}" alt=""></a></figure>
                    <!--Image Box-->
                    <figure class="image-box"><a class="lightbox-image" href="{{ asset('images/gallery/2.jpg') }}"><img
                                src="{{ asset('images/gallery/gallery-2.jpg') }}" alt=""></a></figure>
                    <!--Image Box-->
                    <figure class="image-box"><a class="lightbox-image" href="{{ asset('images/gallery/3.jpg') }}"><img
                                src="{{ asset('images/gallery/gallery-3.jpg') }}" alt=""></a></figure>
                    <!--Image Box-->
                    <figure class="image-box"><a class="lightbox-image" href="{{ asset('images/gallery/4.jpg') }}"><img
                                src="{{ asset('images/gallery/gallery-4.jpg') }}"" alt=""></a></figure>
                    <!--Image Box-->
                    <figure class="image-box"><a class="lightbox-image" href="{{ asset('images/gallery/5.jpg') }}"><img
                                src="{{ asset('images/gallery/gallery-5.jpg') }}" alt=""></a></figure>
                    <!--Image Box-->
                    <figure class="image-box"><a class="lightbox-image" href="{{ asset('images/gallery/6.jpg') }}"><img
                                src="{{ asset('images/gallery/gallery-6.jpg') }}" alt=""></a></figure>
                </div>
            </div>
        </div> --}}

        <!-- Tag Widget -->
        {{-- <div class="sidebar-widget popular-tags">
                <div class="widget-content">
                    <div class="sidebar-title-two">
                        <h4>Tag</h4>
                    </div>
                    <a href="#">Map</a>
                    <a href="#">Cloud</a>
                    <a href="#">Builder</a>
                    <a href="#">Tower</a>
                    <a href="#">Truck</a>
                </div>
            </div> --}}

    </aside>
</div>
