@extends('layouts.general')

@section('main_content')
    <div class="vertical-lines-wrapper" style=" z-index: -1;">
        <div class="vertical-lines">
            <div class="vertical-effect"></div>
            <div class="vertical-effect"></div>
            <div class="vertical-effect"></div>
            <div class="vertical-effect"></div>
            <div class="vertical-effect"></div>
            <div class="vertical-effect"></div>
        </div>
    </div>

    <!-- Page Title -->
    <section class="page-title" style="background-image: url({{ asset('images/resource/about-us/banner-About-us.jpg') }})"
        id="about">
        <h1 class="d-none">About Us: Who We Are and What We Do - ITG Group</h1>
        <div class="auto-container">
            <ul class="bread-crumb clearfix">
                <li><a href="{{ route('home.index') }}">{{ __('messages.home') }} </a></li>
                <li>{{ __('messages.about') }} </li>
            </ul>
            <h2>{{ __('messages.who-whe-are') }} </h2>
        </div>
    </section>
    <!--End Page Title-->

    <!-- Counter Section -->
    <section class="counter-section style-two" id="organization">
        <div class="auto-container">
            <!-- Sec Title -->
            <div class="sec-title alternate centered">
                <h2>{{ __('messages.who-whe-are') }} </h2>
            </div>
            <div class="row clearfix">
                <!-- Counter Column -->
                <div class="counter-column col-lg-4 col-md-6 col-sm-12">
                    <div class="inner-column">
                        <div class="icon-box">
                            <span class="icon">
                                <img class="mw-75" src="{{ asset('images/resource/about-us/Icono-1.png') }}"
                                    alt="Image offices">
                            </span>
                        </div>
                        <p class="_h4 color-green3"><span class="odometer" data-count="7"></span>
                            <br>{{ __('messages.about-who-card1-title') }} </h3>
                        <div class="counter-text text-dark">{{ __('messages.about-who-card1-subtitle') }} </div>
                    </div>
                </div>
                <!-- Counter Column -->
                <div class="counter-column col-lg-4 col-md-6 col-sm-12">
                    <div class="inner-column">
                        <div class="icon-box">
                            <span class="icon">
                                <img class="mw-75" src="{{ asset('images/resource/about-us/Icono-3.png') }}"
                                    alt="Image worldwide">
                        </div>
                        <p class="_h4 color-green3">+<span class="odometer" data-count="100"></span><br>
                            {{ __('messages.about-who-card2-title') }} </p>
                        <div class="counter-text text-dark">{{ __('messages.about-who-card2-subtitle') }} </div>
                    </div>
                </div>
                <!-- Counter Column -->
                <div class="counter-column col-lg-4 col-md-6 col-sm-12">
                    <div class="inner-column">
                        <div class="icon-box">
                            <span class="icon">
                                <img class="mw-75" src="{{ asset('images/resource/about-us/Icono-2.png') }}"
                                    alt="Image our portfolio">
                            </span>
                        </div>
                        <p class="_h4 color-green3">+<span class="odometer" data-count="20000"></span><br>
                            {{ __('messages.about-who-card3-title') }}</p>
                        <div class="counter-text text-dark">{{ __('messages.about-who-card3-subtitle') }} </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- End Counter Section -->
    <!-- Weaving Success together -->
    <section class="welcome-section style-two">
        <div class="pattern-layer-two" style="background-image:url(images/icons/shape-3.png)"></div>
        <div class="auto-container">
            <div class="row clearfix">
                <!-- Image Column -->
                <div class="image-column col-lg-6 col-md-12 col-sm-12">
                    <div class="inner-column">
                        <div class="image wow rollIn" data-wow-delay="0ms" data-wow-duration="1500ms">
                            <img src="{{ asset('images/resource/about-us/Giamminola-Brothers.jpg') }}" alt="" />
                        </div>
                    </div>
                </div>
                <!-- Content Column -->
                <div class="content-column col-lg-6 col-md-12 col-sm-12">
                    <div class="inner-column text-dark">
                        <!-- Sec Title Three -->
                        <div class="sec-title-three">
                            <div class="title"><span> {{ __('Weaving') }}
                                </span>{{ __('messages.success-together') }} </div>
                            <h3 class="_h2"> {{ __('messages.about-subtitle-about') }} </h3>
                            <div class="text">{{ __('messages.about-text-about') }} </div>
                        </div>
                        <div class="row clearfix">
                            <div class="col-lg-6 col-md-6 col-sm-12">
                                <ul class="list">
                                    <li>{{ __('messages.about-list-text1') }} </li>
                                    <li>{{ __('messages.about-list-text2') }} </li>
                                </ul>
                            </div>
                            <div class="col-lg-6 col-md-6 col-sm-12">
                                <ul class="list">
                                    <li>{{ __('messages.about-list-text3') }} </li>
                                    <li>{{ __('messages.about-list-text4') }} </li>
                                </ul>
                            </div>
                        </div>
                        <!-- Quality Box -->
                        <div class="quality-box">
                            <a href="{{ route('products.sector', 'itg-line') }}">
                                <div class="quality-inner">
                                    <h3 class="text-white text-uppercase" style="font-size: 25px;">
                                        {{ __('messages.about-title-card-about') }} </h3>
                                </div>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- End Welcome Section -->
    <!-- Approach Section -->
    <section class="approach-section">
        <div class="auto-container">
            <!-- Sec Title Three -->
            <div class="sec-title alternate centered mb-90px">
                <div class="title text-white">{{ __('messages.about-title-approch') }} </div>
                <h2 class="color-yellow1">{{ __('messages.about-subtitle-approch') }} </h2>
            </div>
            <div class="row clearfix">
                @foreach ($util->ourValuesAbout as $key => $value)
                    <!-- Approach Block -->
                    <div class="approach-block col-lg-4 col-md-6 col-sm-12">
                        <div class="inner-box wow fadeInLeft" data-wow-delay="0ms" data-wow-duration="1500ms">
                            <div class="image">
                                <a href="javascript:void(0)"><img src="{{ $value->img }}" alt="" /></a>
                            </div>
                            <div class="lower-content p-2">
                                <h3 class="_h4"><a href="javascript:void(0)">{{ __('messages.' . $value->name) }}
                                    </a></h3>
                                <div class="text">
                                    @if ($key == 'our-values')
                                        <ul class="list-value list-unstyled text-justify px-3">
                                            <li> {{ __('messages.' . $value->text . '1') }} </li>
                                            <li> {{ __('messages.' . $value->text . '2') }} </li>
                                            <li> {{ __('messages.' . $value->text . '3') }}</li>
                                            <li> {{ __('messages.' . $value->text . '4') }}</li>
                                        </ul>
                                    @else
                                        {{ __('messages.' . $value->text) }}
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>
        </div>
    </section>
    <!-- End Approach Section -->
    <section class="clients-section">
        <div class="auto-container">
            <!-- Sec Title Three -->
            <div class="sec-title alternate centered">
                <h2 class="text-capitalize">{{ __('messages.about-title-divisions') }} </h2>
            </div>
            <div class="carousel-outer">
                <!-- Sponsors Slider -->
                <ul class="sponsors-carousel owl-carousel owl-theme">
                    @foreach ($util->divisionsHome as $key => $divisions)
                        <li>
                            <div class="image-box"><a href="{{ $divisions->url }}">
                                    <p class="text-division">{{ __('messages.division-' . $key) }} </p>
                                </a></div>
                        </li>
                    @endforeach
                </ul>
            </div>
        </div>
    </section>
    @include('about.history')
    @include('about.people')
@endsection





@push('styles')
    <link rel="stylesheet" href="{{ asset('css/timeline.css') }}">
    <style>
        /* .w-80{
                width: 100%;;
            } */
        .mb-90px {
            margin-bottom: 90px;
        }

        .bg-text-timeline {
            font-weight: 600;
            background: var(--color-green-one);
            border-radius: 5px;
            padding: 10px;
        }

        .bg-text-timeline p {
            color: var(--white-color);
        }

        .clients-section .owl-theme .image-box {
            padding: 10px;
            text-align: center;
            background: var(--color-r-black) !important;
        }

        .text-division {
            color: var(--color-msb);
            font-size: var(--font-30);
            font-weight: bold;
            margin: 10px;
        }

        .mw-75 {
            max-width: 75%;
        }

        .welcome-section .content-column .quality-box {
            background-color: var(--color-green-one);
            width: 70%;
        }

        .welcome-section .content-column .quality-box .quality-inner {
            padding: 0;
            display: flex;
            justify-content: center;
        }

        .center-div {
            width: 60%;
            text-align: center;
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            margin: 0;
        }
    </style>
@endpush

@push('scripts')
    <script src="{{ asset('/js/timeline.js') }}"></script>
@endpush
