<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Faker\Factory as Faker;


class ProductTranslationSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {


        // Check if we are sowing or reversing
        $rollback = env('SEED_ROLLBACK', false);

        if ($rollback) {
            // Temporarily disable foreign key restrictions
            DB::statement('SET FOREIGN_KEY_CHECKS = 0;');
            // Truncate all product_translations
            DB::table('product_translations')->truncate();
        } else {
            $faker = Faker::create();

            $products = DB::table('products')->pluck('id')->toArray();
            $languages = DB::table('languages')->pluck('id')->toArray();
            foreach ($products as $product) {
                foreach ($languages as $language) {
                    DB::table('product_translations')->insert([
                        // 'id' => $index,
                        'name' => $faker->word,
                        'description' => $faker->sentence,
                        'product_id' => $product,
                        'language_id' => $language,
                        'created_at' => now(),
                        'updated_at' => now(),
                    ]);
                }
            }
        }
    }
}
