<?php

namespace Database\Seeders;

// use Faker\Factory as Faker;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;

class ProductImageSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Check if we are sowing or reversing
        $rollback = env('SEED_ROLLBACK', false);

        if ($rollback) {
            // Temporarily disable foreign key restrictions
            DB::statement('SET FOREIGN_KEY_CHECKS = 0;');
            // Truncate all products
            DB::table('products')->truncate();
        } else {
            // $faker = Faker::create();
            $products = DB::table('products')->pluck('id')->toArray();

            foreach ($products as $product) {
                foreach (range(1, 4) as $index) {
                    DB::table('product_images')->insert([
                        // 'id' => $index,
                        'image' => "asd132er123eqsdaadsdasd12e1dadsdfdst3456745ye.jpg",
                        'product_id' =>  $product,
                        'created_at' => now(),
                        'updated_at' => now(),
                    ]);
                }
            }
        }
    }
}
