<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
// use Faker\Factory as Faker;

class ProductCategoryTranslationSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {

        // Check if we are sowing or reversing
        $rollback = env('SEED_ROLLBACK', false);

        if ($rollback) {
            // Temporarily disable foreign key restrictions
            DB::statement('SET FOREIGN_KEY_CHECKS = 0;');
            // Truncate all product_category_translations
            DB::table('product_category_translations')->truncate();
        } else {
            // $faker = Faker::create();
            // $products = DB::table('product_categories')->pluck('id')->toArray();
            // $languages = DB::table('languages')->pluck('id')->toArray();

            //? languageS -------------   [1] = Español, [2] 2 = Inglés, [3]  3 = Italiano, [4]  4 = Portugués, [5]   5 = Francés, [6]  6 = Chino ------------------------------


            $categories = [
                '1' => [
                    'name' => [
                        "Repuestos para telares de lanzadera",    // Español
                        "Rapier Loom spare parts",    // Inglés
                        "Ricambi per telai a pinza",    // Italiano
                        "Peças de reposição para tear de lançadeira",    // Portugués
                        "Pièces détachées pour métiers à rapière",    // Francés
                        "剑杆织机备件",    // Chino
                    ],
                    'description' => [
                        "Nuestra oferta para telares de lanzadera consiste en una amplia gama de pinzas, cintas, perfiles de carbono, ruedas dentadas, cuchillas, repuestos electrónicos y más.",    // Español
                        "Our offer for rapier looms consists of a wide range of grippers, tapes, carbon profiles, sprocket wheels, blades, electronic spare parts and more.",    // Inglés
                        "La nostra offerta per telai a pinza comprende una vasta gamma di pinze, nastri, profili in carbonio, ruote dentate, lame, ricambi elettronici e altro ancora.",    // Italiano
                        "Nossa oferta para teares de lançadeira consiste em uma ampla gama de pinças, fitas, perfis de carbono, rodas dentadas, lâminas, peças eletrônicas de reposição e muito mais.",    // Portugués
                        "Notre offre pour métiers à rapière comprend une large gamme de pinces, bandes, profils en carbone, roues dentées, lames, pièces de rechange électroniques et plus encore.",    // Francés
                        "我们提供的剑杆织机零部件包括各种类型的夹具、带子、碳纤维型材、链轮、刀片、电子备件等。",    // Chino
                    ],
                ],
                '2' => [
                    'name' => [
                        "Repuestos para telares de lanzadera",    // Español
                        "Rapier Loom spare parts",    // Inglés
                        "Ricambi per telai a pinza",    // Italiano
                        "Peças de reposição para tear de lançadeira",    // Portugués
                        "Pièces détachées pour métiers à rapière",    // Francés
                        "剑杆织机备件",    // Chino
                    ],
                    'description' => [
                        "Para la inserción de trama con chorro de aire y chorro de agua, nuestra oferta comprende diferentes productos como boquillas principales, boquillas secundarias, válvulas solenoides, kits de pistones y las recientemente desarrolladas boquillas de ahorro de energía, así como accesorios electrónicos. Para más información, por favor contacte a su representante de ventas de ITG más cercano.",    // Español
                        "For airjet and water jet weft insertion, our offer comprises different products like main nozzles, secondary nozzles, solenoid valves, piston kits and the recently developed energy saving nozzles as well as electronic accessories. For more information, please contact your nearest ITG Sales Representative.",    // Inglés
                        "Per l'inserimento della trama a getto d'aria e getto d'acqua, la nostra offerta comprende diversi prodotti come ugelli principali, ugelli secondari, valvole solenidi, kit pistoni e i recentemente sviluppati ugelli a risparmio energetico, nonché accessori elettronici. Per ulteriori informazioni, contattare il rappresentante di vendita ITG più vicino.",    // Italiano
                        "Para inserção de trama com jato de ar e jato de água, nossa oferta compreende diferentes produtos como bicos principais, bicos secundários, válvulas solenóides, kits de pistão e os recentemente desenvolvidos bicos de economia de energia, bem como acessórios eletrônicos. Para mais informações, por favor, entre em contato com o representante de vendas da ITG mais próximo.",    // Portugués
                        "Pour l'insertion de trame à jet d'air et à jet d'eau, notre offre comprend différents produits comme les buses principales, les buses secondaires, les électrovannes, les kits de piston et les buses économes en énergie récemment développées, ainsi que des accessoires électroniques. Pour plus d'informations, veuillez contacter votre représentant commercial ITG le plus proche.",    // Francés
                        "对于空气喷射和水喷射引纬，我们的产品包括主喷嘴、辅助喷嘴、电磁阀、活塞套件以及新开发的节能喷嘴和电子配件。更多信息，请联系您最近的ITG销售代表。",    // Chino
                    ],
                ],
                '3' => [
                    'name' => [
                        "Repuestos para telares de proyectiles",
                        "Projectile Loom spare parts",
                        "Ricambi per telai a proiettile",
                        "Peças de reposição para teares de projéteis",
                        "Pièces de rechange pour métiers à projectile",
                        "投梭织机备件",
                    ],
                    'description' => [
                        "Presentamos un portafolio de productos especializado en piezas de inserción de trama para telares de proyectiles: proyectiles, pinzas, zapatilla de lanzadera, eslabón de lanzadera, bloques de guía dentada, frenos, entre otros.",
                        "We present a specialized product portfolio of weft-insertion parts for projectile looms: projectiles, grippers, picking-shoe, picking-link, guide-tooth blocks, brakesining, among others.",
                        "Presentiamo un portafoglio di prodotti specializzato in parti per l'inserimento della trama per telai a proiettile: proiettili, pinze, scarpa di lancio, collegamento di lancio, blocchi guida dentati, freni, tra gli altri.",
                        "Apresentamos um portfólio de produtos especializado em peças de inserção de trama para teares de projéteis: projéteis, pinças, sapata de lançamento, elo de lançamento, blocos de guia dentada, freios, entre outros.",
                        "Nous présentons un portefeuille de produits spécialisé dans les pièces d'insertion de trame pour métiers à projectiles : projectiles, pinces, semelle de lanceur, liaison de lanceur, blocs de guide-dent, freins, entre autres.",
                        "我们提供用于投梭织机的专用纬纱插入部件产品组合：投梭、夹钳、梭鞋、梭链、导齿块、制动器等。",
                    ],
                ],
                '4' => [
                    'name' => [
                        "Repuestos para jacquard, dobby y movimiento de levas",
                        "Jacquard, dobby and cam motion spare parts",
                        "Ricambi per jacquard, ratiera e movimento a camme",
                        "Peças de reposição para jacquard, dobby e movimento de cames",
                        "Pièces de rechange pour jacquard, dobby et mouvement à cames",
                        "提花机、多臂机和凸轮运动备件",
                    ],
                    'description' => [
                        "Cuando se trata de máquinas textiles, incluso las piezas más pequeñas son necesarias para el correcto proceso de tejido, pero el trabajo más importante del telar depende de su movimiento. Es por eso que ofrecemos repuestos para jacquard, repuestos para dobby, repuestos para el movimiento de levas y palancas.",
                        "When it comes to textile machines, even the smallest parts are necessary for the correct weaving process, but the most important work of the loom relies on its movement. That is why we offer jacquard spare parts, dobby spare parts, cam motion spare parts and levers.",
                        "Quando si tratta di macchine tessili, anche le parti più piccole sono necessarie per il corretto processo di tessitura, ma il lavoro più importante del telaio dipende dal suo movimento. Ecco perché offriamo ricambi per jacquard, ricambi per dobby, ricambi per il movimento a camme e leve.",
                        "Quando se trata de máquinas têxteis, até as menores peças são necessárias para o correto processo de tecelagem, mas o trabalho mais importante do tear depende de seu movimento. É por isso que oferecemos peças de reposição para jacquard, peças de reposição para dobby, peças de reposição para movimento de cames e alavancas.",
                        "En ce qui concerne les machines textiles, même les plus petites pièces sont nécessaires pour le bon déroulement du processus de tissage, mais le travail le plus important du métier à tisser repose sur son mouvement. C'est pourquoi nous proposons des pièces de rechange pour jacquard, des pièces de rechange pour dobby, des pièces de rechange pour mouvement de cames et des leviers.",
                        "对于纺织机械而言，即使是最小的部件也是正确织造过程所必需的，但织机最重要的工作依赖于其运动。因此，我们提供提花机备件、多臂机备件、凸轮运动备件和杠杆。",
                    ],
                ],
                '5' => [
                    'name' => [
                        'general-spareparts-title' => "Repuestos Generales",    // Español
                        'general-spareparts-title' => "General spare parts",    // Inglés
                        'general-spareparts-title' => "Ricambi Generali",    // Italiano
                        'general-spareparts-title' => "Peças de Reposição Gerais",    // Portugués
                        'general-spareparts-title' => "Pièces de Rechange Générales",    // Francés
                        'general-spareparts-title' => "通用备件",    // Chino
                    ],
                    'description' => [
                        "La gama de repuestos generales ofrecidos por ITG GROUP consiste en marcos, cuchillas, sensores, pantallas, pantallas táctiles, membranas, frenos de embrague, filtros de aceite y componentes electrónicos, así como una amplia variedad de piezas mecánicas.",    // Español
                        "The general spare parts range offered by ITG GROUP consists of frames, blades, sensors, displays, touch screens, membranes, clutch brakes, oil filters and electronic as well as a wide variety of mechanical parts.",    // Inglés
                        "La gamma di ricambi generali offerti da ITG GROUP consiste in telai, lame, sensori, display, schermi tattili, membrane, freni a frizione, filtri dell'olio e componenti elettronici, oltre a un'ampia varietà di parti meccaniche.",    // Italiano
                        "In gama de peças de reposição gerais oferecidas pelo ITG GROUP consiste em estruturas, Tesouras, sensores, displays, telas sensíveis ao toque, membranas, freios de embreagem, filtros de óleo e componentes eletrônicos, bem como uma ampla variedade de peças mecânicas.",    // Portugués
                        "La gamme de pièces de rechange générales offertes par ITG GROUP comprend des cadres, des lames, des capteurs, des écrans, des écrans tactiles, des membranes, des freins d'embrayage, des filtres à huile et des composants électroniques ainsi qu'une large variété de pièces mécaniques.",    // Francés
                        "ITG GROUP 提供的通用备件范围包括框架、刀片、传感器、显示器、触摸屏、膜片、离合器制动器、机油滤清器和电子元件以及各种机械部件。",    // Chino
                    ],
                ],
                '6' => [
                    'name' => [
                        "Repuestos para Máquinas Circulares",    // Español
                        "Circular Machine Spareparts",    // Inglés
                        "Ricambi per Macchine Circolari",    // Italiano
                        "Peças de Reposição para Máquinas Circulares",    // Portugués
                        "Pièces de Rechange pour Machines Circulaires",    // Francés
                        "圆形机备件",    // Chino
                    ],
                    'description' => [
                        "Tenemos repuestos para diferentes tipos de telares circulares como single jersey, double jersey, interlock, single jersey y jacquard.",    // Español
                        "We have spare parts for different types of circular looms such as single jersey, double jersey, interlock, single jersey and jacquard.",    // Inglés
                        "Disponiamo di ricambi per diversi tipi di telai circolari come single jersey, double jersey, interlock, single jersey e jacquard.",    // Italiano
                        "Temos peças de reposição para diferentes tipos de teares circulares, como single jersey, Teares duplos, interlock, single jersey e jacquard.",    // Portugués
                        "Nous avons des pièces de rechange pour différents types de métiers circulaires tels que le single jersey, le double jersey, l'interlock, le single jersey et le jacquard.",    // Francés
                        "我们为各种类型的圆形织机提供备件，如单面平针布、双面平针布、罗纹、单面平针布和提花机。",    // Chino
                    ],
                ],
                '7' => [
                    'name' => [
                        "Repuestos para Máquinas Planas",    // Español
                        "Flat Machine Spareparts",    // Inglés
                        "Ricambi per Macchine Piane",    // Italiano
                        "Peças de Reposição para Malharia Retilínea",    // Portugués
                        "Pièces de Rechange pour Machines Plates",    // Francés
                        "平织机备件",    // Chino
                    ],
                    'description' => [
                        "Desde piezas electrónicas hasta mecánicas, podemos proporcionar una amplia gama de repuestos para máquinas de tejer planas.",    // Español
                        "From electronical to mechanical parts we can provide a different range of spare parts for flat knitting machines.",    // Inglés
                        "Dalle parti elettroniche a quelle meccaniche, possiamo fornire una vasta gamma di ricambi per macchine di maglieria piane.",    // Italiano
                        "De peças eletrônicas a mecânicas, podemos fornecer uma ampla variedade de peças de reposição para máquinas de tricô planas.",    // Portugués
                        "Des pièces électroniques aux pièces mécaniques, nous pouvons fournir une gamme différente de pièces de rechange pour les machines à tricoter plates.",    // Francés
                        "从电子部件到机械部件，我们可以为平织机提供不同范围的备件。",    // Chino
                    ],
                ],
                '8' => [
                    'name' => [
                        "Repuestos para Máquinas de Urdimbre",    // Español
                        "Warp Machine Spareparts",    // Inglés
                        "Ricambi per Macchine di Ordito",    // Italiano
                        "Peças de Reposição para Malharia de Urdume",    // Portugués
                        "Pièces de Rechange pour Machines à Chaîne",    // Francés
                        "经纬机备件",    // Chino
                    ],
                    'description' => [
                        "Nuestros componentes ofrecen una solución indispensable para su producción textil. Ofrecemos una gama completa de agujas de ojal y pasadores para todos los principales OEM.",    // Español
                        "Our components provide an indispensable solution for your textile production. We offer a complete range of eyelet needles and sinkers for all leading OEMs.",    // Inglés
                        "I nostri componenti forniscono una soluzione indispensabile per la tua produzione tessile. Offriamo una gamma completa di aghi ad occhiello e maglie per tutti i principali OEM.",    // Italiano
                        "Nossos componentes fornecem uma solução indispensável para a sua produção têxtil. Oferecemos uma gama completa de agulhas de olhal e passadores para todos os principais OEMs.",    // Portugués
                        "Nos composants fournissent une solution indispensable pour votre production textile. Nous proposons une gamme complète d'aiguilles à œillet et de mailles pour tous les principaux OEM.",    // Francés
                        "我们的组件为您的纺织生产提供了不可或缺的解决方案。我们为所有主要的 OEM 提供完整的鞋眼针和沉头。",    // Chino
                    ],
                ],
                '9' => [
                    'name' => [
                        "Repuestos para Máquinas de Calcetines",    // Español
                        "Socks Machine Spareparts",    // Inglés
                        "Ricambi per Macchine Calzini",    // Italiano
                        "Peças de Reposição para Máquinas de Meias",    // Portugués
                        "Pièces de Rechange pour Machines à Chaussettes",    // Francés
                        "袜子机备件",    // Chino
                    ],
                    'description' => [
                        "Como parte de nuestra oferta, tenemos repuestos para máquinas de tejido circular de diferentes tipos como terciopelo, liso, entre otros.",    // Español
                        "As part of our offer, we have spare parts for circular knitting machines of different types such as terry, plain, among others.",    // Inglés
                        "Come parte della nostra offerta, disponiamo di ricambi per macchine circolari di diversi tipi come spugna, liscio, tra gli altri.",    // Italiano
                        "Como parte de nossa oferta, temos peças de reposição para máquinas de tricô circular de diferentes tipos, como felpa, liso, entre outros.",    // Portugués
                        "Dans le cadre de notre offre, nous proposons des pièces de rechange pour des machines à tricoter circulaires de différents types tels que le tissu éponge, lisse, entre autres.",    // Francés
                        "作为我们提供的一部分，我们为各种类型的循环针织机提供备件，如毛巾，普通等。",    // Chino
                    ],
                ],
                '10' => [
                    'name' => [
                        "Piezas Generales",    // Español
                        "General Parts",    // Inglés
                        "Parti Generali",    // Italiano
                        "Peças Gerais",    // Portugués
                        "Pièces Générales",    // Francés
                        "一般零件",    // Chino
                    ],
                    'description' => [
                        "Además de nuestras piezas de repuesto para tejido circular, tenemos accesorios y suministros para su proceso textil como hilo, lubricantes industriales, acetato, entre otros.",    // Español
                        "In addition to our spare parts for circular knitting, we have accessories and supplies for your textile process such as yarn, industrial lubricants, acetate, among others.",    // Inglés
                        "Oltre ai nostri pezzi di ricambio per maglieria circolare, abbiamo accessori e forniture per il tuo processo tessile come filato, lubrificanti industriali, acetato, tra gli altri.",    // Italiano
                        "Além de nossas peças de reposição para malharia circular, temos acessórios e suprimentos para o seu processo têxtil, como fios, lubrificantes industriais, acetato, entre outros.",    // Portugués
                        "En plus de nos pièces de rechange pour le tricot circulaire, nous disposons d'accessoires et de fournitures pour votre processus textile tels que le fil, les lubrifiants industriels, l'acétate, entre autres.",    // Francés
                        "除了我们的循环针织机备件外，我们还提供纺织过程中所需的配件和用品，如纱线，工业润滑油，醋酸酯等。",    // Chino
                    ],
                ],
                '11' => [
                    'name' => [
                        "Piezas y Accesorios Generales (Cubiertas de Cuerdas Acetato-Metálicas)",    // Español
                        "General Parts and Accessories (Acetato-Metallic string Covers)",    // Inglés
                        "Parti e Accessori Generali (Coperture per Corde Acetato-Metalliche)",    // Italiano
                        "Peças e Acessórios Gerais (Capas de Cordas Acetato-Metálicas)",    // Portugués
                        "Pièces et Accessoires Généraux (Couvertures de Cordes Acétate-Métalliques)",    // Francés
                        "一般零件和配件（醋酸酯金属线覆盖物）",    // Chino
                    ],
                    'description' => [
                        "¡Descubre nuestro acetato de alta calidad, hilo lurex en una variedad de colores y otros accesorios imprescindibles para llevar tus diseños al siguiente nivel - haz que tus trenzas destaquen con la excelencia del Grupo ITG!",    // Español
                        "Discover our high-quality acetate, lurex yarn in a range of colors and other must-have accessories to take your designs to the next level - make your braids stand out with ITG Group excellence!",    // Inglés
                        "Scopri il nostro acetato di alta qualità, filo lurex in una gamma di colori e altri accessori indispensabili per portare i tuoi design al livello successivo - fai risaltare le tue trecce con l'eccellenza del Gruppo ITG!",    // Italiano
                        "Descubra nosso acetato de alta qualidade, fio lurex em uma variedade de cores e outros acessórios indispensáveis para levar seus designs ao próximo nível - faça suas tranças se destacarem com a excelência do Grupo ITG!",    // Portugués
                        "Découvrez notre acétate de haute qualité, fil lurex dans une gamme de couleurs et autres accessoires indispensables pour amener vos créations au niveau supérieur - faites ressortir vos tresses avec l'excellence du Groupe ITG!",    // Francés
                        "发现我们高品质的醋酸酯，彩色锦纶线以及其他必备配件，将您的设计提升到一个新的水平 - 用ITG集团的卓越使您的编织品脱颖而出！",    // Chino
                    ],
                ],
                '12' => [
                    'name' => [
                        "Repuestos para Máquinas de Trenzado",    // Español
                        "Braiding Machine Spare parts",    // Inglés
                        "Ricambi per Macchine Intrecciatrici",    // Italiano
                        "Peças de Reposição para Máquinas de trançadeiras",    // Portugués
                        "Pièces de Rechange pour Machines à Tresser",    // Francés
                        "编织机备件",    // Chino
                    ],
                    'description' => [
                        "Mantenga sus máquinas de trenzado en óptimas condiciones con nuestros repuestos de alta calidad. Desde bobinas, carretes y otros, ofrecemos una amplia gama de repuestos diseñados para garantizar el rendimiento y la eficiencia de su equipo.",    // Español
                        "Keep your braiding machines in top condition with our high quality spare parts. From bobbins, spools, and others, we offer a wide range of spare parts designed to ensure the performance and efficiency of your equipment.",    // Inglés
                        "Mantieni le tue macchine intrecciatrici in ottime condizioni con i nostri ricambi di alta qualità. Dai bobine, rocchetti e altri, offriamo una vasta gamma di ricambi progettati per garantire le prestazioni e l'efficienza del tuo attrezzatura.",    // Italiano
                        "Mantenha suas máquinas de trançar em perfeitas condições com nossas peças de reposição de alta qualidade. De bobinas, carretéis e outros, oferecemos uma ampla gama de peças de reposição projetadas para garantir o desempenho e eficiência do seu equipamento.",    // Portugués
                        "Gardez vos machines à tresser en parfait état avec nos pièces de rechange de haute qualité. Des bobines, des bobines et autres, nous proposons une large gamme de pièces de rechange conçues pour garantir les performances et l'efficacité de votre équipement.",    // Francés
                        "使用我们的高质量备件，保持您的编织机处于最佳状态。 从线轴，线轮等，我们提供了一系列旨在确保您的设备性能和效率的备件。",    // Chino
                    ],
                ],

                // '9' => [
                //     'name' => [


                //     ],
                //     'description' => [


                //     ],
                // ],





            ];





            foreach ($categories as $key => $category) {
                foreach ($category['name'] as $index => $name) {
                    $description = $category['description'][$index];
                    DB::table('product_category_translations')->insert([
                        // 'id' => $index,
                        'name' => $name,
                        'description' =>  $description,
                        'product_category_id' => $key,
                        'language_id' =>  $index + 1,
                        'created_at' => now(),
                        'updated_at' => now(),
                    ]);
                }
            }
        }
    }
}
