<?php

namespace Database\Seeders;

// use Faker\Factory as Faker;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class ProductCategorySeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {

        // Check if we are sowing or reversing
        $rollback = env('SEED_ROLLBACK', false);

        if ($rollback) {
            // Temporarily disable foreign key restrictions
            DB::statement('SET FOREIGN_KEY_CHECKS = 0;');
            // Truncate all product_categories
            DB::table('product_categories')->truncate();
        } else {
            // $faker = Faker::create();
            $productSectors = DB::table('product_sectors')->pluck('id')->toArray();
            foreach ($productSectors as  $productSector) {
                foreach (range(1, 7) as $index) {
                    DB::table('product_categories')->insert([
                        // 'id' => $index,
                        'image' => "asd132er123eqsdaadsdasd12e1dadsdfdst3456745ye.jpg",
                        'product_sector_id' =>  $productSector,
                        'created_at' => now(),
                        'updated_at' => now(),
                    ]);
                }
            }
        }
    }
}
