<?php

namespace Database\Seeders;

// use Faker\Factory as Faker;
use Illuminate\Support\Str;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class MachineSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {

        // Check if we are sowing or reversing
        $rollback = env('SEED_ROLLBACK', false);

        if ($rollback) {
            // Temporarily disable foreign key restrictions
            DB::statement('SET FOREIGN_KEY_CHECKS = 0;');
            // Truncate all machines
            DB::table('machines')->truncate();
        } else {

            // $machineCategories = DB::table('machine_categories')->pluck('id')->toArray();
            // $faker = Faker::create();

            $machines = [
                //weaving
                [
                    'category' => 1,
                    'division' => 1,
                    'products' => [
                        //water loom
                        [
                            'id' => 1,
                            'main_image' =>  'machinery/weaving/Water-looms/4.png',
                            'name' => "Water-looms"
                        ],
                        //raiper looms
                        [
                            'id' => 2,
                            'main_image' =>  'machinery/weaving/Rapier-looms/RFRL31 Series.png',
                            'name' => "rapier looms"
                        ],
                        //terry looms
                        [
                            'id' => 3,
                            'main_image' =>  'machinery/weaving/Terry-looms/4.png',
                            'name' => "Terry looms"
                        ],
                        //aior looms
                        [
                            'id' => 4,
                            'main_image' =>  'machinery/weaving/Air-looms/4.png',
                            'name' => "Air looms"
                        ],
                        //Electronic Jacquard
                        [
                            'id' => 5,
                            'main_image' =>  'machinery/braiding/Electronic/Jacquard 1.png',
                            'name' => "Electronic Jacquard"
                        ],
                    ]
                ],
                //warping
                [
                    'category' => 2,
                    'division' => 1,
                    'products' => [
                        //sectional
                        [
                            'id' => 6,
                            'main_image' =>  'machinery/warping/Sectional/3.png',
                            'name' => "Sectional Warping Machine"
                        ],
                        //Direct
                        [
                            'id' => 7,
                            'main_image' =>  'machinery/warping/Direct/1.png',
                            'name' => "Direct Warping Machines"
                        ],
                    ]
                ],
                //Label weaving
                [
                    'category' => 3,
                    'division' => 1,
                    'products' => [
                        //labelWabin
                        [
                            'id' => 8,
                            'main_image' =>  'machinery/Label/Label-weaving/1.png',
                            'name' => "Label Weaving Machine"
                        ],
                        //narrow fabric
                        [
                            'id' => 9,
                            'main_image' =>  'machinery/Label/Narrow-fabric/1.png',
                            'name' => "Narrow Fabric Jacquard Loom"
                        ],
                        //Higt speed
                        [
                            'id' => 10,
                            'main_image' =>  'machinery/Label/High-speed/1.png',
                            'name' => "High-Speed Needle Loom"
                        ],
                        //Higt speed atomatic
                        [
                            'id' => 11,
                            'main_image' =>  'machinery/Label/High-speed-automatic/1.png',
                            'name' => "High-Speed Automatic Crochet Machine"
                        ],
                        //label y folding
                        [
                            'id' => 12,
                            'main_image' =>  'machinery/Label/Label-folding/1.png',
                            'name' => "Label & Folding machine"
                        ],
                        //ultrasonic
                        [
                            'id' => 13,
                            'main_image' =>  'machinery/Label/Ultrasonic/4.png',
                            'name' => "Ultrasonic"
                        ],
                    ]
                ],
                //kniting
                [
                    'category' => 4,
                    'division' => 1,
                    'products' => [
                        //Sock machine
                        [
                            'id' => 18,
                            'main_image' =>  'machinery/knitting/Sock-Machine/4.png',
                            'name' => "Sock machine"
                        ],
                        //sing jersey
                        [
                            'id' => 14,
                            'main_image' =>  'machinery/knitting/Single jersey/4.png',
                            'name' => "Single jersey"
                        ],
                        //interlock
                        [
                            'id' => 15,
                            'main_image' =>  'machinery/knitting/InterlockRib/1.png',
                            'name' => "Interlock/Rib"
                        ],
                        //single computer
                        [
                            'id' => 16,
                            'main_image' =>  'machinery/knitting/Single-computerized/3.png',
                            'name' => "Single computerized"
                        ],
                        //Double computer
                        [
                            'id' => 17,
                            'main_image' =>  'machinery/knitting/Double-computerized/1.png',
                            'name' => "Double computerized"
                        ],

                    ]
                ],
                //braiding
                [
                    'category' => 5,
                    'division' => 1,
                    'products' => [
                        //braiding maachibe
                        [
                            'id' => 19,
                            'main_image' =>  'machinery/braiding/Braiding/1.png',
                            'name' => "Braiding machines"
                        ],
                        //tiping machine
                        [
                            'id' => 20,
                            'main_image' =>  'machinery/braiding/Tipping/4.png',
                            'name' => "Tipping machines"
                        ],
                        //winding machine
                        [
                            'id' => 21,
                            'main_image' =>  'machinery/braiding/Winding/3.png',
                            'name' => "Winding machines"
                        ],
                        //needie machine
                        [
                            'id' => 22,
                            'main_image' =>  'machinery/braiding/Needle/1.png',
                            'name' => "Needle machines"
                        ],
                    ]
                ],
                //sizxing
                [
                    'category' => 6,
                    'division' => 1,
                    'products' => [
                        //Sising machine
                        [
                            'id' => 23,
                            'main_image' =>  'machinery/sizing/Sizing/4.png',
                            'name' => "Sizing Machine"
                        ],
                    ]
                ],
                //Finishing
                [
                    'category' => 7,
                    'division' => 1,
                    'products' => [
                        //Dye jigger
                        [
                            'id' => 25,
                            'main_image' =>  'machinery/Dyeing/Dyeing/Jigger.png',
                            'name' => "Jigger"
                        ],
                        //Stenter machine
                        [
                            'id' => 24,
                            'main_image' =>  'machinery/Dyeing/Stenter Machine/Stenter Machine.png',
                            'name' => "Stenter Machine"
                        ],

                    ]
                ],
            ];


            foreach ($machines as $machine) {
                $category = $machine['category'];
                $division = $machine['division'];

                foreach ($machine['products'] as $product) {
                    $image = $product['main_image'];
                    $name = $product['name'];
                    $id = $product['id'];

                    DB::table('machines')->insert([
                        'id' => $id,
                        'main_image' => $image,
                        'name' => Str::slug($name),
                        'machine_category_id' => $category,
                        'division_id' =>  $division,
                        'created_at' => now(),
                        'updated_at' => now(),
                    ]);
                }
            }
        }
    }
}
