<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
// use Faker\Factory as Faker;

class MachineFeatureTranslationSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {

        // Check if we are sowing or reversing
        $rollback = env('SEED_ROLLBACK', false);

        if ($rollback) {
            // Temporarily disable foreign key restrictions
            DB::statement('SET FOREIGN_KEY_CHECKS = 0;');
            // Truncate all machine_feature_translations
            DB::table('machine_feature_translations')->truncate();
        } else {
            // $faker = Faker::create();
            // $features = DB::table('machine_features')->pluck('id')->toArray();
            // $languages = DB::table('languages')->pluck('id')->toArray();


            $features = $this->data();




            foreach ($features as $key => $feature) {
                foreach ($feature["description"] as $index => $description) {
                    DB::table('machine_feature_translations')->insert([
                        // 'id' => $index,
                        'description' => $description,
                        'machine_feature_id' => $key,
                        'language_id' =>  $index + 1,
                        'created_at' => now(),
                        'updated_at' => now(),
                    ]);
                }
            }
        }
    }


    public function data()
    {
        return   [

            //water
            '1' => [
                'description' => [
                    "Los marcos altamente reforzados garantizan una inserción estable y un excelente rendimiento.",    // español
                    "Highly strengthened frames ensure stable insertion and excellent performance.",    // inglés
                    "Telai altamente rinforzati garantiscono un'inserto stabile e prestazioni eccellenti.",    // italiano
                    "Os quadros altamente reforçados garantem uma inserção estável e excelente desempenho.",    // portugués
                    "Les cadres fortement renforcés assurent une insertion stable et d'excellentes performances.",    // francés
                    "高度强化的框架确保稳定的插入和出色的性能。"    // chino
                ]
            ],


            '2' => [
                'description' => [
                    "Los nuevos boquillas de cerámica pueden mejorar la estabilidad de la inserción durante el funcionamiento a alta velocidad.",    // español
                    "New type ceramic nozzles can enhance the stability of insertion during high speed running.",    // inglés
                    "Le nuove bussole in ceramica possono migliorare la stabilità dell'inserimento durante il funzionamento ad alta velocità.",    // italiano
                    "Novos bicos de cerâmica melhoram a estabilidade da inserção durante a execução em alta velocidade.",    // portugués
                    "Les nouvelles buses en céramique peuvent améliorer la stabilité de l'insertion lors du fonctionnement à grande vitesse.",    // francés
                    "新型陶瓷喷嘴可以增强高速运行时的插入稳定性。"    // chino
                ]
            ],


            '3' => [
                'description' => [
                    "Es fácil para este tipo de telares tejer hilos finos y gruesos, tejidos estrechos y anchos.",    // español
                    "It is easy for this type of looms to weave finest and thickness yarns, narrow and wide fabrics.",    // inglés
                    "È facile per questo tipo di telai tessere filati fini e spessi, tessuti stretti e larghi.",    // italiano
                    "Sistema central de lubrificação",    // portugués
                    "Il est facile pour ce type de métiers à tisser de tisser des fils fins et épais, des tissus étroits et larges.",    // francés
                    "这种类型的织机很容易编织细和粗的纱线，窄幅和宽幅织物。"    // chino
                ]
            ],

            '4' => [
                'description' => [
                    "Servicio perfecto preventa, venta y posventa.",    // español
                    "Perfect service pre-sales, sales and after sales.",    // inglés
                    "Servizio perfetto pre-vendita, vendita e post-vendita.",    // italiano
                    "Pré alimentadores com WBS",    // portugués
                    "Service parfait prévente, vente et après-vente.",    // francés
                    "售前、销售和售后完美服务。"    // chino
                ]
            ],

            //rapier

            '5' => [
                'description' => [
                    "Diseñado para ahorrar energía, alta velocidad y alta eficiencia, baja vibración y bajo ruido.",    // español
                    "Designed for power saving, high-speed & high efficiency, low vibration & low noise.",    // inglés
                    "Progettato per il risparmio energetico, alta velocità e alta efficienza, bassa vibrazione e basso rumore.",    // italiano
                    "Projetado para economia de energia, alta velocidade e alta eficiência, baixa vibração e baixo ruído.",    // portugués
                    "Conçu pour économiser de l'énergie, haute vitesse et haute efficacité, faible vibration et faible bruit.",    // francés
                    "设计节省能源、高速高效、低振动低噪音。"    // chin
                ]
            ],

            '6' => [
                'description' => [
                    "Se puede ahorrar más del 15% de energía en comparación con los motores normales.",    // español
                    "More than 15% power can be saved than normal motors.",    // inglés
                    "Si può risparmiare più del 15% di energia rispetto ai motori normali.",    // italiano
                    "Mais de 15% de energia pode ser economizada em comparação com os motores normais.",    // portugués
                    "Plus de 15 % d'énergie peut être économisée par rapport aux moteurs normaux.",    // francés
                    "比普通电机节省15%以上的能量。"    // chino
                ]
            ],

            '7' => [
                'description' => [
                    "Motor directo en alta velocidad o cambio de velocidad escalonado.",    // español
                    "Direct motor in high speed or stepless speed change.",    // inglés
                    "Motore diretto ad alta velocità o cambio di velocità graduali.",    // italiano
                    "",    // portugués
                    "Moteur direct en haute vitesse ou changement de vitesse progressif.",    // francés
                    "高速或无级变速的直流电机。"    // chino
                ]
            ],

            '8' => [
                'description' => [
                    "Interfaz humanizada y amigable para los clientes que facilita una operación fácil y rápida.",    // español
                    "Humanized and friendly interface for customers make operation easy and quick.",    // inglés
                    "Interfaccia umanizzata e amichevole per i clienti che facilita un'operazione facile e veloce.",    // italiano
                    "Sistema de lubrificação centralizado.",    // portugués
                    "Interface humanisée et conviviale pour les clients rendant l'opération facile et rapide.",    // francés
                    "人性化和友好的界面，使客户操作简单快捷。"    // chino
                ]
            ],

            '9' => [
                'description' => [
                    "Adopta una gran pantalla LCD que permite la intercomunicación y el ajuste instantáneo.",    // español
                    "Adopts big LCD screen display which can make intercommunication and instant setting.",    // inglés
                    "Adotta un grande display a schermo LCD che consente l'intercomunicazione e l'impostazione istantanea.",    // italiano
                    "Adota uma tela LCD grande que permite a intercomunicação e a configuração instantânea.",    // portugués
                    "Adopte un grand écran LCD qui permet l'intercommunication et le réglage instantané.",    // francés
                    "采用大LCD屏幕显示，可以进行互联和即时设置。"    // chino
                ]
            ],

            '10' => [
                'description' => [
                    "La velocidad está controlada por el sistema SRD más avanzado para garantizar una calidad de tela perfecta y ahorrar energía.",    // español
                    "Speed is controlled by the most advanced SRD system to ensure perfect fabric quality and save power",    // inglés
                    "La velocità è controllata dal sistema SRD più avanzato per garantire una qualità del tessuto perfetta e risparmiare energia.",    // italiano
                    "A velocidade é controlada pelo sistema SRD mais avançado para garantir qualidade de tecido perfeita e economizar energia.",    // portugués
                    "La vitesse est contrôlée par le système SRD le plus avancé pour garantir une qualité de tissu parfaite et économiser de l'énergie.",    // francés
                    "速度由最先进的SRD系统控制，以确保完美的织物质量并节省能源。"    // chino
                ]
            ],
            //terry looms

            '11' => [
                'description' => [
                    "Nuevo tipo de rodillo de respaldo positivo, unidad de formación de bucle de nuevo tipo y nuevo rodillo de respaldo de tierra, estos nuevos diseños pueden garantizar la mejor calidad y funciones de esta máquina.",    // español
                    "New type positive pile back-rest roller, newtype loop formation unit and new groundback-rest roller, these new designs can ensure the best quality and functions of this machine.",    // inglés
                    "Nuovo tipo di rullo di supporto posteriore positivo, unità di formazione di loop di nuovo tipo e nuovo rullo di supporto inferiore, questi nuovi design possono garantire la migliore qualità e funzioni di questa macchina.",    // italiano
                    "Motor direto que permite controle automático de velocidade. Novo sistema que melhora a tensão do fio de urdume melhorando a eficiência e qualidade.",    // portugués
                    "Nouveau type de rouleau de support de pile positif, unité de formation de boucle de nouveau type et nouveau rouleau de support inférieur, ces nouveaux designs peuvent garantir la meilleure qualité et fonctions de cette machine.",    // francés
                    "新型正绒底托辊，新型环形成单元和新型地面托辊，这些新设计可以确保这台机器的最佳质量和功能。"    // chino              
                ]
            ],

            '12' => [
                'description' => [
                    "Patrón de baja vibración a alta velocidad y eficiencia.",    // español
                    "Low vibration pattern at high speed and efficiency.",    // inglés
                    "Modello di vibrazione ridotta ad alta velocità ed efficienza.",    // italiano
                    "Estrutura robusta que reduz a vibração aumentando a velocidade e eficiência.",    // portugués
                    "Modèle de faible vibration à grande vitesse et efficacité.",    // francés
                    "高速高效的低振动模式。"    // chino
                ]
            ],

            '13' => [
                'description' => [
                    "Mejor equilibrio entre consumo y rendimiento con mínimo ruido y vibraciones.",    // español
                    "Best balance between consumption and performance with minimal noise and vibrations.",    // inglés
                    "Miglior equilibrio tra consumo e prestazioni con rumore e vibrazioni minimi.",    // italiano
                    "Melhor equilíbrio entre consumo e desempenho com mínimo ruído e vibrações.",    // portugués
                    "Meilleur équilibre entre consommation et performance avec un minimum de bruit et de vibrations.",    // francés
                    "在最小的噪音和振动下，实现了消耗和性能的最佳平衡。"    // chino
                ]
            ],

            '14' => [
                'description' => [
                    "La serie RFTL adopta lubricación centralizada. El aceite puede filtrarse a través de filtros dobles.",    // español
                    "RFTL series adopt centralization lubrication. Oil can be filtered through double filters.",    // inglés
                    "La serie RFTL adotta lubrificazione centralizzata. L'olio può essere filtrato attraverso filtri doppi.",    // italiano
                    "A série RFTL adota lubrificação centralizada. O óleo pode ser filtrado por meio de filtros duplos.",    // portugués
                    "La série RFTL adopte une lubrification centralisée. L'huile peut être filtrée à travers des filtres doubles.",    // francés
                    "RFTL系列采用集中润滑。油可以通过双重过滤器进行过滤。"    // chino
                ]
            ],

            //air looms
            '15' => [
                'description' => [
                    "La inserción de trama estable, el mecanismo de apertura optimizado y la estructura robusta del bastidor aseguran que el telar mantenga un rendimiento excelente a ultra alta velocidad.",    // español
                    "The stable weft insertion, optimized shedding mechanism and robust frame structure ensure the loom keep excellent performance at ultra high-speed.",    // inglés
                    "L'inserimento della trama stabile, il meccanismo di apertura ottimizzato e la struttura robusta del telaio assicurano che il telaio mantenga prestazioni eccellenti a velocità ultra alta.",    // italiano
                    "A inserção de trama estável, o mecanismo de abertura otimizado e a estrutura robusta do quadro garantem que o tear mantenha um desempenho excelente em altas velocidades.",    // portugués
                    "L'insertion de trame stable, le mécanisme d'ouverture optimisé et la structure robuste du cadre garantissent que le métier à tisser maintient d'excellentes performances à très haute vitesse.",    // francés
                    "稳定的纬纱插入、优化的开口机制和坚固的框架结构确保织机在超高速下保持优异的性能。"    // chino
                ]
            ],
            '16' => [
                'description' => [
                    "Control inteligente de conductos de aire.",    // español
                    "Intelligent control of air ducts.",    // inglés
                    "Controllo intelligente dei condotti d'aria.",    // italiano
                    "Controle inteligente Do fluxo de ar.",    // portugués
                    "Contrôle intelligent des conduits d'air.",    // francés
                    "空气管道的智能控制。"    // chino
                ]
            ],
            '17' => [
                'description' => [
                    "Transmisión de velocidad variable directamente con el motor principal.",    // español
                    "Variable speed drive directly with the main motor.",    // inglés
                    "Trasmissione a velocità variabile direttamente con il motore principale.",    // italiano
                    "Transmissão de velocidade variável diretamente com o motor principal.",    // portugués
                    "Transmission à vitesse variable directement avec le moteur principal.",    // francés
                    "变速传动直接与主电机连接。"    // chino
                ]
            ],
            '18' => [
                'description' => [
                    "El sistema experto en tejido puede monitorear la situación de trabajo durante el funcionamiento del telar y puede guiar al telar a elegir la mejor tecnología de tejido.",    // español
                    "Weaving Expert System can scout the working situation during loom running, can guide the loom to choose the best weaving technology.",    // inglés
                    "Il sistema esperto di tessitura può monitorare la situazione di lavoro durante il funzionamento del telaio e può guidare il telaio a scegliere la migliore tecnologia di tessitura.",    // italiano
                    "Painel touchscreen de fácil uso. Sistema de rede",    // portugués
                    "Le système expert de tissage peut surveiller la situation de travail pendant le fonctionnement du métier à tisser et peut guider le métier à tisser à choisir la meilleure technologie de tissage.",    // francés
                    "织造专家系统可以在织机运行过程中监控工作情况，可以指导织机选择最佳的织造技术。"    // chino
                ]
            ],
            '19' => [
                'description' => [
                    "Jacquard opcional: Para tejidos de alto valor añadido como corbatas, etiquetas, toallas, telas de tapicería, seda, etc.",    // español
                    "Optional Jacquard: For high value-added fabrics weaving such as tie, label, towels, upholster fabrics, silk, etc.",    // inglés
                    "Jacquard opzionale: Per la tessitura di tessuti ad alto valore aggiunto come cravatte, etichette, asciugamani, tessuti da tappezzeria, seta, ecc.",    // italiano
                    "Versatilidade para a produção de tecidos variados incluindo tecidos com elevadas densidades",    // portugués
                    "Jacquard optionnel: Pour le tissage de tissus à haute valeur ajoutée tels que cravates, étiquettes, serviettes, tissus d'ameublement, soie, etc.",    // francés
                    "可选提花：适用于高附加值织物的织造，如领带、标签、毛巾、装饰织物、丝绸等。"    // chino
                ]
            ],

            //Electronic
            // '19' => [
            //     'description' => [
            //         "Jacquard opcional: Para tejidos de alto valor añadido como corbatas, etiquetas, toallas, telas de tapicería, seda, etc.",    // español
            //         "Optional Jacquard: For high value-added fabrics weaving such as tie, label, towels, upholster fabrics, silk, etc.",    // inglés
            //         "Jacquard opzionale: Per la tessitura di tessuti ad alto valore aggiunto come cravatte, etichette, asciugamani, tessuti da tappezzeria, seta, ecc.",    // italiano
            //         "Jacquard opcional: Para tecidos de alto valor agregado, como gravatas, etiquetas, toalhas, tecidos de estofados, seda, etc.",    // portugués
            //         "Jacquard optionnel: Pour le tissage de tissus à haute valeur ajoutée tels que cravates, étiquettes, serviettes, tissus d'ameublement, soie, etc.",    // francés
            //         "可选提花：适用于高附加值织物的织造，如领带、标签、毛巾、装饰织物、丝绸等。"    // chino
            //     ]
            // ],
            '20' => [
                'description' => [
                    "Máquina adecuada para urdir varios tipos de hilos, filamentos sintéticos de alta torsión, telas teñidas en hilo, telas de seda, telas de toalla y telas en industrias especiales.",    // español
                    "Machine suitable for warping various kinds of yarn, high twisted synthetic filaments, yarn-dyed fabric, silk fabric, toweling fabric, and fabric in special industry.",    // inglés
                    "Macchina adatta per orditure di vari tipi di filati, filamenti sintetici altamente ritorti, tessuti tinti in filo, tessuti di seta, tessuti per asciugamani e tessuti per industrie speciali.",    // italiano
                    "Máquina adequada para urdir vários tipos de fios, filamentos sintéticos com alta torção, fio tinto, fio de seda, fio de felpa e fios especiais.",    // portugués
                    "Machine adaptée pour l'ourdissage de différents types de fils, filaments synthétiques hautement torsadés, tissus teints en fil, tissus de soie, tissus éponge et tissus pour industries spéciales.",    // francés
                    "适用于整经各种类型的纱线、高捻度合成纤维、纱线染色织物、丝绸织物、毛巾织物和特殊工业中的织物的机器。"    // chino
                ]
            ],
            '21' => [
                'description' => [
                    "Compatible con diferentes tipos de telares. Equipo perfecto para la preparación antes del tejido.",    // español
                    "Compatible with different types of looms. Perfect equipment for preparation before weaving.",    // inglés
                    "Compatibile con diversi tipi di telai. Attrezzatura perfetta per la preparazione prima della tessitura.",    // italiano
                    "Compatível com diferentes tipos de teares. Equipamento perfeito para a preparação antes da tecelagem.",    // portugués
                    "Compatible avec différents types de métiers à tisser. Équipement parfait pour la préparation avant le tissage.",    // francés
                    "适用于不同类型的织机。 织造前准备的完美设备。"    // chino

                ]
            ],
            '22' => [
                'description' => [
                    "Ancho de trabajo: 2300 - 4800 (mm) - Puede hacerse según la demanda del cliente",    // español
                    "Work width: 2300 - 4800 (mm) - Can be made per customer's demand",    // inglés
                    "Larghezza di lavoro: 2300 - 4800 (mm) - Può essere realizzata secondo la richiesta del cliente",    // italiano
                    "Largura de trabalho: 2300 - 4800 (mm) - conforme a demanda do cliente",    // portugués
                    "Largeur de travail : 2300 - 4800 (mm) - Peut être fabriqué selon la demande du client",    // francés
                    "工作宽度：2300 - 4800（毫米） - 可根据客户需求定制"    // chino
                ]
            ],
            '23' => [
                'description' => [
                    "Número de husillos: 640, 720, 800, 960 extremos - Puede hacerse según la demanda del cliente",    // español
                    "Spindle numbers: 640, 720, 800, 960 end - Can be made per customer's demand",    // inglés
                    "Numero di fusi: 640, 720, 800, 960 estremità - Può essere realizzato secondo la richiesta del cliente",    // italiano
                    "Números de fusos: 640, 720, 800, 960 extremidades - conforme a demanda do cliente",    // portugués
                    "Nombre de broches : 640, 720, 800, 960 extrémités - Peut être fabriqué selon la demande du client",    // francés
                    "锭子数量：640、720、800、960 端 - 可根据客户需求定制"    // chino
                ]
            ],
            '24' => [
                'description' => [
                    "Diferentes tipos de plegadores según las necesidades del cliente. (Fijo, en forma de V, etc)",    // español
                    "Different types of creel according to customer's needs. (Fixed, V-shaped, etc)",    // inglés
                    "Diversi tipi di creel secondo le esigenze del cliente. (Fisso, a forma di V, ecc.)",    // italiano
                    "Diferentes tipos de gaiola de acordo com as necessidades do cliente. (Fixo, em forma de V, etc.)",    // portugués
                    "Différents types de cantre selon les besoins du client. (Fixe, en forme de V, etc.)",    // francés
                    "根据客户的需求，不同类型的络筒架。（固定的，V型的等）"    // chino
                ]
            ],
            //direct warping
            '25' => [
                'description' => [
                    "Puede controlar con precisión la longitud y disposición del hilo de urdimbre.",    // español
                    "Can accurately control the length and arrangement of warp yarn.",    // inglés
                    "Può controllare con precisione la lunghezza e la disposizione del filo d'ordito.",    // italiano
                    "Pode controlar com precisão o comprimento e arranjo do fio de urdume.",    // portugués
                    "Peut contrôler avec précision la longueur et l'arrangement du fil de chaîne.",    // francés
                    "可以准确控制经线的长度和排列。"    // chino
                ]
            ],
            '26' => [
                'description' => [
                    "Alta eficiencia, densidad uniforme y planitud del hilo.",    // español
                    "High efficiency, uniform density and flatness thread.",    // inglés
                    "Alta efficienza, densità uniforme e planarità del filo.",    // italiano
                    "Alta eficiência, densidade uniforme e planicidade da linha.",    // portugués
                    "Haute efficacité, densité uniforme et planéité du fil.",    // francés
                    "高效，均匀密度和平整的线。"    // chino
                ]
            ],
            '27' => [
                'description' => [
                    "Ancho de trabajo: 1600, 1800, 2000, 2200, 2400 (mm) - Se puede fabricar según la demanda del cliente.",   // español
                    "Work width: 1600, 1800, 2000, 2200, 2400 (mm) - Can be made per customer's demand.",   // inglés,
                    "Larghezza del lavoro: 1600, 1800, 2000, 2200, 2400 (mm) - Può essere realizzato su richiesta del cliente.",   // italiano
                    "Largura de trabalho: 1600, 1800, 2000, 2200, 2400 (mm) - conforme a demanda do cliente.",   // portugués
                    "Largeur de travail: 1600, 1800, 2000, 2200, 2400 (mm) - Peut être fabriqué selon la demande du client.",   // francés
                    "工作宽度：1600、1800、2000、2200、2400（毫米）- 可根据客户要求定制。"    // chino

                ]
            ],
            '28' => [
                'description' => [
                    "Velocidad de enrollamiento del haz: 300-1200m / min - Número de husos: 640 - 960",    // español
                    "Speed of beam warping: 300 -1200m /min -Spindle numbers: 640 - 960 end -",    // inglés
                    "Velocità di avvolgimento del telaio: 300 - 1200m / min - Numero di fusi: 640 - 960",    // italiano
                    "Velocidade de enrolamento do Rolo do urdume: 300 -1200m / min - Número de fusos: 640 - 960",    // portugués
                    "Vitesse d'enroulement de faisceau : 300 - 1200m / min - Nombre de broches : 640 - 960",    // francés
                    "织轴速度：300-1200m/min - 纱锭数量：640-960"    // chino
                ]
            ],
            '29' => [
                'description' => [
                    "Puede hacerse según la demanda del cliente",    // español
                    "Can be made per customer’s demand",    // inglés
                    "Può essere realizzato su richiesta del cliente",    // italiano
                    "",    // portugués
                    "Peut être fabriqué à la demande du client",    // francés
                    "可以根据客户需求定制"    // chino
                ]
            ],
            //label waving
            '30' => [
                'description' => [
                    "Ancho del telar: 1700 mm - 1900 mm",    // español
                    "Width loom: 1700 mm - 1900 mm",    // inglés
                    "Larghezza del telaio: 1700 mm - 1900 mm",    // italiano
                    "Largura do tear: 1700 mm - 1900 mm",    // portugués
                    "Largeur du métier: 1700 mm - 1900 mm",    // francés
                    "织机宽度：1700毫米 - 1900毫米"    // chino
                ]
            ],
            '31' => [
                'description' => [
                    "Jacquard electrónico de alta velocidad con capacidad de 1800 a 9600 ganchos",    // español
                    "High-speed electronic Jacquard with capacity from 1800 to 9600 hooks",    // inglés
                    "Jacquard elettronico ad alta velocità con capacità da 1800 a 9600 ganci",    // italiano
                    "Jacquard eletrônico de alta velocidade com capacidade de 1800 a 9600 ganchos",    // portugués
                    "Jacquard électronique haute vitesse avec une capacité de 1800 à 9600 crochets",    // francés
                    "高速电子提花机，容量从1800到9600钩"    // chino
                ]
            ],
            '32' => [
                'description' => [
                    "Equipado con un mecanismo de elevación equilibrado que elimina el desequilibrio de carga y funciona sin vibraciones",    // español
                    "Equipped with a balanced lifting mechanism which eliminates load unbalance and works without vibration",    // inglés
                    "Dotato di un meccanismo di sollevamento bilanciato che elimina lo squilibrio del carico e funziona senza vibrazioni",    // italiano
                    "Equipado com um mecanismo de elevação equilibrado que elimina o desequilíbrio de carga e funciona sem vibrações",    // portugués
                    "Équipé d'un mécanisme de levage équilibré qui élimine le déséquilibre de charge et fonctionne sans vibrations",    // francés
                    "配备了一个平衡提升机制，可以消除负载不平衡，并在无振动的情况下工作"    // chino                      
                ]
            ],
            '33' => [
                'description' => [
                    "Controlador con seguimiento de la cantidad de etiquetas a producir y continuación automática al siguiente conjunto de diseño",    // español
                    "Controller with tracking of the quantity of labels to be produced and automatic continuation to the next design set",    // inglés
                    "Controller con tracciamento della quantità di etichette da produrre e continuazione automatica al prossimo set di design",    // italiano
                    "Controlador com rastreamento da quantidade de etiquetas a serem produzidas e continuação automática para o próximo conjunto de design",    // portugués
                    "Contrôleur avec suivi de la quantité d'étiquettes à produire et passage automatique au prochain ensemble de conception",    // francés
                    "控制器可以跟踪要生产的标签数量，并自动继续到下一个设计集"    // chino
                ]
            ],
            '34' => [
                'description' => [
                    "Arnés con acoplamiento rápido y fácil montaje",    // español
                    "Harness with quick coupling and easy assembly",    // inglés
                    "Imbracatura con accoppiamento rapido e facile montaggio",    // italiano
                    "Arnês com acoplamento rápido e fácil montagem",    // portugués
                    "Harnais avec couplage rapide et assemblage facile",    // francés
                    "带有快速耦合和易于组装的线束"    // chino
                ]
            ],
            //narow fabric
            '35' => [
                'description' => [
                    "Cabezal Jacquard de alta velocidad y funcionamiento suave",    // español
                    "Jacquard head is high-speed and running smoothly",    // inglés
                    "Testa Jacquard ad alta velocità e funzionamento regolare",    // italiano
                    "Cabeça Jacquard de alta velocidade e funcionamento suave",    // portugués
                    "Tête Jacquard à haute vitesse et fonctionnement fluide",    // francés
                    "高速运行平稳的提花机头"    // chino
                ]
            ],
            '36' => [
                'description' => [
                    "Módulos con tarjeta de control separada, más conveniente y eficiente de mantener",    // español
                    "Modules with separate control board, more convenient, efficient to maintain",    // inglés
                    "Moduli con scheda di controllo separata, più comodi ed efficienti da mantenere",    // italiano
                    "Módulos com placa de controle separada, mais conveniente e eficiente de manter",    // portugués
                    "Modules avec carte de contrôle séparée, plus pratique et efficace à entretenir",    // francés
                    "带有独立控制板的模块，更方便和高效的维护"    // chino
                ]
            ],
            '37' => [
                'description' => [
                    "Nuevo sistema de control que puede almacenar de 8 a 16 patrones y patrones de hasta 13,000 tramas",    // español
                    "New control system which can store from 8 to 16 patterns and pattern up to 13,000 weft",    // inglés
                    "Nuovo sistema di controllo che può memorizzare da 8 a 16 motivi e motivo fino a 13.000 trame",    // italiano
                    "Novo sistema de controle que pode armazenar de 8 a 16 padrões e padrões de até 13.000 tramas",    // portugués
                    "Nouveau système de contrôle pouvant stocker de 8 à 16 motifs et motif jusqu'à 13 000 trames",    // francés
                    "新的控制系统可以存储8到16个图案，最多可存储13,000纬纱的图案"    // chino
                ]
            ],
            '38' => [
                'description' => [
                    "Variedad opcional de dispositivo especial para que coincida con la producción de diferentes productos",    // español
                    "Optional variety of special device to match production of different products",    // inglés
                    "Varietà opzionale di dispositivo speciale per abbinare la produzione di diversi prodotti",    // italiano
                    "Variedade opcional de dispositivo especial para combinar produção de diferentes produtos",    // portugués
                    "Variété optionnelle de dispositif spécial pour correspondre à la production de différents produits",    // francés
                    "匹配生产不同产品的多种特殊设备的可选品种"    // chino
                ]
            ],
            '39' => [
                'description' => [
                    "El creel de tipo resorte es estable y duradero, fácil de ajustar la tensión del hilo.",    // español
                    "Spring type creel is stable and endurable, easy to adjust the tension of the yarn.",    // inglés
                    "Il creel a molla è stabile e resistente, facile da regolare la tensione del filo.",    // italiano
                    "O creel de tipo mola é estável e durável, fácil de ajustar a tensão do fio.",    // portugués
                    "Le creel de type ressort est stable et durable, facile à ajuster la tension du fil.",    // francés
                    "弹簧式筘架稳定耐用，易于调节纱线的张力。"    // chino
                ]
            ],
            '40' => [
                'description' => [
                    "Disponible en diferentes anchos, ganchos y número de líneas.",    // español
                    "Available in different widths, hooks and number of lines.",    // inglés
                    "Disponibile in diverse larghezze, ganci e numero di linee.",    // italiano
                    "Disponível em diferentes larguras, ganchos e número de linhas.",    // portugués
                    "Disponible en différentes largeurs, crochets et nombres de lignes.",    // francés
                    "可提供不同宽度、挂钩和行数。"    // chino
                ]
            ],
            //higt spped
            '41' => [
                'description' => [
                    "Rendimiento preciso, piezas de repuesto compatibles y duraderas. Mantenimiento y ajuste fáciles.",    // español
                    "Accurate performance, compatible and durable spare parts. Easy maintenance and adjustment.",    // inglés
                    "Prestazioni precise, parti di ricambio compatibili e durevoli. Manutenzione e regolazione facili.",    // italiano
                    "Desempenho preciso, peças de reposição compatíveis e duráveis. Manutenção e ajuste fácil.",    // portugués
                    "Performance précise, pièces de rechange compatibles et durables. Entretien et ajustement faciles.",    // francés
                    "精准的性能，兼容耐用的备件。易于维护和调整。"    // chino
                ]
            ],
            '42' => [
                'description' => [
                    "De 2 a 12 líneas de tejido concurrentes.",    // español
                    "From 2 to 12 lines concurrent weaving.",    // inglés
                    "Da 2 a 12 linee di tessitura simultanee.",    // italiano
                    "De 2 a 12 linhas de tecelagem simultâneas.",    // portugués
                    "De 2 à 12 lignes de tissage simultanées.",    // francés
                    "同时并行织造2到12条生产线。"    // chino
                ]
            ],
            '43' => [
                'description' => [
                    "Desde el ancho más pequeño de 3 mm hasta el ancho máximo de 110 mm. Varias espesuras, desde la cinta de gasa hasta la cinta gruesa.",    // español
                    "From the smallest width 3mm to the maximum width of 110mm. Various thicknesses from gauze tape to heavy tape.",    // inglés
                    "Dalla larghezza minima di 3 mm alla larghezza massima di 110 mm. Varie spessori, dalla nastro di garza al nastro pesante.",    // italiano
                    "Da menor largura de 3 mm até a largura máxima de 110 mm. Várias espessuras, desde fita de gaze até fita grossa.",    // portugués
                    "De la plus petite largeur de 3 mm à la largeur maximale de 110 mm. Différentes épaisseurs, de la bande de gaze à la bande épaisse.",    // francés
                    "从最小宽度3毫米到最大宽度110毫米。厚度从纱布带到重型带子不等。"    // chino
                ]
            ],
            '44' => [
                'description' => [
                    "Máquinas convertibles respaldadas con varios dispositivos para proporcionar una amplia gama de requisitos múltiples de telas para una sola máquina.",    // español
                    "Convertible machines supported with various devices to provide a wide range of fabrics multi-requirements for a single machine as well.",    // inglés
                    "Macchine convertibili supportate con vari dispositivi per fornire un'ampia gamma di requisiti multipli per i tessuti con una singola macchina.",    // italiano
                    "Máquinas conversíveis suportadas com vários dispositivos para fornecer uma ampla gama de requisitos múltiplos de tecidos para uma única máquina.",    // portugués
                    "Machines convertibles soutenues par divers dispositifs pour fournir une large gamme de tissus et de multiples exigences pour une seule machine.",    // francés
                    "支持各种设备的可转换机器也能为单台机器提供各种面料的多种要求。"    // chino
                ]
            ],
            '45' => [
                'description' => [
                    "Disponible en diferentes anchos, ganchos y número de líneas.",    // español
                    "Available in different widths, hooks and number of lines.",    // inglés
                    "Disponibile in diverse larghezze, ganci e numero di linee.",    // italiano
                    "Disponível em diferentes larguras, ganchos e número de linhas.",    // portugués
                    "Disponible en différentes largeurs, crochets et nombre de lignes.",    // francés
                    "有不同的宽度、挂钩和线数可供选择。"    // chino
                ]
            ],
            //automatic
            '46' => [
                'description' => [
                    "Accionamiento fijo de trama hacia adelante y hacia atrás para un ajuste fácil de los pasos cinéticos.",    // español
                    "Fixed back-and-forth weft drive for easy adjustment of kinetic pitches.",    // inglés
                    "Trasporto di trama avanti e indietro fisso per una facile regolazione dei passi cinetici.",    // italiano
                    "Movimentação da trama para frente e para trás fixa para ajuste fácil dos passos cinéticos.",    // portugués
                    "Entraînement de trame fixe d'avant en arrière pour un ajustement facile des pas cinétiques.",    // francés
                    "固定的往返纬纱驱动便于调整运动节距。"    // chino
                ]
            ],
            '47' => [
                'description' => [
                    "Transmisión de trama - engranaje de trama diversificado para un tejido exitoso",    // español
                    "Weft transmission-diversified weft gearing for successful looming",    // inglés
                    "Trasmissione della trama - ingranaggi della trama diversificati per una tessitura di successo",    // italiano
                    "Transmissão da trama - engrenagem da trama diversificada para um tecelagem bem-sucedida",    // portugués
                    "Transmission de trame - engrenage de trame diversifié pour un tissage réussi",    // francés
                    "纬纱传动-多样化的纬纱齿轮传动确保成功的织造"    // chino
                ]
            ],

            '48' => [
                'description' => [
                    "Separador de dispositivo de trama/goma para una fácil gestión de la urdimbre en una operación práctica que ahorra tiempo y esfuerzo",    // español
                    "Weft/rubber device separator for easy management of warp in handy operation that saves time and effort",    // inglés
                    "Separatore del dispositivo trama/gomma per una facile gestione dell'ordito in un'operazione pratica che fa risparmiare tempo e fatica",    // italiano
                    "Separador de dispositivo de trama/borracha para fácil gestão da urdidura em operação prática que economiza tempo e esforço",    // portugués
                    "Séparateur de dispositif trame/caoutchouc pour une gestion facile de la chaîne dans une opération pratique qui fait gagner du temps et des efforts",    // francés
                    "纬纱/橡胶装置分离器，便于管理经纱，操作方便，省时省力"    // chino  
                ]
            ],
            '49' => [
                'description' => [
                    "El mecanismo de bielas ofrece una salida de precisión y se adapta a todo tipo de calibre sin rectificado",    // español
                    "The mechanism of cranks delivers precision output and fits all types of gauge without grinding",    // inglés
                    "Il meccanismo delle bielle offre un'uscita di precisione e si adatta a tutti i tipi di calibro senza rettifica",    // italiano
                    "O mecanismo de manivelas oferece saída de precisão e se adapta a todos os tipos de calibre sem retificação",    // portugués
                    "Le mécanisme de bielles offre une sortie précise et s'adapte à tous les types de jauge sans meulage",    // francés
                    "曲柄机构提供精确输出，适合所有类型的规格，无需研磨"    // chino 
                ]
            ],
            '50' => [
                'description' => [
                    "Multicabezal multifunción para marco de hilo",    // español
                    "Multi head multi model yarn frame",    // inglés
                    "Telaio per filati multi testa e multi modello",    // italiano
                    "Moldura de fio de modelo múltiplo com várias cabeças",    // portugués
                    "Cadre de fil multi-modèle multi-tête",    // francés
                    "多头多型号纱线框架"    // chino
                ]
            ],
            //label & folding machine
            '51' => [
                'description' => [
                    "Apropiado para corte y plegado multifuncional, con corte por cuchilla caliente y fría.",    // español
                    "Suitable for multi-functional cutting and folding, with hot & cold blade cutting.",    // inglés
                    "Adatto per taglio e piegatura multifunzionali, con taglio a lama calda e fredda.",    // italiano
                    "Adequado para corte e dobra multifuncionais, com corte por lâmina quente e fria.",    // portugués
                    "Convient pour le découpage et le pliage multifonctionnels, avec découpe à lame chaude et froide.",    // francés
                    "适用于多功能切割和折叠，支持热刀和冷刀切割。"    // chino
                ]
            ],
            '52' => [
                'description' => [
                    "Alta velocidad, mayor precisión y mayor vida útil.",    // español
                    "High speed, higher precision and longer service life.",    // inglés
                    "Alta velocità, maggiore precisione e maggiore durata.",    // italiano
                    "Alta velocidade, maior precisão e maior vida útil.",    // portugués
                    "Haute vitesse, précision accrue et durée de vie prolongée.",    // francés
                    "高速、更高的精度和更长的服务寿命。"    // chino
                ]
            ],
            '53' => [
                'description' => [
                    "No es necesario cambiar el molde.",    // español
                    " No need to change mould. ",    // inglés
                    "Nessun bisogno di cambiare lo stampo.",    // italiano
                    "Não é necessário trocar o molde.",    // portugués
                    "Pas besoin de changer le moule.",    // francés
                    "无需更换模具。"    // chino
                ]
            ],
            '54' => [
                'description' => [
                    "Para diferentes parámetros de técnica como el plegado de extremos, el plegado central, el plegado en inglete y otros.",    // español
                    "For different technique parameters such as end fold, centre fold, mitre fold and others.",    // inglés
                    "Per diversi parametri tecnici come la piegatura dei bordi, la piegatura centrale, la piegatura a miter e altri.",    // italiano
                    "Para diferentes tipos de dobras como central, lateral, mitre, envelope e outras.",    // portugués
                    "Pour différents paramètres techniques tels que le pliage des extrémités, le pliage central, le pliage en onglet et autres.",    // francés
                    "适用于不同的技术参数，如端折、中心折、斜角折叠等。"    // chino
                ]
            ],

            '55' => [
                'description' => [
                    "No es necesario usar herramientas al ajustar la longitud.",    // español
                    "No need to use tool when setting length. ",    // inglés
                    "Non è necessario utilizzare attrezzi durante l'impostazione della lunghezza.",    // italiano
                    "Não é necessário usar ferramentas ao definir o comprimento.",    // portugués
                    "Il n'est pas nécessaire d'utiliser des outils pour régler la longueur.",    // francés
                    "设置长度时无需使用工具。"    // chino
                ]
            ],
            //ultrasonic
            '56' => [
                'description' => [
                    "Accionamiento de trama fijo de ida y vuelta para un fácil ajuste de los pasos cinéticos.",    // español
                    "Fixed back-and-forth weft drive for easy adjustment of kinetic pitches.",    // inglés
                    "Azionamento di trama fisso avanti e indietro per una facile regolazione dei passi cinetici.",    // italiano
                    "Corte quente, corte frio e corte ultrassônico opcional",    // portugués
                    "Entraînement de trame aller-retour fixe pour un réglage facile des pas cinétiques.",    // francés
                    "固定往复纬线驱动，便于调整运动节距。"    // chino
                ]
            ],

            '57' => [
                'description' => [
                    "Transmisión de trama: engranaje de trama diversificado para un tejido exitoso.",    // español
                    "Weft transmission-diversified weft gearing for successful looming.",    // inglés
                    "Trasmissione della trama: ingranaggio della trama diversificato per una tessitura di successo.",    // italiano
                    "Dobras multifuncionais",    // portugués
                    "Transmission de trame : engrenage de trame diversifié pour un tissage réussi.",    // francés
                    "纬线传动：多样化的纬线齿轮传动确保成功织造。"    // chino
                ]
            ],

            '58' => [
                'description' => [
                    "Separador de dispositivo de trama/goma para un fácil manejo de la urdimbre en una operación práctica que ahorra tiempo y esfuerzo.",    // español
                    "Weft/rubber device separator for easy management of warp in handy operation that saves time and effort.",    // inglés
                    "Separatore di dispositivo trama/gomma per una facile gestione dell'ordito in un'operazione pratica che consente di risparmiare tempo e fatica.",    // italiano
                    "Lâmina superior e fácil de trocar",    // portugués
                    "Séparateur de dispositif trame/caoutchouc pour une gestion facile de la chaîne dans une opération pratique qui économise temps et effort.",    // francés
                    "纬线/橡胶装置分离器，便于管理经线，操作方便，节省时间和精力。"    // chino
                ]
            ],

            '59' => [
                'description' => [
                    "El mecanismo de bielas ofrece una salida precisa y se adapta a todos los tipos de calibres sin necesidad de rectificado.",
                    "The mechanism of cranks delivers precision output and fits all types of gauge without grinding.",
                    "Il meccanismo delle manovelle fornisce un'uscita precisa e si adatta a tutti i tipi di calibro senza rettifica.",    // italiano
                    "Adequado para dobrar etiquetas impressas ou tecidas",    // portugués
                    "Le mécanisme de manivelles offre une sortie précise et s'adapte à tous les types de jauge sans meulage.",    // francés
                    "曲柄机构提供精确的输出，适用于所有类型的量规，无需磨削。"    // chino
                ]
            ],


            '60' => [
                'description' => [
                    "Bastidor de hilo con múltiples cabezales y múltiples modelos.",    // español
                    "Multi head multi model yarn frame.",    // inglés
                    "Telaio per filati a più teste e modelli multipli.",    // italiano
                    "Velocidade, eficiência e precisão",    // portugués
                    "Cadre de fil à plusieurs têtes et modèles multiples.",    // francés
                    "多头多型号纱线架。"    // chino
                ]
            ],
            //Single jersey
            '61' => [
                'description' => [
                    "Jersey sencillo de ancho abierto, terciopelo de rizo, rizo polar.",    // español
                    "Single jersey open width, velour terry, polar terry. ",    // inglés
                    "Jersey semplice a larghezza aperta, velluto terry, terry polare.",    // italiano
                    "Malha simples de largura aberta, veludo Moletom.",    // portugués
                    "Jersey simple à largeur ouverte, velours éponge, éponge polaire.",    // francés
                    "单面针织开幅、天鹅绒毛圈、极地毛圈。"    // chino
                ]
            ],
            '62' => [
                'description' => [
                    "Las piezas y accesorios se fabrican en el centro de mecanizado avanzado para que la precisión y exactitud se puedan mejorar significativamente.",    // español
                    "Parts and accessories are manufactured by the advanced machining center so that the precision and accuracy can be  greatly improved.",    // inglés
                    "I pezzi e accessori sono realizzati presso il centro di lavorazione avanzato, in modo che la precisione e l'accuratezza possano essere notevolmente migliorate.",    // italiano
                    "As peças e acessórios são fabricados no centro de usinagem avançado, para que a precisão e a exatidão possam ser significativamente aprimoradas.",    // portugués
                    "Les pièces et accessoires sont fabriqués dans le centre d'usinage avancé afin que la précision et l'exactitude puissent être considérablement améliorées.",    // francés
                    "部件和配件由先进的加工中心制造，以大幅提高精度和准确性。"    // chino
                ]
            ],
            '63' => [
                'description' => [
                    "Calibre: 12G-44G",    // español
                    "Gauge: 12G-44G",    // inglés
                    "Calibro: 12G-44G",    // italiano
                    "Calibre: 12G-44G",    // portugués
                    "Calibre : 12G-44G",    // francés
                    "规格：12G-44G"    // chino
                ]
            ],
            '64' => [
                'description' => [
                    "Con una estructura compacta, el nuevo sistema de punto central diseñado funciona de manera suave y estable, y ajusta el peso del tejido de forma simple y precisa, lo que ayuda a mejorar la eficiencia.",    // español
                    "With a compact structure the newly designed central stitch system works smoothly and steadily and adjusts fabric weight simply and accurately which helps improve efficiency.",    // inglés
                    "Con una struttura compatta, il nuovo sistema di punto centrale progettato funziona in modo fluido e stabile, e regola il peso del tessuto in modo semplice e preciso, contribuendo a migliorare l'efficienza.",    // italiano
                    "Com uma estrutura compacta, o novo sistema de ponto central projetado funciona de forma suave e estável e ajusta o peso do tecido de maneira simples e precisa, o que ajuda a melhorar a eficiência.",    // portugués
                    "Avec une structure compacte, le nouveau système de point central conçu fonctionne de manière fluide et stable, et ajuste le poids du tissu de manière simple et précise, ce qui aide à améliorer l'efficacité.",    // francés
                    "新设计的中央针织系统具有紧凑的结构，运作平稳且稳定，能够简单准确地调整织物重量，从而提高效率。"    // chino
                ]
            ],
            //interlock
            '65' => [
                'description' => [
                    "Sistema de limpieza doble del cilindro.",    // español
                    "Dual dedusting system of cylinder.",    // inglés
                    "Sistema di pulizia doppia del cilindro.",    // italiano
                    "Sistema de despoeiramento duplo do cilindro.",    // portugués
                    "Système de dédustage double du cylindre.",    // francés
                    "双缸除尘系统。"    // chino
                ]
            ],
            '66' => [
                'description' => [
                    "El sistema de transmisión único con pistas dobles especialmente diseñadas reduce el desgaste y hace que la máquina funcione de manera más suave con menos marcas de barras.",    // español
                    "Unique drive system with especially dual tracks reduces wear and makes the machine run smoothly with less barre marks",    // inglés
                    "Il sistema di trasmissione unico con piste doppie appositamente progettate riduce l'usura e consente alla macchina di funzionare in modo più fluido con meno segni di barre.",    // italiano
                    "O sistema de acionamento único com trilhos duplos especialmente projetados reduz o desgaste e faz com que a máquina funcione de forma mais suave com menos marcas de barras.",    // portugués
                    "Le système de transmission unique avec des pistes doubles spécialement conçues réduit l'usure et permet à la machine de fonctionner de manière plus fluide avec moins de marques de barres.",    // francés
                    "独特的驱动系统，配有特别设计的双轨道，减少了磨损，使机器运行更加平稳，减少了条纹痕迹。"    // chino
                ]
            ],
            '67' => [
                'description' => [
                    "La base de la caja de levas del dial y la funda del buje se mueven de manera sincronizada, lo que hace que el ajuste de las agujas y el espacio sea sencillo y preciso.",    // español
                    "Dial cam box base and the bush sleeve move synchronously, which  makes the adjustment of needle and space simply and accurately.",    // inglés
                    "La base della scatola delle camme del dial e il manicotto si muovono in modo sincronizzato, il che rende l'ajustamento delle aghi e dello spazio semplice e preciso.",    // italiano
                    " A base da caixa de excêntricos do disco e o cilindro movem-se de forma sincronizada, o que torna o ajuste das agulhas e do espaço simples e preciso.",    // portugués
                    "La base de la boîte à cames du cadran et le manchon se déplacent de manière synchronisée, ce qui rend l'ajustement des aiguilles et de l'espace simple et précis.",    // francés
                    "拨轮凸轮箱基座和轴套同步移动，使针和间距的调整变得简单而准确。"    // chino
                ]
            ],
            '68' => [
                'description' => [
                    "La operación es fácil y conveniente.",
                    "Operation is easy and convenient. ",
                    "Il funzionamento è facile e conveniente.",    // italiano
                    "A operação é fácil e conveniente.",    // portugués
                    "Le fonctionnement est facile et pratique.",    // francés
                    "操作简单方便。"    // chino
                ]
            ],
            '69' => [
                'description' => [
                    "Elimina las arrugas de la tela, lo que lo hace adecuado para tejidos de doble capa de aire, como nylon de alta calidad, poliéster y filamento.",    // español
                    "It removes creases from cloth, making it suitable for double air layer fabrics like high-quality nylon, polyester, and filament.",    // inglés
                    "Rimuove le pieghe dal tessuto, rendendolo adatto per tessuti a doppio strato d'aria, come nylon di alta qualità, poliestere e filamento.",    // italiano
                    "Remove as rugas do tecido, tornando-o adequado para tecidos de camada dupla de ar, como nylon de alta qualidade, poliéster e filamento.",    // portugués
                    "Il élimine les plis du tissu, le rendant adapté aux tissus à double couche d'air, tels que le nylon de haute qualité, le polyester et le filament.",    // francés
                    "它去除布料上的褶皱，使其适用于双层空气面料，如高质量尼龙、涤纶和长丝。"    // chino
                ]
            ],
            //single computer
            '70' => [
                'description' => [
                    "Diámetro del cilindro: 12” - 44”",    // español
                    "Cylinder diameter: 12” - 44”",    // inglés
                    "Diametro del cilindro: 12” - 44”",    // italiano
                    "Diâmetro do cilindro: 12” - 44”",    // portugués
                    "Diamètre du cylindre : 12” - 44”",    // francés
                    "圆筒直径: 12” - 44”"    // chino
                ]
            ],
            '71' => [
                'description' => [
                    "Malla: 7G - 32G",    // español
                    "Gauge: 7G - 32G",    // inglés
                    "Maglia: 7G - 32G",    // italiano
                    "Malha: 7G - 32G",    // portugués
                    "Jauge : 7G - 32G",    // francés
                    "针距: 7G - 32G"    // chino
                ]
            ],
            '72' => [
                'description' => [
                    "Con pantalla LCD para simplificar la operación.",    // español
                    "With LCD display screen to simply the operation.",    // inglés
                    "Con schermo LCD per semplificare l'operazione.",    // italiano
                    "Com tela LCD para simplificar a operação.",    // portugués
                    "Avec écran LCD pour simplifier l'opération.",    // francés
                    "配备LCD显示屏以简化操作。"    // chino
                ]
            ],
            '73' => [
                'description' => [
                    "No se necesita software específico para gráficos.",    // español
                    "No specific software are needed for graphics.",    // inglés
                    "Nessun software specifico è necessario per i grafici.",    // italiano
                    "Nenhum software específico é necessário para gráficos.",    // portugués
                    "Aucun logiciel spécifique n'est nécessaire pour les graphiques.",    // francés
                    "不需要特定的软件来处理图形。"    // chino
                ]
            ],
            '74' => [
                'description' => [
                    "Caracterizado por el intercambio simple entre jacquard simple y jacquard de malla, que se puede lograr sólo reemplazando las levas del cilindro, lo que reduce en gran medida la carga de trabajo de prueba.",    // español
                    "Characterized by simple interchanging between single jacquard and mesh jacquard which can be realized by only replacing the cylinder cams, which greatly reduces the workload of testing.",    // inglés
                    "Caratterizzato dal semplice scambio tra jacquard singolo e jacquard a rete, che può essere realizzato solo sostituendo le camme del cilindro, riducendo notevolmente il carico di lavoro per i test.",    // italiano
                    "Caracterizado pela troca simples entre jacquard liso e jacquard de malha, que pode ser realizada apenas substituindo as excéntricos do cilindro, o que reduz significativamente a carga de trabalho de teste.",    // portugués
                    "Caractérisé par l'échange simple entre jacquard uni et jacquard en maille, qui peut être réalisé simplement en remplaçant les cames du cylindre, réduisant ainsi considérablement la charge de travail des tests.",    // francés
                    "特点是单面提花和网状提花之间的简单切换，只需更换圆筒凸轮即可实现，这大大减少了测试的工作量。"    // chino
                ]
            ],
            //Double computer
            '75' => [
                'description' => [
                    "Diámetro del cilindro: 17” - 42”",    // español
                    "Cylinder diameter: 17” - 42”",    // inglés
                    "Diametro del cilindro: 17” - 42”",    // italiano
                    "Diâmetro do cilindro: 17” - 42”",    // portugués
                    "Diamètre du cylindre : 17” - 42”",    // francés
                    "圆筒直径: 17” - 42”"    // chino
                ]
            ],
            '76' => [
                'description' => [
                    "Malla: 7G - 32G",    // español
                    "Gauge: 7G - 32G ",    // inglés
                    "Maglia: 7G - 32G",    // italiano
                    "Malha: 7G - 32G",    // portugués
                    "Jauge : 7G - 32G",    // francés
                    "针距: 7G - 32G"    // chino
                ]
            ],
            '77' => [
                'description' => [
                    "La máquina utiliza selectores computarizados para seleccionar agujas en el cilindro con la técnica de tejido de 2 o 3 vías, recogido y salto, lo que permite producir tejidos con diferentes patrones sin limitaciones.",    // español
                    "The machine uses computerized selectors to select needles in the cylinder with the 2- or 3-way knit, pick and skip technique, allowing to produce fabrics with different patterns without limitations. ",    // inglés
                    "La macchina utilizza selettori computerizzati per selezionare aghi nel cilindro con la tecnica di maglieria a 2 o 3 vie, prelievo e salto, consentendo di produrre tessuti con diversi motivi senza limitazioni.",    // italiano
                    "A máquina utiliza seletores computadorizados para selecionar agulhas no cilindro com a técnica de malharia de 2 ou 3 vias, escolha e salto, permitindo produzir tecidos com diferentes padrões sem limitações.",    // portugués
                    "La machine utilise des sélecteurs informatisés pour sélectionner les aiguilles dans le cylindre avec la technique de tricot à 2 ou 3 voies, sélection et saut, permettant de produire des tissus avec différents motifs sans limitations.",    // francés
                    "该机器使用计算机化选择器，通过2或3路编织、挑选和跳跃技术选择缸上的针，使得生产各种不同图案的面料不受限制。"    // chino
                ]
            ],
            '78' => [
                'description' => [
                    "Cualquier patrón intrincado puede ser convertido en un comando especial a través del sistema de preparación de patrones computarizado, que instruye a los selectores para crear tejido jacquard.",    // español
                    "Any intricate pattern can be converted into a special command through the computerized pattern preparation system, which instructs the selectors to create jacquard fabric.",    // inglés
                    "Qualsiasi motivo complesso può essere convertito in un comando speciale tramite il sistema di preparazione dei motivi computerizzato, che istruisce i selettori a creare tessuto jacquard.",    // italiano
                    "Qualquer padrão intrincado pode ser convertido em um comando especial através do sistema de preparação de padrões computadorizado, que instrui os seletores a criar tecido jacquard.",    // portugués
                    "Tout motif complexe peut être converti en une commande spéciale via le système de préparation des motifs informatisé, qui indique aux sélecteurs de créer du tissu jacquard.",    // francés
                    "任何复杂的图案都可以通过计算机图案准备系统转换为特殊指令，指示选择器制作提花面料。"    // chino
                ]
            ],
            //sock machine
            '79' => [
                'description' => [
                    "Para diferentes tipos de aplicaciones: lisas, de felpa y de doble felpa.",    // español
                    "For different types of applications: plain, terry and double terry.",    // inglés
                    "Per diversi tipi di applicazioni: lisce, in spugna e in doppia spugna.",    // italiano
                    "Para diferentes tipos de aplicações: lisas, de felpa e de felpa dupla.",    // portugués
                    "Pour différents types d'applications : unies, en éponge et en double éponge.",    // francés
                    "适用于不同类型的应用：平纹、毛巾和双层毛巾。"    // chino
                ]
            ],
            '80' => [
                'description' => [
                    "Número de una a múltiples líneas entrantes.",    // español
                    "Number of one to multiple incoming lines.",    // inglés
                    "Numero di una o più linee in entrata.",    // italiano
                    "Número de uma a várias linhas de entrada.",    // portugués
                    "Nombre de lignes entrantes de une à plusieurs.",    // francés
                    "一到多条输入线的数量。"    // chino
                ]
            ],
            '81' => [
                'description' => [
                    "Rango de agujas: 40 - 200 agujas",    // español
                    "Needle range: 40 - 200 needles",    // inglés
                    "Gamma di aghi: 40 - 200 aghi",    // italiano
                    "Intervalo de agulhas: 40 - 200 agulhas",    // portugués
                    "Gamme d'aiguilles : 40 - 200 aiguilles",    // francés
                    "针范围: 40 - 200 针"    // chino
                ]
            ],
            '82' => [
                'description' => [
                    "Cilindro único",    // español
                    "Single cylinder",    // inglés
                    "Cilindro singolo",    // italiano
                    "Cilindro único",    // portugués
                    "Cylindre unique",    // francés
                    "单缸"    // chino
                ]
            ],


            '83' => [
                'description' => [
                    "Velocidad de funcionamiento: 280 - 330 RPM",    // español
                    "Running speed: 280 - 330 RPM",    // inglés
                    "Velocità di funzionamento: 280 - 330 RPM",    // italiano
                    "Velocidade de operação: 280 - 330 RPM",    // portugués
                    "Vitesse de fonctionnement : 280 - 330 tr/min",    // francés
                    "运行速度: 280 - 330 转/分钟"    // chino
                ]
            ],
            '84' => [
                'description' => [
                    "Alimentación: una/dos alimentaciones",    // español
                    "Feed: One/two feeds",    // inglés
                    "Alimentazione: una/due alimentazioni",    // italiano
                    "Alimentação: uma/duas alimentações",    // portugués
                    "Alimentation : une/deux alimentations",    // francés
                    "进料: 一种/两种进料"    // chino
                ]
            ],
            '85' => [
                'description' => [
                    "Alimentación automática de hilo",    // español
                    "Automatic yarn feeding",    // inglés
                    "Alimentazione automatica del filato",    // italiano
                    "Alimentação automática de fio",    // portugués
                    "Alimentation automatique de fil",    // francés
                    "自动供线"    // chino
                ]
            ],
            '86' => [
                'description' => [
                    "13 lanzaderas laterales de hilo",    // español
                    "13 side yarn shuttles",    // inglés
                    "13 navette laterali per filato",    // italiano
                    "13 lançadeiras laterais de fio",    // portugués
                    "13 navettes latérales pour fil",    // francés
                    "13 个侧面纱线梭子"    // chino
                ]
            ],
            '87' => [
                'description' => [
                    "Las agujas para máquinas de calcetería cumplen con los requisitos de la producción normal de tejidos de punto.",    // español
                    "Hosiery machine needles meet the requirements of normal knitting production.",    // inglés
                    "Le aghi per macchine da calze soddisfano i requisiti della produzione normale di maglieria.",    // italiano
                    "As agulhas para máquinas de meias atendem aos requisitos da produção normal de tricô.",    // portugués
                    "Les aiguilles pour machines à bas répondent aux exigences de la production normale de tricot.",    // francés
                    "袜机针满足正常编织生产的要求。"    // chino
                ]
            ],
            '88' => [
                'description' => [
                    "Cuando se interrumpe el suministro de energía, el sistema puede retener el programa y los datos en ejecución, y el sistema continuará ejecutando el programa después de que se restablezca el suministro de energía.",    // español
                    "When the power supply is interrupted, the system can retain the program and data in execution and system continue to execute the  program after the power supply is restored.",    // inglés
                    "Quando l'alimentazione viene interrotta, il sistema può mantenere il programma e i dati in esecuzione, e il sistema continuerà ad eseguire il programma dopo il ripristino dell'alimentazione.",    // italiano
                    "Quando o fornecimento de energia é interrompido, o sistema pode reter o programa e os dados em execução, e o sistema continuará a executar o programa após o restabelecimento do fornecimento de energia.",    // portugués
                    "Lorsque l'alimentation est interrompue, le système peut conserver le programme et les données en cours d'exécution, et le système continuera à exécuter le programme après la restauration de l'alimentation.",    // francés
                    "当电源中断时，系统可以保留正在执行的程序和数据，并在电源恢复后继续执行程序。"    // chino
                ]
            ],
            //Braiding machines
            '89' => [
                'description' => [
                    "Máquinas de trenzado que van desde 3 husillos hasta 640 husillos, para satisfacer las diversas necesidades de diferentes industrias, campos y usuarios.",    // español
                    "Braiding machines ranging from 3 spindles to 640 spindles, in order to meet the various needs of different industries, fields, users.",    // inglés
                    "Macchine per intrecciatura che vanno da 3 mandrini a 640 mandrini, per soddisfare le diverse esigenze di varie industrie, settori e utenti.",    // italiano
                    "Máquinas de Trançar que variam de 3 eixos a 640 eixos, para atender às diversas necessidades de diferentes indústrias, campos e usuários.",    // portugués
                    "Machines à tresser allant de 3 broches à 640 broches, afin de répondre aux divers besoins des différentes industries, secteurs et utilisateurs.",    // francés
                    "编织机从3个主轴到640个主轴，以满足不同工业、领域和用户的各种需求。"    // chino
                ]
            ],
            '90' => [
                'description' => [
                    "Los productos de maquinaria de trenzado abarcan una amplia gama de aplicaciones civiles diarias, como cordones, accesorios para prendas, cinturones, material para zapatos, líneas de pesca, redes de pesca, cables y cordones deportivos. También se aplican en los sectores médico, petroquímico, automotriz, de cuerdas marinas, aeroespacial, militar y compuestos.",    // español
                    "Braiding machinery products cover a wide range of daily civil applications such as shoelace, garments accessories, belts, shoe material, fishing lines, fishing nets, wire and cable, and sport cord, also application in the medical, petrochemical, automotive, marine rope, aerospace, military and composites.",    // inglés
                    "I prodotti della macchina per intrecciatura coprono una vasta gamma di applicazioni civili quotidiane, come lacci, accessori per abbigliamento, cinture, materiali per scarpe, fili da pesca, reti da pesca, cavi e corde sportive. Si applicano anche nei settori medico, petrolchimico, automobilistico, corde marine, aerospaziale, militare e compositi.",    // italiano
                    "Os produtos de Máquinas de Trançar cobrem uma ampla gama de aplicações civis diárias, como cadarços, acessórios para roupas, cintos, material para calçados, linhas de pesca, redes de pesca, fios e cabos, e cordas esportivas. Também são aplicados nos setores médico, petroquímico, automotivo, de cordas marinhas, aeroespacial, militar e compostos.",    // portugués
                    "Les produits de machines à tresser couvrent une large gamme d'applications civiles quotidiennes, telles que les lacets, les accessoires pour vêtements, les ceintures, les matériaux pour chaussures, les fils de pêche, les filets de pêche, les fils et câbles, et les cordes sportives. Ils sont également utilisés dans les secteurs médical, pétrochimique, automobile, cordes marines, aérospatial, militaire et composites.",    // francés
                    "编织机械产品涵盖了广泛的日常民用应用，如鞋带、服装配件、腰带、鞋材、钓鱼线、渔网、线缆和运动绳。还应用于医疗、石油化工、汽车、海洋绳索、航空航天、军事和复合材料等领域。"    // chino
                ]
            ],
            '91' => [
                'description' => [
                    "Las máquinas pueden funcionar 24 horas al día, 7 días a la semana sin necesidad de cambiar las bobinas (dependiendo del tamaño del hilo).",    // español
                    "Machines can run 24 hours/7 days without change bobbins (depends on yarn size).",    // inglés
                    "Le macchine possono funzionare 24 ore su 24, 7 giorni su 7 senza dover cambiare le bobine (a seconda della dimensione del filo).",    // italiano
                    "As máquinas podem funcionar 24 horas por dia, 7 dias por semana, sem necessidade de trocar as bobinas (dependendo do tamanho do fio).",    // portugués
                    "Les machines peuvent fonctionner 24 heures sur 24, 7 jours sur 7 sans changer les bobines (selon la taille du fil).",    // francés
                    "机器可以全天候运行，7天无休，且无需更换线轴（具体取决于纱线的尺寸）。"    // chino
                ]
            ],
            '92' => [
                'description' => [
                    "Movimiento de parada automática, el inversor tiene varias funciones: puede contar metros, ajustar la velocidad, configurar la protección contra sobrecorriente, registrar el tiempo de producción y establecer la producción. Esta máquina puede estar equipada con un alimentador de goma según las necesidades del cliente.",    // español
                    "Auto-stop motion, inverter has various functions, can count meters, adjust speed, set current protection, record production time and set output. This machine can be equipped with rubber feeder depending to customer needs.",    // inglés
                    "Movimento di arresto automatico, l'inverter ha diverse funzioni: può contare i metri, regolare la velocità, impostare la protezione contro le sovracorrenti, registrare il tempo di produzione e impostare la produzione. Questa macchina può essere equipaggiata con un alimentatore di gomma a seconda delle esigenze del cliente.",    // italiano
                    "Movimento de parada automática, o inversor possui várias funções: pode contar metros, ajustar a velocidade, configurar a proteção contra corrente, registrar o tempo de produção e definir a produção. Esta máquina pode ser equipada com um alimentador de borracha, conforme as necessidades do cliente.",    // portugués
                    "Mouvement d'arrêt automatique, l'onduleur possède diverses fonctions : il peut compter les mètres, ajuster la vitesse, définir la protection contre les surintensités, enregistrer le temps de production et définir la production. Cette machine peut être équipée d'un alimentateur de caoutchouc en fonction des besoins du client.",    // francés
                    "自动停止运动，变频器具有多种功能，可以计量米数、调整速度、设置电流保护、记录生产时间和设定产量。根据客户需求，这台机器可以配备橡胶进料器。"    // chino
                ]
            ],
            //Tipping machines
            '93' => [
                'description' => [
                    "Ajuste de la longitud de los cordones.",    // español
                    "Adjustment of the length of the laces.",    // inglés
                    "Regolazione della lunghezza dei lacci.",    // italiano
                    "Ajuste do comprimento dos cadarços.",    // portugués
                    "Ajustement de la longueur des lacets.",    // francés
                    "调整鞋带的长度。"    // chino
                ]
            ],
            '94' => [
                'description' => [
                    "Disponible en diferentes tamaños según la longitud de los cordones.",    // español
                    "Available in different sizes according to laces length.",    // inglés
                    "Disponibile in diverse dimensioni a seconda della lunghezza dei lacci.",    // italiano
                    "Disponível em diferentes tamanhos de acordo com o comprimento dos cadarços.",    // portugués
                    "Disponible en différentes tailles selon la longueur des lacets.",    // francés
                    "根据鞋带长度提供不同尺寸。"    // chino
                ]
            ],
            '95' => [
                'description' => [
                    "En automáticas, longitud de 0,40 a 2,2 metros.",    // español
                    "In automatics, length from 0.40 to 2.2 meters.",    // inglés
                    "Nelle automatiche, lunghezza da 0,40 a 2,2 metri.",    // italiano
                    "Em automáticas, comprimento de 0,40 a 2,2 metros.",    // portugués
                    "En automatiques, longueur de 0,40 à 2,2 mètres.",    // francés
                    "在自动机中，长度从0.40到2.2米。"    // chino
                ]
            ],
            '96' => [
                'description' => [
                    "En automáticas, producción de 4,000 a 6,000 piezas por hora.",    // español
                    "In automatic, output from 4,000 to 6,000 pieces per hour.",    // inglés
                    "Nelle automatiche, produzione da 4.000 a 6.000 pezzi all'ora.",    // italiano
                    "Em automáticas, produção de 4.000 a 6.000 peças por hora.",    // portugués
                    "En automatiques, production de 4 000 à 6 000 pièces par heure.",    // francés
                    "在自动机中，每小时产量为4,000至6,000件。"    // chino
                ]
            ],
            '97' => [
                'description' => [
                    "Para cinta simple sin logotipo, para cordones de zapatos o asas de bolsas.",    // español
                    "For simple ribbon without logo for shoelace or for bag handle.",    // inglés
                    "Per nastro semplice senza logo, per lacci di scarpe o maniglie di borse.",    // italiano
                    "Para fita simples sem logotipo, para cadarços ou alças de bolsas.",    // portugués
                    "Pour ruban simple sans logo, pour lacets ou poignées de sacs.",    // francés
                    "适用于无标志的简单鞋带或包袋手柄用带子。"    // chino
                ]
            ],
            '98' => [
                'description' => [
                    "Para puntas de acetato con o sin logotipo.",    // español
                    "For acetate tips with or without logo.",    // inglés
                    "Per punte in acetato con o senza logo.",    // italiano
                    "Para pontas de acetato com ou sem logotipo.",    // portugués
                    "Pour embouts en acétate avec ou sans logo.",    // francés
                    "适用于带或不带标志的醋酸纤维尖头。"    // chino
                ]
            ],
            '99' => [
                'description' => [
                    "Diferentes tipos de máquinas de bobinado:\n
                    Máquina de bobinado automática de 2 cabezales\n
                    Máquina de bobinado automática de 2 cabezales (tipo simple)\n
                    Máquina de bobinado de alambre\n
                    Máquina de bobinado automática 168\n ",    // español
                    "Different types of winding machines:\n
                    2 head automatic winding machine\n
                    2 head automatic winding machine (simple type)\n
                    Wire winding machine\n
                    168 automatic winding machine",    // inglés
                    "Diversi tipi di macchine avvolgitrici:\n
                    Macchina avvolgitrice automatica a 2 teste\n
                    Macchina avvolgitrice automatica a 2 teste (tipo semplice)\n
                    Macchina avvolgitrice per filo\n
                    Macchina avvolgitrice automatica 168",    // italiano
                    "Diferentes tipos de máquinas de bobinagem:\n
                    Máquina de bobinagem automática de 2 cabeçotes\n
                    Máquina de bobinagem automática de 2 cabeçotes (tipo simples)\n
                    Máquina de bobinagem de fio\n
                    Máquina de bobinagem automática 168",    // portugués
                    "Différents types de machines d'enroulement :\n
                    Machine d'enroulement automatique à 2 têtes\n
                    Machine d'enroulement automatique à 2 têtes (type simple)\n
                    Machine d'enroulement de fil\n
                    Machine d'enroulement automatique 168\n",    // francés
                    "不同类型的绕线机：\n
                    两头自动绕线机\n
                    两头自动绕线机（简单型）\n
                    绕线机\n
                    168自动绕线机\n"    // chino
                ]
            ],
            '100' => [
                'description' => [
                    "Fácil instalación y ajuste",    // español
                    "Easy installation and adjustment.",    // inglés
                    "Facile installazione e regolazione",    // italiano
                    "Fácil instalação e ajuste",    // portugués
                    "Installation et réglage faciles",    // francés
                    "易于安装和调节"    // chino
                ]
            ],
            '101' => [
                'description' => [
                    "Para bobinas de diferentes tamaños",    // español
                    "For bobbins of different sizes.",    // inglés
                    "Per bobine di diverse dimensioni",    // italiano
                    "Para bobinas de diferentes tamanhos",    // portugués
                    " Pour des bobines de différentes tailles",    // francés
                    "适用于不同尺寸的线轴"    // chino
                ]
            ],
            '102' => [
                'description' => [
                    "Con dispositivo de corte de hilo",   
                    "With thread cutting device.",    
                    "Con dispositivo di taglio del filo",    // italiano
                    "Com dispositivo de corte de fio",    // portugués
                    "Avec dispositif de coupe du fil",    // francés
                    "配有切线装置"    // chino
                ]
            ],
            //nnedle machines
            '103' => [
                'description' => [
                    "Producción: 60-120 metros/hora.",    // español
                    "60-120 meters/hour output",    // inglés
                    "Produzione: 60-120 metri/ora.",    // italiano
                    "Produção: 60-120 metros/hora.",    // portugués
                    "Production : 60-120 mètres/heure.",    // francés
                    "输出量：60-120米/小时。"    // chino
                ]
            ],
            '104' => [
                'description' => [
                    "Para diferentes tamaños de agujas.",    // español
                    "For different needle sizes.",    // inglés
                    "Per diverse dimensioni di aghi.",    // italiano
                    "Para diferentes tamanhos de agulhas.",    // portugués
                    "Pour différentes tailles d'aiguilles.",    // francés
                    "适用于不同尺寸的针。"    // chino
                ]
            ],

            '105' => [
                'description' => [
                    "Para cuerda plana y redonda.",    // español
                    "For flat and round rope.",    // inglés
                    "Per corda piatta e tonda.",    // italiano
                    "Para corda plana e redonda.",    // portugués
                    "Pour corde plate et ronde.",    // francés
                    "适用于平绳和圆绳。"    // chino
                ]
            ],
            '106' => [
                'description' => [
                    "Con y sin dispositivo de calefacción.",    // español
                    "With and without heating device.",    // inglés
                    "Con e senza dispositivo di riscaldamento.",    // italiano
                    "Com e sem dispositivo de aquecimento.",    // portugués
                    "Avec et sans dispositif de chauffage.",    // francés
                    "有和没有加热装置。"    // chino
                ]
            ],
            '107' => [
                'description' => [
                    "Availability of spare parts for this machine.",    // español
                    "Disponibilidad de repuestos para esta máquina.",    // inglés
                    "Disponibilità di ricambi per questa macchina.",    // italiano
                    "Disponibilidade de peças de reposição para esta máquina.",    // portugués
                    "Disponibilité des pièces de rechange pour cette machine.",    // francés
                    "该机器的备件供应情况。"    // chino
                ]
            ],
            //sizing
            '108' => [
                'description' => [
                    "Ancho definido: 3.000 mm.",    // español
                    "Defined width: 3,000mm.",    // inglés
                    "Larghezza definita: 3.000 mm.",    // italiano
                    "Largura definida: 3.000 mm.",    // portugués
                    "Largeur définie: 3.000 mm.",    // francés
                    "定义宽度：3,000毫米。"    // chino
                ]
            ],
            '109' => [
                'description' => [
                    "Ancho de trabajo: 1.800 mm.",
                    "Working width: 1,800mm.",    
                    "Larghezza di lavoro: 1.800 mm.",    // italiano
                    "Largura de trabalho: 1.800 mm.",    // portugués
                    "Largeur de travail: 1.800 mm.",    // francés
                    "工作宽度：1,800毫米。"    // chino
                ]
            ],
            '110' => [
                'description' => [
                    "Diámetro de bobinado: 1.000/1.100 mm.",    // español
                    "Winding diameter: 1,000/1,100mm.",    // inglés
                    "Diametro di avvolgimento: 1.000/1.100 mm.",    // italiano
                    "Diâmetro de enrolamento: 1.000/1.100 mm.",    // portugués
                    "Diamètre d'enroulement: 1.000/1.100 mm.",    // francés
                    "卷绕直径：1,000/1,100毫米。"    // chino
                ]
            ],
            '111' => [
                'description' => [
                    "Temperatura de la caja: 0-100°C.",    // español
                    "Box temperature: 0-100oC.",    // inglés
                    "Temperatura della scatola: 0-100°C.",    // italiano
                    "Temperatura da caixa: 0-100°C.",    // portugués
                    "Température de la boîte: 0-100°C.",    // francés
                    "箱体温度：0-100°C。"    // chino
                ]
            ],
            '112' => [
                'description' => [
                    "Velocidad de la máquina: 0,5-120 m/min.",    // español
                    "Machine speed: 0.5-120 m/min.",    // inglés
                    "Velocità della macchina: 0,5-120 m/min.",    // italiano
                    "Velocidade da máquina: 0,5-120 m/min.",    // portugués
                    "Vitesse de la machine: 0,5-120 m/min.",    // francés
                    "机器速度：0.5-120米/分钟。"    // chino
                ]
            ],
            //stenter m
            '113' => [
                'description' => [
                    "Puede adaptarse a diferentes anchos.",    // español
                    "Can be adapted to different widths.",    // inglés
                    "Può essere adattato a diverse larghezze.",    // italiano
                    "Adaptável a diferentes larguras.",    // portugués
                    "Peut être adapté à différentes largeurs.",    // francés
                    "可以适应不同的宽度。"    // chino
                ]
            ],

            '114' => [
                'description' => [
                    " Velocidad mecánica ajustable según la cantidad de cámaras y el tipo de tela.",    // español
                    "Mechanical speed adjustable according to chamber quantity and fabric type.",    // inglés
                    "Velocità meccanica regolabile in base alla quantità di camere e al tipo di tessuto.",    // italiano
                    "Velocidade mecânica ajustável de acordo com a quantidade de câmaras e o tipo de tecido.",    // portugués
                    "Vitesse mécanique ajustable en fonction du nombre de chambres et du type de tissu.",    // francés
                    " 机械速度可根据机箱数量和织物类型调整。"    // chino
                ]
            ],

            '115' => [
                'description' => [
                    "Fuente de calor: Gas natural, aceite térmico, electricidad, vapor.",    // español
                    "Heat source: Natural gas, heat transfer oil, electricity, steam.",    // inglés
                    "Fonte di calore: Gas naturale, olio termico, elettricità, vapore.",    // italiano
                    "Fonte de calor: Gás natural, óleo térmico, eletricidade, vapor.",    // portugués
                    "Source de chaleur : Gaz naturel, huile thermique, électricité, vapeur.",    // francés
                    "热源：天然气、导热油、电力、蒸汽。"    // chino
                ]
            ],
            '116' => [
                'description' => [
                    "Se sugiere crear una cotización personalizada adaptada a las necesidades de cada cliente. Para ello, se recomienda que te pongas en contacto con tu representante de ventas.",    // español
                    "It is suggested to create a customized quotation adapted to the needs of each client. For this, it is suggested that you contact your sales representative.",    // inglés
                    "Si suggerisce di creare un preventivo personalizzato adattato alle esigenze di ogni cliente. Per questo, si consiglia di contattare il proprio rappresentante di vendita.",    // italiano
                    "Sugere-se criar uma cotação personalizada adaptada às necessidades de cada cliente. Para isso, sugere-se que você entre em contato com seu representante de vendas.",    // portugués
                    "Il est suggéré de créer un devis personnalisé adapté aux besoins de chaque client. Pour cela, il est conseillé de contacter votre représentant commercial.",    // francés
                    "建议根据每个客户的需求创建定制报价。为此，建议您联系您的销售代表。"    // chino
                ]
            ],
            //Dye jigg
            '117' => [
                'description' => [
                    "Se utilizan tecnologías avanzadas de inversor de frecuencia de CA, control PLC y comunicación de datos.",    // español
                    "Advanced AC frequency invert driving, PLC control and data communication technology are used.",    // inglés
                    "Vengono utilizzate tecnologie avanzate di inverter a frequenza AC, controllo PLC e comunicazione dei dati.",    // italiano
                    "São utilizadas tecnologias avançadas de inversor de frequência AC, controle PLC e comunicação de dados.",    // portugués
                    "Des technologies avancées d'inverseur de fréquence AC, de contrôle PLC et de communication des données sont utilisées.",    // francés
                    "采用先进的交流频率变频驱动、PLC 控制和数据通信技术。"    // chino
                ]
            ],
            '118' => [
                'description' => [
                    "Excelente función de diálogo de interfaz hombre-computadora.",    // español
                    "Excellent human-computer interface dialogue function.",    // inglés
                    " Eccellente funzione di dialogo dell'interfaccia uomo-computer.",    // italiano
                    "Excelente função de diálogo da interface homem-computador.",    // portugués
                    "Excellente fonction de dialogue d'interface homme-ordinateur.",    // francés
                    "出色的人机界面对话功能。"    // chino
                ]
            ],
            '119' => [
                'description' => [
                    "Control automático de temperatura, inversión automática de dirección, ciclos de grabación automáticos, parada automática y función de balanceo de tela.",    // español
                    "Auto-temperature control, auto direction reversing, auto record cycles, auto stop and fabric swing function.",    // inglés
                    "Controllo automatico della temperatura, inversione automatica della direzione, cicli di registrazione automatici, arresto automatico e funzione di oscillazione del tessuto.",    // italiano
                    "Controle automático de temperatura, reversão automática de direção, ciclos automáticos de gravação, parada automática e função de oscilação de tecido.",    // portugués
                    "Contrôle automatique de la température, inversion automatique de la direction, cycles d'enregistrement automatiques, arrêt automatique et fonction de balancement du tissu.",    // francés
                    "自动温度控制、自动方向反转、自动记录周期、自动停止和织物摆动功能。"    // chino
                ]
            ],
            '120' => [
                'description' => [
                    "Control constante de la tensión.",    // español
                    "Constant control of tension.",    // inglés
                    "Controllo costante della tensione.",    // italiano
                    "Controle constante de tensão.",    // portugués
                    "Contrôle constant de la tension.",    // francés
                    "持续的张力控制。"    // chino
                ]
            ],
            '121' => [
                'description' => [
                    "Diseño avanzado, estructura razonable, amplia adaptabilidad, excelente rendimiento, mantenimiento sencillo y conveniente, operación segura y confiable.",    // español
                    "Advanced design, reasonable structure, wide adaptability, excellent performance, simple and convenient maintenance, safe and reliable operation.",    // inglés
                    "Design avanzato, struttura ragionevole, ampia adattabilità, eccellenti prestazioni, manutenzione semplice e conveniente, funzionamento sicuro e affidabile.",    // italiano
                    "Design avançado, estrutura razoável, ampla adaptabilidade, excelente desempenho, manutenção simples e conveniente, operação segura e confiável.",    // portugués
                    "Conception avancée, structure raisonnable, grande adaptabilité, performance excellente, maintenance simple et pratique, fonctionnement sûr et fiable.",    // francés
                    "先进的设计，合理的结构，广泛的适应性，优异的性能，简便的维护，安全可靠的操作。"    // chino
                ]
            ],
            '122' => [
                'description' => [
                    "Ancho máximo de trabajo: 1,400 - 3,600 mm.",    // español
                    "Max. working width: 1,400 - 3,600 mm.",    // inglés
                    "Larghezza massima di lavoro: 1.400 - 3.600 mm.",    // italiano
                    "Largura máxima de trabalho: 1.400 - 3.600 mm.",    // portugués
                    "Largeur maximale de travail : 1.400 - 3.600 mm.",    // francés
                    "最大工作宽度：1,400 - 3,600 毫米。"    // chino
                ]
            ],

            //Electronic Jacquard
            '123' => [
                'description' => [
                    "Construcción óptima de la máquina, especialmente para tejido de producción de alta velocidad, alta carga y máxima flexibilidad.",    // español
                    "Optimal machine construction, especially for high speed, high load production weaving, and maximum flexibility.",    // inglés
                    "Costruzione ottimale della macchina, soprattutto per la tessitura ad alta velocità, carico elevato e massima flessibilità",    // italiano
                    "Construção otimizada da máquina, especialmente para tecelagem de alta velocidade, alta carga de produção e máxima flexibilidade.",    // portugués
                    "Construction optimale de la machine, spécialement pour le tissage à grande vitesse, à forte charge de production et avec une flexibilité maximale.",    // francés
                    "最佳的机器结构，特别适用于高速、高负荷的生产编织以及最大的灵活性 (Zuì jiā de jīqì jiégòu, tèbié shìyòng yú gāosù, gāo fùhè de shēngchǎn biānzhī yǐjí zuìdà de línghuó xìng)."    // chino
                ]
            ],
            '124' => [
                'description' => [
                    "Compatible con todo tipo de máquinas de tejido (rapier, lanzadera, chorro de aire, chorro de agua, etc.).",    // español
                    "Supporting all kinds of weaving machines (rapier, piece shuttle, air jet, water jet, etc.)",    // inglés
                    "Supporta tutti i tipi di telai (rapier, navetta, getto d'aria, getto d'acqua, ecc.).",    // italiano
                    "Suporta todos os tipos de máquinas de tecelagem (rapier, lançadeira, jato de ar, jato de água, etc.).",    // portugués
                    "Compatible avec tous types de métiers à tisser (rapier, navette, jet d'air, jet d'eau, etc.).",    // francés
                    "支持各种织机（剑杆、梭织机、喷气、喷水等）(Zhīchí gè zhǒng zhī jī (jiàngǎn, suō zhī jī, pēnqì, pēnshuǐ děng))."    // chino
                ]
            ],
            '125' => [
                'description' => [
                    "Muy robusto, resistente al desgaste y diseñado para muchos años de uso diario con un mínimo de mantenimiento.",    // español
                    "Very robust, wear-resistant, and designed for many years of daily use with a minimum of maintenance.",    // inglés
                    "Molto robusto, resistente all'usura e progettato per molti anni di uso quotidiano con una manutenzione minima.",    // italiano
                    "Muito robusto, resistente ao desgaste e projetado para muitos anos de uso diário com manutenção mínima.",    // portugués
                    "Très robuste, résistant à l'usure, et conçu pour de nombreuses années d'utilisation quotidienne avec un minimum d'entretien.",    // francés
                    " 非常坚固，耐磨，设计用于多年日常使用，且维护需求极少 (Fēicháng jiāngù, nàimó, shèjì yòng yú duōnián rìcháng shǐyòng, qiě wéihù xūqiú jí shǎo)."    // chino
                ]
            ],
            '126' => [
                'description' => [
                    "Leva en el interior de un sistema de tanque cerrado, minimiza el desgaste y extiende la vida útil.",    // español
                    "Cam in the inner of closed tank system, minimize wear and tear, extend working life.",    // inglés
                    "Camma all'interno di un sistema di serbatoio chiuso, minimizza l'usura e prolunga la durata di vita.",    // italiano
                    "Sistema de excêntricos que minimiza e prolonga a vida útil",    // portugués
                    "Came à l'intérieur d'un système de réservoir fermé, minimise l'usure et prolonge la durée de vie.",    // francés
                    "闭合罐系统内部的凸轮，最大限度减少磨损，延长使用寿命 (Bìhé guàn xìtǒng nèibù de tūlún, zuìdà xiàndù jiǎnshǎo móshuān, yáncháng shǐyòng shòumìng)."    // chino
                ]
            ],
            '127' => [
                'description' => [
                    "Disponible con un número diferente de ganchos y función de red para transferir el diseño del patrón.",    // español
                    "Available with a different number of hooks and network function to transfer the pattern design.",    // inglés
                    "Disponibile con un numero differente di ganci e funzione di rete per trasferire il disegno del motivo.",    // italiano
                    "Disponível com um número diferente de ganchos e função de rede para transferir desenhos e controlar a produtividade",    // portugués
                    "Disponible avec un nombre différent de crochets et une fonction de réseau pour transférer le design du motif.",    // francés
                    "提供不同数量的钩子和网络功能以传输图案设计 (Tígōng bùtóng shùliàng de gōuzi hé wǎngluò gōngnéng yǐ chuánshū tú'àn shèjì)."    // chino
                ]
            ],


            // '' => [
            //                 'description' => [
            //                     "",    // español
            //                     "",    // inglés
            //                     "",    // italiano
            //                     "",    // portugués
            //                     "",    // francés
            //                     ""    // chino
            //                 ]
            //             ],



        ];
    }
}
