<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
// use Faker\Factory as Faker;

class MachineDetailTranslationSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {

        // Check if we are sowing or reversing
        $rollback = env('SEED_ROLLBACK', false);

        if ($rollback) {
            // Temporarily disable foreign key restrictions
            DB::statement('SET FOREIGN_KEY_CHECKS = 0;');
            // Truncate all machine_detail_translations
            DB::table('machine_detail_translations')->truncate();
        } else {
            // $faker = Faker::create();
            // $details = DB::table('machine_details')->pluck('id')->toArray();
            // $languages = DB::table('languages')->pluck('id')->toArray();





            //Water Looms
            $details = [
                '1' => [
                    'description' => [
                        "Alto rendimiento",    // español
                        "High-speed performance",    // inglés
                        "Prestazioni ad alta velocità",    // italiano
                        "Tela touchscreen Led",    // portugués
                        "Haute vitesse",    // francés
                        "高速性能"    // chino] 
                    ]
                ],
                '2' => [
                    'description' => [
                        "Amplio rango de tejido",    // español
                        "Wide wovenable range",    // inglés
                        "Ampia gamma di tessitura",    // italiano
                        "Super motor que evita marcas na partida",    // portugués
                        "Large plage tissable",    // francés
                        "宽可编织范围"    // chino
                    ]
                ],
                '3' => [
                    'description' => [
                        "Operación fácil",    // español
                        "Easy operation",    // inglés
                        "Operazione facile",    // italiano
                        "Velocidade até 800rpm",    // portugués
                        "Opération facile",    // francés
                        "操作简单"    // chino
                    ]
                ],
                '4' => [
                    'description' => [
                        "Protección ambiental perfecta",    // español
                        "Perfect environmental protection",    // inglés
                        "Protezione ambientale perfetta",    // italiano
                        "Alta qualidade e eficiência",    // portugués
                        "Protection environnementale parfaite",    // francés
                        "完美的环境保护"    // chino
                    ]
                ],
                //Rapier Looms
                '5' => [
                    'description' => [
                        "Sistema de batido fuerte",    // español
                        "Strong beating system",    // inglés
                        "Sistema di battitura forte",    // italiano
                        "Sistema de inserção voo livre ",    // portugués
                        "Système de battement fort",    // francés
                        "强大的打击系统"    // chino
                    ]
                ],
                '6' => [
                    'description' => [
                        "Excelente estabilidad",    // español
                        "Excellent stability",    // inglés
                        "Eccellente stabilità",    // italiano
                        "Velocidade até 500rpm",    // portugués
                        "Excellente stabilité",    // francés
                        "优秀的稳定性"    // chino
                    ]
                ],
                '7' => [
                    'description' => [
                        "Ahorro de energía",    // español
                        "Energy saving",    // inglés
                        "Risparmio energetico",    // italiano
                        "Super motor direto para redução ",    // portugués
                        "Économie d'énergie",    // francés
                        "节能"    // chino
                    ]
                ],
                '8' => [
                    'description' => [
                        "Baja vibración",    // español
                        "Low vibration",    // inglés
                        "Bassa vibrazione",    // italiano
                        "Do consumo de energia",    // portugués
                        "Faible vibration",    // francés
                        "低振动"    // chino
                    ]
                ],
                //Terry Looms
                '9' => [
                    'description' => [
                        "Puede tejer diferentes tipos de toallas.",    // español
                        "Can weave up different types of towels.",    // inglés
                        "Può tessere diversi tipi di asciugamani.",    // italiano
                        "Estrutura robusta que reduz a vibração, melhorando a eficiência. Sistema de lubrificação centralizado",    // portugués
                        "Peut tisser différents types de serviettes.",    // francés
                        "可以编织不同类型的毛巾。"    // chino
                    ]
                ],
                '10' => [
                    'description' => [
                        "Patrón de baja vibración a alta velocidad y eficiencia.",    // español
                        "Low vibration pattern at high-speed and efficiency.",    // inglés
                        "Modello a bassa vibrazione ad alta velocità ed efficienza.",    // italiano
                        "Com filtro duplo e controle direto no CPU. Velocidade até 500rpm",    // portugués
                        "Modèle de faible vibration à haute vitesse et efficacité.",    // francés
                        "高速和效率下的低振动模式。"    // chino
                    ]
                ],
                //Air Looms
                '11' => [
                    'description' => [
                        "Nuevo sistema de control eléctrico de estilo.",    // español
                        "New style electric control system.",    // inglés
                        "Nuovo sistema di controllo elettrico di stile.",    // italiano
                        "Velocidade até 1100rpm",    // portugués
                        "Nouveau système de contrôle électrique de style.",    // francés
                        "新款电气控制系统。"    // chino
                    ]
                ],
                '12' => [
                    'description' => [
                        "Equipado con un sistema de batido equilibrado de baja vibración.",    // español
                        "Equipped with low vibrancy balanced beating system.",    // inglés
                        "Dotato di un sistema di battitura bilanciato a bassa vibrazione.",    // italiano
                        "Estrutura reforçada que permite estabilidade, reduz a vibração e aumenta a produtividade",    // portugués
                        "Équipé d'un système de battage équilibré à faible vibration.",    // francés
                        "配备低振动平衡敲打系统。"    // chino
                    ]
                ],
                '13' => [
                    'description' => [
                        "Sistema experto en tejido",    // español
                        "Weaving Expert System",    // inglés
                        "Sistema esperto di tessitura",    // italiano
                        "Inverter",    // portugués
                        "Système d'expertise en tissage",    // francés
                        "织造专家系统"    // chino
                    ]
                ],
                //Sectional Warping MachineS
                '14' => [
                    'description' => [
                        "Apto para urdir diversos tipos de hilo.",    // español
                        "Suitable for warping various kinds of yarn.",    // inglés
                        "Adatto per l'orditura di vari tipi di filato.",    // italiano
                        "Adequado para urdir diversos tipos de fios.",    // portugués
                        "Adapté pour l'ourdissage de différents types de fils.",    // francés
                        "适用于整经各种纱线。"    // chino
                    ]
                ],
                '15' => [
                    'description' => [
                        "Ancho de trabajo: 2300 - 4800 mm",    // español
                        "Work width: 2300 - 4800 mm",    // inglés
                        "Larghezza di lavoro: 2300 - 4800 mm",    // italiano
                        "Largura de trabalho: 2300 - 4800 mm",    // portugués
                        "Largeur de travail : 2300 - 4800 mm",    // francés
                        "工作宽度：2300 - 4800 毫米"    // chino
                    ]
                ],
                '16' => [
                    'description' => [
                        "Las máquinas pueden ser personalizadas según las necesidades del cliente.",    // español
                        "Machines can be customized according to customer needs.",    // inglés
                        "Le macchine possono essere personalizzate secondo le esigenze del cliente.",    // italiano
                        "As máquinas podem ser personalizadas de acordo com as necessidades do cliente.",    // portugués
                        "Les machines peuvent être personnalisées selon les besoins du client.",    // francés
                        "机器可以根据客户需求定制。"    // chino
                    ]
                ],
                // Direct Warping Machines
                '17' => [
                    'description' => [
                        "Equipo ideal para la preparación antes del dimensionado y el teñido.",    // español
                        "Ideal equipment preparation before sizing and dyeing.",    // inglés
                        "Attrezzatura ideale per la preparazione prima della dimensione e della tintura.",    // italiano
                        "Equipamento ideal para preparação antes do dimensionamento e tingimento.",    // portugués
                        "Équipement idéal pour la préparation avant le dimensionnement et la teinture.",    // francés
                        "染色和定型前的理想设备。"    // chino
                    ]
                ],
                '18' => [
                    'description' => [
                        "Ancho de trabajo: 1600 - 2400 mm",    // español
                        "Work width: 1600 - 2400 mm",    // inglés
                        "Larghezza di lavoro: 1600 - 2400 mm",    // italiano
                        "Largura de trabalho: 1600 - 2400 mm",    // portugués
                        "Largeur de travail : 1600 - 2400 mm",    // francés
                        "工作宽度：1600 - 2400 毫米"    // chino
                    ]
                ],
                '19' => [
                    'description' => [
                        "Las máquinas se pueden personalizar según las necesidades del cliente",    // español
                        "Machines can be customized according to customer needs",    // inglés
                        "Le macchine possono essere personalizzate in base alle esigenze del cliente",    // italiano
                        "As máquinas podem ser personalizadas de acordo com as necessidades do cliente",    // portugués
                        "Les machines peuvent être personnalisées selon les besoins du client",    // francés
                        "机器可以根据客户需求进行定制"    // chino
                    ]
                ],
                //Label Weaving Machine
                '20' => [
                    'description' => [
                        "Jacquard Electrónico",    // español
                        "Electronic Jacquard",    // inglés
                        "Jacquard Elettronico",    // italiano
                        "Jacquard Eletrônico",    // portugués
                        "Jacquard Électronique",    // francés
                        "电子提花机"    // chino
                    ]
                ],
                '21' => [
                    'description' => [
                        "Ancho del telar: 1700 - 1900 mm",    // español
                        "Width loom: 1700 - 1900 mm",    // inglés
                        "Larghezza del telaio: 1700 - 1900 mm",    // italiano
                        "Largura do tear: 1700 - 1900 mm",    // portugués
                        "Largeur du métier: 1700 - 1900 mm",    // francés
                        "织机宽度：1700 - 1900毫米"    // chino
                    ]
                ],

                '22' => [
                    'description' => [
                        "Capacidad de 1800 a 9600 ganchos",    // español
                        "Capacity from 1800 to 9600 hooks",    // inglés
                        "Capacità da 1800 a 9600 ganci",    // italiano
                        "Capacidade de 1800 a 9600 ganchos",    // portugués
                        "Capacité de 1800 à 9600 crochets",    // francés
                        "容量从1800到9600个钩子"    // chino
                    ]
                ],
                //Narrow Fabric Jacquard Loom
                '23' => [
                    'description' => [
                        "Para diferentes aplicaciones como cintas elásticas y no elásticas, correas y más.",    // español
                        "For different applications such as elastic and non-elastic tapes, straps, and more.",    // inglés
                        "Per diverse applicazioni come nastri elastici e non elastici, cinghie e altro.",    // italiano
                        "Para diferentes aplicações como fitas elásticas e não elásticas, correias e mais.",    // portugués
                        "Pour différentes applications telles que des bandes élastiques et non élastiques, des sangles et plus encore.",    // francés
                        "适用于不同的应用，如弹性和非弹性带、带子等。"    // chino
                    ]
                ],
                '24' => [
                    'description' => [
                        "Disponible en diferentes anchos, ganchos y número de líneas.",    // español
                        "Available in different widths, hooks and number of lines.",    // inglés
                        "Disponibile in diverse larghezze, ganci e numero di linee.",    // italiano
                        "Disponível em diferentes larguras, ganchos e número de bocas.",    // portugués
                        "Disponible en différentes largeurs, crochets et nombre de lignes.",    // francés
                        "提供不同宽度、钩子和线路数量。"    // chino
                    ]
                ],
                //High-Speed Needle Loom
                '25' => [
                    'description' => [
                        "Para diferentes aplicaciones, como cintas elásticas y no elásticas, correas y más.",    // español
                        "For different applications such as elastic and non-elastic tapes, straps, and more.",    // inglés
                        "Per diverse applicazioni come nastri elastici e non elastici, cinghie e altro.",    // italiano
                        "Para diferentes aplicações, como fitas elásticas e não elásticas, alças e mais.",    // portugués
                        "Pour différentes applications telles que des rubans élastiques et non élastiques, des sangles et plus encore.",    // francés
                        "适用于不同的应用，如弹性和非弹性带子、带子等。"    // chino
                    ]
                ],
                '26' => [
                    'description' => [
                        "Disponible en diferentes anchuras, ganchos y número de líneas.",    // español
                        "Available in different widths, hooks and number of lines.",    // inglés
                        "Disponibile in diverse larghezze, ganci e numero di linee.",    // italiano
                        "Disponível em diferentes larguras, ganchos e número de linhas.",    // portugués
                        "Disponible en différentes largeurs, crochets et nombre de lignes.",    // francés
                        "有不同宽度、挂钩和线数可供选择。"    // chino
                    ]
                ],
                //High-Speed Automatic Crochet Machine
                '27' => [
                    'description' => [
                        "Ideal para fabricar cintas elásticas y no elásticas, utilizadas en una amplia gama de productos, desde prendas de vestir y cordones hasta artículos deportivos y mucho más.",    // español
                        "Ideal for manufacturing both elastic and non-elastic tapes, used in a wide range of products, from garments and shoelaces to sporting goods and much more.",    // inglés
                        "Ideale per la produzione di nastri elastici e non elastici, utilizzati in una vasta gamma di prodotti, da abbigliamento e lacci alle merci sportive e molto altro.",    // italiano
                        "Ideal para fabricar fitas elásticas e não elásticas, usadas em uma ampla variedade de produtos, desde roupas e cadarços até artigos esportivos e muito mais.",    // portugués
                        "Idéal pour la fabrication de rubans élastiques et non élastiques, utilisés dans une large gamme de produits, des vêtements et lacets aux articles de sport et bien plus encore.",    // francés
                        "适用于制造弹性和非弹性带子，用于从服装和鞋带到运动用品等各种产品中。"    // chino
                    ]
                ],
                //Label & Folding machine
                '28' => [
                    'description' => [
                        "Máquinas multifuncionales, capaces de realizar varios tipos de cortes y pliegues.",    // español
                        "Multi-functional machines, capable of performing various types of cuts and folds.",    // inglés
                        "Macchine multifunzionali, in grado di eseguire vari tipi di tagli e piegature.",    // italiano
                        "Máquinas multifuncionais, capazes de realizar vários tipos de cortes e dobras.",    // portugués
                        "Machines multifonctionnelles, capables d'effectuer différents types de coupes et de plis.",    // francés
                        "多功能机器，能够执行各种类型的切割和折叠。"    // chino
                    ]
                ],
                '29' => [
                    'description' => [
                        "Alta velocidad y precisión.",    // español
                        "High-speed and precision. ",    // inglés
                        "Alta velocità e precisione.",    // italiano
                        "Alta velocidade e precisão.",    // portugués
                        "Haute vitesse et précision.",    // francés
                        "高速和精度。"    // chino
                    ]
                ],
                //Ultrasonic
                '30' => [
                    'description' => [
                        "Ideal para la fabricación de cintas elásticas y no elásticas.",    // español
                        "Ideal for manufacturing both elastic and non-elastic tapes.",    // inglés
                        "Ideale per la produzione di nastri elastici e non elastici.",    // italiano
                        "Ideal para qualquer tipo de etiquetas tecidas e impressas",    // portugués
                        "Idéal pour la fabrication de rubans élastiques et non élastiques.",    // francés
                        "适用于制造弹性和非弹性带材。"    // chino
                    ]
                ],

                '31' => [
                    'description' => [
                        "Utilizado en una amplia gama de productos, desde prendas de vestir y cordones hasta artículos deportivos y mucho más.",    // español
                        "Used in a wide range of products, from garments and shoelaces to sporting goods and much more",    // inglés
                        "Utilizzato in una vasta gamma di prodotti, dai capi di abbigliamento e lacci per scarpe agli articoli sportivi e molto altro.",    // italiano
                        "Adapta à vários tipos de dobra como final, central, mitre, de dissimetria e envelope",    // portugués
                        "Utilisé dans une large gamme de produits, des vêtements et lacets aux articles de sport et bien plus encore.",    // francés
                        "用于各种产品，从服装和鞋带到运动用品等。"    // chino
                    ]
                ],
                //Single jersey

                '32' => [
                    'description' => [
                        "Aplicación: camiseta, ropa deportiva, traje de aeróbic y traje de baño.",    // español
                        "Application T-Shirt, sportswear, aerobic suit and swimming suit. ",    // inglés
                        "Applicazione: t-shirt, abbigliamento sportivo, tuta da aerobica e costume da bagno.",    // italiano
                        "",    // portugués
                        "Application : t-shirt, vêtements de sport, tenue d'aérobic et maillot de bain.",    // francés
                        "应用：T恤、运动服、健美操服和泳衣。"    // chino
                    ]
                ],

                '33' => [
                    'description' => [
                        "Sistema de transmisión único que reduce el desgaste.",    // español
                        "Unique drive system that reduces wear.",    // inglés
                        "Sistema di trasmissione unico che riduce l'usura.",    // italiano
                        "Sistema de transmissão único que reduz o desgaste.",    // portugués
                        "Système de transmission unique qui réduit l'usure.",    // francés
                        "独特的驱动系统，减少磨损。"    // chino
                    ]
                ],

                '34' => [
                    'description' => [
                        "Máquina de tejeduría circular de ancho abierto para felpa de tres hilos.",    // español
                        "Three thread fleece open width circular knitting machine",    // inglés
                        "Macchina per maglieria circolare a larghezza aperta per felpa a tre fili.",    // italiano
                        "Máquina de tricô circular de largura aberta para felpa de três fios.",    // portugués
                        "Machine à tricoter circulaire à largeur ouverte pour molleton à trois fils.",    // francés
                        "三线程宽幅开口圆形针织机。"    // chino
                    ]
                ],

                //Interlock/Rib

                '35' => [
                    'description' => [
                        "Aplicación: Tejidos estructurados con ribete, entrelazado y 8 cierres.",    // español
                        "Application: Rib, interlock and 8 locks  structured fabrics.",    // inglés
                        "Applicazione: Tessuti strutturati con rib, intreccio e 8 chiusure.",    // italiano
                        "Aplicação: Tecidos estruturados com ana, entrelaçamento e 8 fechos.",    // portugués
                        "Application : Tissus structurés avec rib, entrelacs et 8 fermetures.",    // francés
                        " 应用：带有罗纹、交错和8个锁扣的结构性面料。"    // chino
                    ]
                ],

                '36' => [
                    'description' => [
                        "Los engranajes superior e inferior están sumergidos en lubricantes para reducir el ruido, el desgaste, mejorar la precisión y aumentar la durabilidad.",    // español
                        "Top and bottom gears are immersed in lubricants to reduce noise, wear, improve accuracy, and enhance durability.",    // inglés
                        "Gli ingranaggi superiore e inferiore sono immersi in lubrificanti per ridurre il rumore, l'usura, migliorare la precisione e aumentare la durata.",    // italiano
                        "Os engrenagens superior e inferior estão imersos em lubrificantes para reduzir o ruído, o desgaste, melhorar a precisão e aumentar a durabilidade.",    // portugués
                        "Les pignons supérieur et inférieur sont immergés dans des lubrifiants pour réduire le bruit, l'usure, améliorer la précision et accroître la durabilité.",    // francés
                        "顶部和底部的齿轮浸入润滑剂中，以减少噪音、磨损，提高精度和增强耐用性。"    // chino
                    ]
                ],



                //Single computerized          
                '37' => [
                    'description' => [
                        "Aplicación: ropa de moda y ropa interior.",    // español
                        "Application: Fashion clothes and underwear. ",    // inglés
                        "Applicazione: abbigliamento alla moda e biancheria intima.",    // italiano
                        "",    // portugués
                        "Application : vêtements de mode et sous-vêtements.",    // francés
                        "应用：时尚服装和内衣。"    // chino
                    ]
                ],

                '38' => [
                    'description' => [
                        "Caracterizado por un intercambio simple entre jacquard liso y jacquard de malla.",    // español
                        "Characterized by simple interchanging between single and mesh jacquard.",    // inglés
                        "Caratterizzato da un semplice scambio tra jacquard a singolo e jacquard a rete.",    // italiano
                        "Caracterizado pela troca simples entre jacquard liso e jacquard de malha.",    // portugués
                        "Caractérisé par un échange simple entre jacquard uni et jacquard en maille.",    // francés
                        "特点是单面提花和网状提花之间的简单切换。"    // chino
                    ]
                ],

                '39' => [
                    'description' => [
                        "No se necesita software de diseño específico.",    // español
                        "No specific design software needed. ",    // inglés
                        "Nessun software di design specifico necessario.",    // italiano
                        "Nenhum software de design específico necessário.",    // portugués
                        "Aucun logiciel de conception spécifique nécessaire.",    // francés
                        "无需特定设计软件。"    // chino
                    ]
                ],
                //Double computerized
                '40' => [
                    'description' => [
                        "Aplicaciones: ropa, sábanas, almohadas, toallas, tejidos para niños y otros textiles para el hogar.",    // español
                        "Applications: Apparel, sheets, pillows, towels, children´s fabrics and other home textiles. ",    // inglés
                        "Applicazioni: abbigliamento, lenzuola, cuscini, asciugamani, tessuti per bambini e altri tessuti per la casa.",    // italiano
                        "Aplicações: vestuário, lençóis, almofadas, toalhas, tecidos infantis e outros têxteis para o lar.",    // portugués
                        "Applications : vêtements, draps, oreillers, serviettes, tissus pour enfants et autres textiles ",    // francés
                        "应用：服装、床单、枕头、毛巾、儿童面料及其他家用纺织品。"    // chino
                    ]
                ],

                '41' => [
                    'description' => [
                        "No se necesita software de diseño específico.",    // español
                        "No specific design software needed. ",    // inglés
                        "Nessun software di design specifico necessario.",    // italiano
                        "Nenhum software de design específico necessário.",    // portugués
                        "Aucun logiciel de conception spécifique nécessaire.",    // francés
                        "无需特定设计软件。"    // chino
                    ]
                ],
                //Sock Machine

                '42' => [
                    'description' => [
                        "Aplicación: calcetines invisibles, calcetines lisos, calcetines de felpa y calcetines lisos.",    // español
                        "Application: Invisible socks, plain socks, terry and plain socks.",    // inglés
                        "Applicazione: calzini invisibili, calzini lisci, calzini di spugna e calzini lisci.",    // italiano
                        "Aplicação: meias invisíveis, meias lisas, meias de felpa e meias lisas.",    // portugués
                        "Application : chaussettes invisibles, chaussettes unies, chaussettes en éponge et chaussettes unies.",    // francés
                        "应用: 隐形袜、纯色袜、毛巾袜和纯色袜。"    // chino
                    ]
                ],

                '43' => [
                    'description' => [
                        "Rango de agujas: 40 - 200",    // español
                        "Needle range: 40 - 200",    // inglés
                        "Gamma di aghi: 40 - 200",    // italiano
                        "Intervalo de agulhas: 40 - 200",    // portugués
                        "Gamme d'aiguilles : 40 - 200",    // francés
                        "针范围: 40 - 200"    // chino
                    ]
                ],

                '44' => [
                    'description' => [
                        "Diámetro del cilindro: 3¼, 3¾, 4, 4½ pulgadas.",    // español
                        "Cylinder diameter: 31/4, 33/4, 4, 41/2 inch. ",    // inglés
                        "Diametro del cilindro: 3¼, 3¾, 4, 4½ pollici.",    // italiano
                        "Diâmetro do cilindro: 3¼, 3¾, 4, 4½ polegadas.",    // portugués
                        "Diamètre du cylindre : 3¼, 3¾, 4, 4½ pouces.",    // francés
                        "圆筒直径: 3¼, 3¾, 4, 4½ 英寸。"    // chino
                    ]
                ],
                //Braiding

                '45' => [
                    'description' => [
                        "De 3 husillos a 640 husillos",    // español
                        "From 3 spindles to 640 spindles.",    // inglés
                        "Da 3 mandrini a 640 mandrini",    // italiano
                        "De 3 eixos a 640 eixos",    // portugués
                        "De 3 broches à 640 broches",    // francés
                        "从3个主轴到640个主轴"    // chino
                    ]
                ],

                '46' => [
                    'description' => [
                        "Amplia gama de aplicaciones, como textil, médica y otras.",    // español
                        "Vast range of applications such as textile, medical, and others.",    // inglés
                        "Ampia gamma di applicazioni, come tessile, medico e altre.",    // italiano
                        "Ampla gama de aplicações, como têxtil, médica e outras.",    // portugués
                        "Large gamme d'applications, telles que le textile, le médical et d'autres.",    // francés
                        " 广泛的应用范围，如纺织、医疗等。"    // chino
                    ]
                ],

                '47' => [
                    'description' => [
                        "Proporcionamos repuestos para las máquinas de trenzado.",    // español
                        "We provide spare parts for the braiding machines.",    // inglés
                        "Forniamo pezzi di ricambio per le macchine di intrecciatura.",    // italiano
                        "Fornecemos peças de reposição para as Trançadeiras.",    // portugués
                        "Nous fournissons des pièces de rechange pour les machines à tresser.",    // francés
                        "我们提供编织机的备用零件。"    // chino
                    ]
                ],
                //Tipping machines

                '48' => [
                    'description' => [
                        "Capaz de manejar diferentes longitudes de cuerda.",    // español
                        "Capable of handling different rope lengths.",    // inglés
                        "Capace di gestire diverse lunghezze di corda.",    // italiano
                        "Capaz de Pontear diferentes comprimentos de corda.",    // portugués
                        "Capable de gérer différentes longueurs de corde.",    // francés
                        "能够处理不同长度的绳子。"    // chino
                    ]
                ],

                '49' => [
                    'description' => [
                        "Máquinas automáticas y semiautomáticas.",    // español
                        "Automatic & semi automatic machines.",    // inglés
                        "Macchine automatiche e semiautomatiche.",    // italiano
                        "Máquinas automáticas e semiautomáticas.",    // portugués
                        "Machines automatiques et semi-automatiques.",    // francés
                        "自动和半自动机器。"    // chino
                    ]
                ],

                //Winding machines
                '50' => [
                    'description' => [
                        "Modelos diferentes disponibles.",    // español
                        "Different models available.",    // inglés
                        "Modelli diversi disponibili.",    // italiano
                        "Capaz de encher os carreteis de forma automática e rápida otimizando os processos de produção",    // portugués
                        "Différents modèles disponibles.",    // francés
                        "提供不同型号。"    // chino
                    ]
                ],

                '51' => [
                    'description' => [
                        "Instalación y ajuste fáciles.",    // español
                        "Easy installation and adjustment.",    // inglés
                        "Installazione e regolazione facili.",    // italiano
                        "",    // portugués
                        "Installation et réglage faciles.",    // francés
                        "安装和调整简单。"    // chino
                    ]
                ],

                '52' => [
                    'description' => [
                        "Para bobinas de diferentes tamaños.",    // español
                        "For bobbins of different sizes.",    // inglés
                        "Per bobine di diverse dimensioni.",    // italiano
                        "",    // portugués
                        "Pour bobines de différentes tailles.",    // francés
                        " 适用于不同尺寸的线轴。"    // chino
                    ]
                ],


                //Electronic Jaqueard

                '53' => [
                    'description' => [
                        "Adecuado para tejer telas planas y rizo.",    // español
                        "Suitable for weaving flat fabrics and terry cloth.",    // inglés
                        "Adatto per la tessitura di tessuti piani e spugna.",    // italiano
                        "Adequado para tecer tecidos planos e felpudos.",    // portugués
                        "Convient pour tisser des tissus plats et du tissu éponge.",    // francés
                        "适用于编织平织物和毛巾布 (Shìyòng yú biānzhī píng zhīwù hé máojīn bù)."    // chino
                    ]
                ],
                '54' => [
                    'description' => [
                        "Aplicaciones: Tapicería, tela de seda, material para vestidos, fundas de asiento, airbags.",    // español
                        "Applications: Tapestry, silk fabric, dress material, seat covers, airbags.",    // inglés
                        "Applicazioni: Arazzi, tessuto di seta, materiale per abiti, coprisedili, airbag.",    // italiano
                        "Aplicações: Tapeçaria, tecido de seda, material para vestidos, capas de assento, airbags.",    // portugués
                        "Applications : Tapisserie, tissu en soie, tissu pour robes, housses de siège, airbags.",    // francés
                        "应用：挂毯、丝绸面料、服装材料、座套、气囊 (Yìngyòng: guàtǎn, sīchóu miànliào, fúzhuāng cáiliào, zuò tào, qìnáng)."    // chino
                    ]
                ],

                '55' => [
                    'description' => [
                        "Rápido y fácil de instalar.",    // español
                        "Quick and easy to install.",    // inglés
                        "Veloce e facile da installare.",    // italiano
                        "Rápido e fácil de instalar.",    // portugués
                        "Rapide et facile à installer.",    // francés
                        "安装快速且简便 (Ānzhuāng kuàisù qiě jiǎnbiàn)."    // chino
                    ]
                ],

                //Stenter
                '56' => [
                    'description' => [
                        "Ideal para tejidos de punto y tejidos planos.",    // español
                        "Ideal for knitted and woven fabrics.",    // inglés
                        "Ideale per tessuti a maglia e tessuti intrecciati.",    // italiano
                        "Ideal para tecidos de malha e tecidos planos.",    // portugués
                        "Idéal pour les tissus tricotés et tissés.",    // francés
                        "适合针织和梭织面料."    // chino
                    ]
                ],

                '57' => [
                    'description' => [
                        "Principalmente utilizado para el rameado, fijado y acabado de telas de algodón, telas de mezcla de algodón y poliéster, telas de poliéster y telas elásticas.",    // español
                        "Mainly used for stentering, setting, finishing the cotton fabric, poly-cotton fabric, polyester fabric and elastic fabric",    // inglés
                        "Principalmente utilizzato per tendere, fissare e rifinire tessuti di cotone, tessuti in policotone, tessuti in poliestere e tessuti elastici.",    // italiano
                        "Principalmente utilizado para estiramento, fixação e acabamento de tecidos de algodão, tecidos de poli-algodão, tecidos de poliéster e tecidos elásticos.",    // portugués
                        "Principalement utilisé pour le tendeur, le réglage et la finition des tissus en coton, des tissus en polycoton, des tissus en polyester et des tissus élastiques.",    // francés
                        "主要用于定形、定型、整理棉织物、棉涤混纺织物、涤纶织物和弹性织物."    // chino
                    ]
                ],


                //Dye Jigger
                '58' => [
                    'description' => [
                        "Ancho máximo de trabajo: 1,400 - 3,600 mm",    // español
                        "Max. working width: 1,400 - 3,600 mm",    // inglés
                        "Larghezza massima di lavoro: 1.400 - 3.600 mm",    // italiano
                        "Largura máxima de trabalho: 1.400 - 3.600 mm",    // portugués
                        "Largeur de travail maximale : 1 400 - 3 600 mm",    // francés
                        " 最大工作宽度：1,400 - 3,600 毫米"    // chino
                    ]
                ],

                '59' => [
                    'description' => [
                        "Funciona con nylon, seda spandex, algodón, poliéster y otros hilos.",    // español
                        "Works with nylon, silk spandex, cotton, polyester, and other yarns.",    // inglés
                        "Funziona con nylon, seta spandex, cotone, poliestere e altri filati.",    // italiano
                        "Versátil para trabalhar tecidos de nylon, seda spandex, algodão, poliéster e outros",    // portugués
                        "Fonctionne avec du nylon, du spandex en soie, du coton, du polyester et d'autres fils.",    // francés
                        " 适用于尼龙、丝氨纶、棉、涤纶及其他纱线."    // chino
                    ]
                ],

                '60' => [
                    'description' => [
                        "Control constante de la tensión.",    // español
                        "Constant control of tension.",    // inglés
                        "Controllo costante della tensione.",    // italiano
                        "Controle constante da tensão.",    // portugués
                        "Contrôle constant de la tension.",    // francés
                        "张力的持续控制."    // chino
                    ]
                ],

                '61' => [
                    'description' => [
                        "Versátil, capaz de engomar varios tipos de hilo como algodón, poliéster, fibra mixta, etc.",    // español
                        "It can work with various types of yarn such as cotton, polyester, mixed fiber, etc.",    // inglés
                        "Versatile, in grado di stirare vari tipi di fili, come ad esempio: cotone, poliestere, fibra mista, ecc.",    // italiano
                        "Versátil podendo engomar vários tipos de fios, tais como: algodão, poliéster, fibra mista, etc.",    // portugués
                        "Polyvalent pouvant repasser différents types de tissus, notamment le coton, le polyester, les fibres mélangées, etc.",    // francés
                        "多功能，可熨烫各种类型的线，例如：棉花、涤纶、混纺等。"    // chino
                    ]
                ],

                '62' => [
                    'description' => [
                        "Calidad, uniformidad y eficacia.",    // español
                        "Quality, uniformity and efficiency.",    // inglés
                        "Qualità, uniformità ed efficienza.",    // italiano
                        "Qualidade, uniformidade e eficiência",    // portugués
                        "Qualité, uniformité et efficacité",    // francés
                        "质量、均匀度和效率。"    // chino
                    ]
                ],


                // needle-machines

                '63' => [
                    'description' => [
                        "Para diferentes aplicaciones: cuerdas, cordones, etc.",   // español
                        "For different applications: ropes, cords, etc.",    // inglés
                        "Per diverse applicazioni: corde, cordoncini, ecc.",    // italiano
                        "Para diferentes aplicações: cordas, cordões, etc.",    // portugués
                        "Pour différentes applications : cordes, ficelles, etc.",    // francés
                        "适用于不同应用：绳索、细绳等"    // chino
                    ]
                ],
                '64' => [
                    'description' => [
                        "Para diferentes capacidades de agujas",   // español
                        "For different needle capacities",    // inglés
                        "Per diverse capacità di ago",    // italiano
                        "Para diferentes capacidades de agulhas",    // portugués
                        "Pour différentes capacités d'aiguilles",    // francés
                        "适用于不同的针容量"    // chino
                    ]
                ],
                '65' => [
                    'description' => [
                        "Motor de 60W",    // español
                        "60W motor",   // inglés
                        "Motore da 60W",    // italiano
                        "Motor de 60W",    // portugués
                        "Moteur de 60W",    // francés
                        "60W 电机"   // chino
                    ]
                ],
                '66' => [
                    'description' => [
                        "Salida de 60-120 metros/hora",    // español
                        "Output 60-120 meters/hour",    // inglés
                        "Produzione di 60-120 metri/ora",    // italiano
                        "Saída de 60-120 metros/hora",    // portugués
                        "Débit de 60 à 120 mètres/heure",    // francés
                        "输出 60-120 米/小时"   // chino
                    ]
                ],


                // '' => [
                //     'description' => [
                //         "",    // español
                //         "",    // inglés
                //         "",    // italiano
                //         "",    // portugués
                //         "",    // francés
                //         ""    // chino
                //     ]
                // ],


            ];





            foreach ($details as $key => $detail) {
                foreach ($detail["description"] as  $index => $description) {
                    DB::table('machine_detail_translations')->insert([
                        // 'id' => $index,
                        'description' => $description,
                        'machine_detail_id' => $key,
                        'language_id' =>  $index + 1,
                        'created_at' => now(),
                        'updated_at' => now(),
                    ]);
                }
            }
        }
    }
}
