<?php

namespace Database\Seeders;

// use Faker\Factory as Faker;
// use Faker\Guesser\Name;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class MachineDetailSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {

        // Check if we are sowing or reversing
        $rollback = env('SEED_ROLLBACK', false);

        if ($rollback) {
            // Temporarily disable foreign key restrictions
            DB::statement('SET FOREIGN_KEY_CHECKS = 0;');
            // Truncate all machine_details
            DB::table('machine_details')->truncate();
        } else {

            // $faker = Faker::create();

            $details = [

                //Water Looms
                [
                    'machine' => 1,
                    'detail' => [
                        "High-speed performance",    // inglés
                        "Wide wovenable range",    // inglés
                        "Easy operation",    // inglés
                        "Perfect environmental protection",    // inglés

                    ]
                ],
                //Rapier Looms
                [
                    'machine' => 2,
                    'detail' => [
                        "Strong beating system",    // inglés
                        "Excellent stability",
                        "Energy saving",    // inglés
                        "Low vibration",    // inglés

                    ]
                ],

                //Terry Looms
                [
                    'machine' => 3,
                    'detail' => [
                        "Can weave up different types of towels.",    // inglés
                        "Low vibration pattern at high-speed and efficiency.",    // inglés


                    ]
                ],



                //Air Looms
                [
                    'machine' => 4,
                    'detail' => [

                        "New style electric control system.",    // inglés
                        "Equipped with low vibrancy balanced beating system.",    // inglés
                        "Weaving Expert System",    // inglés

                    ]
                ],

                //Sectional Warping MachineS

                [
                    'machine' => 6,
                    'detail' => [
                        " Suitable for warping various kinds of yarn.",
                        "Work width: 2300 - 4800 mm",
                        "Machines can be customized according to customer needs.",
                    ]
                ],
                // Direct Warping Machines
                [
                    'machine' => 7,
                    'detail' => [
                        "Ideal equipment preparation before sizing and dyeing.",
                        "Work width: 1600 - 2400 mm",
                        "Machines can be customized according to customer needs."

                    ]
                ],
                //Label Weaving Machine
                [
                    'machine' => 8,
                    'detail' => [

                        "Electronic Jacquard",
                        "Width loom: 1700 - 1900 mm",
                        "Capacity from 1800 to 9600 hooks"

                    ]
                ],
                //Narrow Fabric Jacquard Loom
                [
                    'machine' => 9,
                    'detail' => [
                        "For different applications such as elastic and non elastic tapes, straps, and more.",
                        "Available in different widths, hooks and number of lines."
                    ]
                ],
                //High-Speed Needle Loom
                [
                    'machine' => 10,
                    'detail' => [
                        "For different applications such as elastic and non elastic tapes, straps, and more.",
                        "Available in different widths, hooks and number of lines."
                    ]
                ],
                //High-Speed Automatic Crochet Machine
                [
                    'machine' => 11,
                    'detail' => [
                        "Ideal for manufacturing both elastic and non-elastic tapes, used in a wide range of products, from garments and shoelaces to sporting goods and much more."

                    ]
                ],
                //Label & Folding machine
                [
                    'machine' => 12,
                    'detail' => [
                        "Multi-functional machines, capable of performing various types of cuts and folds.",
                        "High-speed and precision. "

                    ]
                ],
                //Ultrasonic
                [
                    'machine' => 13,
                    'detail' => [
                        "Ideal for manufacturing both elastic and non-elastic tapes.",
                        "Used in a wide range of products, from garments and shoelaces to sporting goods and much more"
                    ]
                ],

                //Single jersey
                [
                    'machine' => 14,
                    'detail' => [

                        "Application T-Shirt, sportswear, aerobic suit and swimming suit. ",
                        "Unique drive system that reduces wear.",
                        "Three thread fleece open width circular knitting machine"
                    ]
                ],
                //Interlock/Rib
                [
                    'machine' => 15,
                    'detail' => [

                        "Application: Rib, interlock and 8 locks  structured fabrics.",
                        "Top and bottom gears are immersed in lubricants to reduce noise, wear, improve accuracy, and enhance durability."
                    ]
                ],
                //Single computerized
                [
                    'machine' => 16,
                    'detail' => [

                        "Application: Fashion clothes and underwear. ",
                        "Characterized by simple interchanging between single and mesh jacquard.",
                        "No specific design software needed. "
                    ]
                ],
                //Double computerized
                [
                    'machine' => 17,
                    'detail' => [

                        "Applications: Apparel, sheets, pillows, towels, children´s fabrics and other home textiles. ",
                        "No specific design software needed. "
                    ]
                ],
                //Sock Machine

                [
                    'machine' => 18,
                    'detail' => [

                        "Application: Invisible socks, plain socks, terry and plain socks.",
                        "Needle range: 40 - 200",
                        "Cylinder diameter: 31/4, 33/4, 4, 41/2 inch. "
                    ]
                ],

                //Braiding
                [
                    'machine' => 19,
                    'detail' => [
                        "From 3 spindles to 640 spindles.",
                        "Vast range of applications such as textile, medical, and others.",
                        "We provide spare parts for the braiding machines."
                    ]
                ],
                //tiping machine
                [
                    'machine' => 20,
                    'detail' => [
                        "Capable of handling different rope lengths.",
                        "Automatic & semi automatic machines.",
                    ]
                ],

                //Winding machines
                [
                    'machine' => 21,
                    'detail' => [
                        "Different models available.",
                        "Easy installation and adjustment.",
                        "For bobbins of different sizes."
                    ]
                ],


                //Electronic Jacquard
                [
                    'machine' => 5,
                    'detail' => [
                        "Suitable for weaving flat fabrics and terry cloth.",    // inglés
                        "Applications: Tapestry, silk fabric, dress material, seat covers, airbags.",    // inglés
                        "Quick and easy to install.",    // inglés

                    ]
                ],

                //Stenter
                [
                    'machine' => 24,
                    'detail' => [
                        "Ideal for knitted and woven fabrics.",
                        "Mainly used for stentering, setting, finishing the cotton fabric, poly-cotton fabric, polyester fabric and elastic fabric",
                    ]
                ],

                //Dye Jigger
                [
                    'machine' => 25,
                    'detail' => [
                        "Max. working width: 1,400 - 3,600 mm",
                        "Works with nylon, silk spandex, cotton, polyester, and other yarns.",
                        "Constant control of tension."
                    ]
                ],

                //sizing-machine
                [
                    'machine' => 23,
                    'detail' => [
                        "It can work with various types of yarn such as cotton",
                        "Quality, uniformity and efficiency",
                    ]
                ],

                 //Needle machines
                [
                    'machine' => 22,
                    'detail' => [
                        "For different applications: ropes, cords, etc.",
                        "For different needle capacities",
                        "60W motor",
                        "Output 60-120 meters/hour"
                    ]
                ],




                //    [
                //     'machine' => ,
                //       'detail' => [

                //       ] 
                //    ],



            ];


            foreach ($details as $detail) {
                $machineId = $detail['machine'];
                foreach ($detail['detail'] as $machinedetail) {


                    DB::table('machine_details')->insert([
                        'name' =>  substr($machinedetail, 0, 200),
                        'machine_id' => $machineId,
                        'created_at' => now(),
                        'updated_at' => now(),
                    ]);
                }
            }
        }
    }
}
