<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class MachineCatalogueSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {

        // Check if we are sowing or reversing
        $rollback = env('SEED_ROLLBACK', false);

        if ($rollback) {
            // Temporarily disable foreign key restrictions
            DB::statement('SET FOREIGN_KEY_CHECKS = 0;');
            // Delete all languages
            DB::table('machine_catalogues')->truncate();
        } else {
            //? languageS -------------   [1] = Español, [2] 2 = Inglés, [3]  3 = Italiano, [4]  4 = Portugués, [5]   5 = Francés, [6]  6 = Chino ------------------------------

            $sectors = [

                //braiding
                'Braiding' =>  [
                    'url' => "catalogue/machinery/Braiding/Braiding/BR_Maquinas trenzadoras.pdf",
                    'machine_id' => "19",
                    'language_id' => "1",
                ],
                'BraidingEng' =>  [
                    'url' => "catalogue/machinery/Braiding/Braiding/BR_Maquinas trenzadoras - ENG.pdf",
                    'machine_id' => "19",
                    'language_id' => "2",
                ],
                'BraidingPort' =>  [
                    'url' => "catalogue/machinery/Braiding/Braiding/BR_Maquinas trenzadoras-POR.pdf",
                    'machine_id' => "19",
                    'language_id' => "4",
                ],

                //Needle
                'Needle' =>  [
                    'url' => "catalogue/machinery/Braiding/Needle/FT Neddle-ESP.pdf",
                    'machine_id' => "22",
                    'language_id' => "1",
                ],
                'NeedleEn' =>  [
                    'url' => "catalogue/machinery/Braiding/Needle/FT_Máquina Agujas- ENG.pdf",
                    'machine_id' => "22",
                    'language_id' => "2",
                ],
                'NeedlePort' =>  [
                    'url' => "catalogue/machinery/Braiding/Needle/FT_Máquina Agujas- POR.pdf",
                    'machine_id' => "22",
                    'language_id' => "4",
                ],


                'Tipping' =>  [
                    'url' => "catalogue/machinery/Braiding/Tipping Machine/Punteadora HH - ESP.pdf",
                    'machine_id' => "20",
                    'language_id' => "1",
                ],
                'TippingEng' =>  [
                    'url' => "catalogue/machinery/Braiding/Tipping Machine/Punteadora HH- ENG.pdf",
                    'machine_id' => "20",
                    'language_id' => "2",
                ],
                'TippingPort' =>  [
                    'url' => "catalogue/machinery/Braiding/Tipping Machine/FT_Punteadora-POR.pdf",
                    'machine_id' => "20",
                    'language_id' => "4",
                ],

                //high speed
                'label-weaving-en' =>  [
                    'url' => "catalogue/machinery/Label Weaving/High Speed Label Loom/BR_High-Speed-Label_ENG.pdf",
                    'machine_id' => "8",
                    'language_id' => "2",
                ],
                'label-weaving-machine' =>  [
                    'url' => "catalogue/machinery/Label Weaving/High Speed Label Loom/BR_High-Speed-Label_ESP.pdf",
                    'machine_id' => "8",
                    'language_id' => "1",
                ],
                'label-weaving-machinePort' =>  [
                    'url' => "catalogue/machinery/Label Weaving/High Speed Label Loom/BR_High-Speed-Label_POR.pdf",
                    'machine_id' => "8",
                    'language_id' => "4",
                ],

                //Crochet
                'high-speed-automatic-crochet-machine' =>  [
                    'url' => "catalogue/machinery/Label Weaving/Crochet/2024.FT_Crochet- ES.pdf",
                    'machine_id' => "11",
                    'language_id' => "1",
                ],
                'high-speed-automatic-crochet-machineEn' =>  [
                    'url' => "catalogue/machinery/Label Weaving/Crochet/2024.FT_Crochet- ENG.pdf",
                    'machine_id' => "11",
                    'language_id' => "2",
                ],
                'high-speed-automatic-crochet-machinePort' =>  [
                    'url' => "catalogue/machinery/Label Weaving/Crochet/2024.FT_Crochet- POR.pdf",
                    'machine_id' => "11",
                    'language_id' => "4",
                ],

                //label and folding
                'label-folding-machine' =>  [
                    'url' => "catalogue/machinery/Label Weaving/Label and Folding/Cat. Label Folding & Cutting Machine - ESP.pdf",
                    'machine_id' => "12",
                    'language_id' => "1",
                ],
                'label-folding-machineEn' =>  [
                    'url' => "catalogue/machinery/Label Weaving/Label and Folding/Cat. Label Folding & Cutting Machine - ENG.pdf",
                    'machine_id' => "12",
                    'language_id' => "2",
                ],
                'label-folding-machinePort' =>  [
                    'url' => "catalogue/machinery/Label Weaving/Label and Folding/Cat. Label Folding & Cutting Machine - POR.pdf",
                    'machine_id' => "12",
                    'language_id' => "4",
                ],

                //Narrow fabric
                'narrow-fabric-jacquard-loom' =>  [
                    'url' => "catalogue/machinery/Label Weaving/Narrow Jacquard/BR_Narrow_Jacq- ESP.pdf",
                    'machine_id' => "9",
                    'language_id' => "1",
                ],
                'narrow-fabric-jacquard-loomEng' =>  [
                    'url' => "catalogue/machinery/Label Weaving/Narrow Jacquard/BR_Narrow_Jacq- ENG.pdf",
                    'machine_id' => "9",
                    'language_id' => "2",
                ],
                'narrow-fabric-jacquard-loomPort' =>  [
                    'url' => "catalogue/machinery/Label Weaving/Narrow Jacquard/BR_Narrow_Jacq- POR.pdf",
                    'machine_id' => "9",
                    'language_id' => "4",
                ],


                //ultrasonic
                'ultrasonicEn' =>  [
                    'url' => "catalogue/machinery/Label Weaving/Ultrasonic/Cat. Label Folding & Cutting Machine - ENG.pdf",
                    'machine_id' => "13",
                    'language_id' => "2",
                ],
                'ultrasonic' =>  [
                    'url' => "catalogue/machinery/Label Weaving/Ultrasonic/Cat. Label Folding & Cutting Machine - ESP.pdf",
                    'machine_id' => "13",
                    'language_id' => "1",
                ],
                'ultrasonicPort' =>  [
                    'url' => "catalogue/machinery/Label Weaving/Label and Folding/Cat. Label Folding & Cutting Machine - POR.pdf",
                    'machine_id' => "13",
                    'language_id' => "4",
                ],

                //Air
                'air-looms' =>  [
                    'url' => "catalogue/machinery/Weaving/Air/FT_Rifa-Air_ESP.pdf",
                    'machine_id' => "4",
                    'language_id' => "1",
                ],
                'air-loomsEn' =>  [
                    'url' => "catalogue/machinery/Weaving/Air/FT_Rifa-Air_ENG.pdf",
                    'machine_id' => "4",
                    'language_id' => "2",
                ],
                'air-loomsPort' =>  [
                    'url' => "catalogue/machinery/Weaving/Air/FT_Rifa-Air_POR.pdf",
                    'machine_id' => "4",
                    'language_id' => "4",
                ],

                //JAcqueard
                'electronic-jacquard' =>  [
                    'url' => "catalogue/machinery/Weaving/Jacquard/CAT. Jacquard-GCS.ESP.pdf",
                    'machine_id' => "5",
                    'language_id' => "1",
                ],
                'electronic-jacquardEn' =>  [
                    'url' => "catalogue/machinery/Weaving/Jacquard/CAT. Jacquard-GCS.ENG.pdf",
                    'machine_id' => "5",
                    'language_id' => "2",
                ],
                'electronic-jacquardPort' =>  [
                    'url' => "catalogue/machinery/Weaving/Jacquard/BR- Jacquard-GCS.POR.pdf",
                    'machine_id' => "5",
                    'language_id' => "4",
                ],

                //rapier
                'rapier-looms' =>  [
                    'url' => "catalogue/machinery/Weaving/Rapier/FT_Rifa-Rapier_ESP.pdf",
                    'machine_id' => "2",
                    'language_id' => "1",
                ],
                'rapier-loomsEn' =>  [
                    'url' => "catalogue/machinery/Weaving/Rapier/FT_Rifa-Rapier_ENG.pdf",
                    'machine_id' => "2",
                    'language_id' => "2",
                ],
                'rapier-loomsPort' =>  [
                    'url' => "catalogue/machinery/Weaving/Rapier/FT_Rifa-Rapier-RFRL50-31_POR.pdf",
                    'machine_id' => "2",
                    'language_id' => "4",
                ],

                //Terry
                'terry-looms' =>  [
                    'url' => "catalogue/machinery/Weaving/Terry/FT_Rifa-Rizo_ESP.pdf",
                    'machine_id' => "3",
                    'language_id' => "1",
                ],
                'terry-loomsEn' =>  [
                    'url' => "catalogue/machinery/Weaving/Terry/FT_Rifa-Rizo_ENG.pdf",
                    'machine_id' => "3",
                    'language_id' => "2",
                ],
                'terry-loomsPort' =>  [
                    'url' => "catalogue/machinery/Weaving/Terry/FT_Rifa-Rizo_POR.pdf",
                    'machine_id' => "3",
                    'language_id' => "4",
                ],

                //water
                'water-looms' =>  [
                    'url' => "catalogue/machinery/Weaving/Water/FT_Rifa-Water_ESP.pdf",
                    'machine_id' => "1",
                    'language_id' => "1",
                ],
                'water-loomsEn' =>  [
                    'url' => "catalogue/machinery/Weaving/Water/FT_Rifa-Water_ENG.pdf",
                    'machine_id' => "1",
                    'language_id' => "2",
                ],
                'water-loomsPort' =>  [
                    'url' => "catalogue/machinery/Weaving/Water/FT_Rifa-Water_POR.pdf",
                    'machine_id' => "1",
                    'language_id' => "4",
                ],

                //Stenter
                'stenter-machine' =>  [
                    'url' => "catalogue/machinery/finishing/Stenter/CAT_Rama-ESP.pdf",
                    'machine_id' => "24",
                    'language_id' => "1",
                ],
                'stenter-machineEn' =>  [
                    'url' => "catalogue/machinery/finishing/Stenter/CAT_Rama-ENG.pdf",
                    'machine_id' => "24",
                    'language_id' => "2",
                ],
                'stenter-machinePort' =>  [
                    'url' => "catalogue/machinery/finishing/Stenter/CAT_Rama-POR.pdf",
                    'machine_id' => "24",
                    'language_id' => "4",
                ],

                //jigger
                'jigger' =>  [
                    'url' => "catalogue/machinery/finishing/jigger/Cat. Jigger - ESP.pdf",
                    'machine_id' => "25",
                    'language_id' => "1",
                ],
                'jiggerEn' =>  [
                    'url' => "catalogue/machinery/finishing/jigger/Cat. Jigger - ENG.pdf",
                    'machine_id' => "25",
                    'language_id' => "2",
                ],
                'jiggerPort' =>  [
                    'url' => "catalogue/machinery/finishing/jigger/Cat. Jigger - POR.pdf",
                    'machine_id' => "25",
                    'language_id' => "4",
                ],

                //winding
                'winding' =>  [
                    'url' => "catalogue/machinery/Braiding/Winding/2024.FT_Bobinadora- ES.pdf",
                    'machine_id' => "21",
                    'language_id' => "1",
                ],
                'windingEn' =>  [
                    'url' => "catalogue/machinery/Braiding/Winding/2024.FT_Bobinadora- ENG.pdf",
                    'machine_id' => "21",
                    'language_id' => "2",
                ],
                'windingPort' =>  [
                    'url' => "catalogue/machinery/Braiding/Winding/FT. Bobinadora -POR.pdf",
                    'machine_id' => "21",
                    'language_id' => "4",
                ],

                //Sizzing
                'sizing' =>  [
                    'url' => "catalogue/machinery/Sizing/Sizing/BR_Sizing-machine- ES.pdf",
                    'machine_id' => "23",
                    'language_id' => "1",
                ],
                'sizingEng' =>  [
                    'url' => "catalogue/machinery/Sizing/Sizing/BR_Sizing-machine- ENG.pdf",
                    'machine_id' => "23",
                    'language_id' => "2",
                ],
                'sizingPort' =>  [
                    'url' => "catalogue/machinery/Sizing/Sizing/BR_Sizing-machine- POR.pdf",
                    'machine_id' => "23",
                    'language_id' => "4",
                ],

                //Sock machine
                'sock-machine' =>  [
                    'url' => "catalogue/machinery/knitting/Sock Machine/CAT_Sock Machine-ESP.pdf",
                    'machine_id' => "18",
                    'language_id' => "1",
                ],
                'sock-machineEng' =>  [
                    'url' => "catalogue/machinery/knitting/Sock Machine/CAT_Sock Machine-ENG.pdf",
                    'machine_id' => "18",
                    'language_id' => "2",
                ],

                //knitting
                'single-jersey' =>  [
                    'url' => "catalogue/machinery/knitting/knitting/BR_Telar-Circular-ESP.pdf",
                    'machine_id' => "14",
                    'language_id' => "1",
                ],
                'single-jerseyEng' =>  [
                    'url' => "catalogue/machinery/knitting/knitting/BR_Telar-Circular-ENG.pdf",
                    'machine_id' => "14",
                    'language_id' => "2",
                ],
                'single-jerseyPort' =>  [
                    'url' => "catalogue/machinery/knitting/knitting/BR_Telar-Circular-POR.pdf",
                    'machine_id' => "14",
                    'language_id' => "4",
                ],

                'interlockrib' =>  [
                    'url' => "catalogue/machinery/knitting/knitting/BR_Telar-Circular-ESP.pdf",
                    'machine_id' => "15",
                    'language_id' => "1",
                ],
                'interlockribEng' =>  [
                    'url' => "catalogue/machinery/knitting/knitting/BR_Telar-Circular-ENG.pdf",
                    'machine_id' => "15",
                    'language_id' => "2",
                ],
                'interlockribPort' =>  [
                    'url' => "catalogue/machinery/knitting/knitting/BR_Telar-Circular-POR.pdf",
                    'machine_id' => "15",
                    'language_id' => "4",
                ],

                'single-computerized' =>  [
                    'url' => "catalogue/machinery/knitting/knitting/BR_Telar-Circular-ESP.pdf",
                    'machine_id' => "16",
                    'language_id' => "1",
                ],
                'single-computerizedEng' =>  [
                    'url' => "catalogue/machinery/knitting/knitting/BR_Telar-Circular-ENG.pdf",
                    'machine_id' => "16",
                    'language_id' => "2",
                ],
                'single-computerizedPort' =>  [
                    'url' => "catalogue/machinery/knitting/knitting/BR_Telar-Circular-POR.pdf",
                    'machine_id' => "16",
                    'language_id' => "4",
                ],

                'double-computerized' =>  [
                    'url' => "catalogue/machinery/knitting/knitting/BR_Telar-Circular-ESP.pdf",
                    'machine_id' => "17",
                    'language_id' => "1",
                ],
                'double-computerizedEng' =>  [
                    'url' => "catalogue/machinery/knitting/knitting/BR_Telar-Circular-ENG.pdf",
                    'machine_id' => "17",
                    'language_id' => "2",
                ],
                'double-computerizedEng' =>  [
                    'url' => "catalogue/machinery/knitting/knitting/BR_Telar-Circular-POR.pdf",
                    'machine_id' => "17",
                    'language_id' => "4",
                ],


                // '' =>  [
                //     'url' => "",
                //     'machine_id' => "",
                //     'language_id' => "",
                // ],
            ];


            foreach ($sectors as $sector) {
                DB::table('machine_catalogues')->insert([
                    // 'id' =>  $key,
                    'url' =>  $sector["url"],
                    'machine_id' =>  $sector["machine_id"],
                    'language_id' => $sector["language_id"],
                    'created_at' => now(),
                    'updated_at' => now(),
                ]);
            }
        }
    }
}
