<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;

class LogoSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {

        // Check if we are sowing or reversing
        $rollback = env('SEED_ROLLBACK', false);

        if ($rollback) {
            // Temporarily disable foreign key restrictions
            DB::statement('SET FOREIGN_KEY_CHECKS = 0;');
            // Truncaste all divisions
            DB::table('logos')->truncate();
        } else {
            //inserting logo

            #main
            DB::table('logos')->insert([
                'url_logo'             => "/images/main/logo/logo-main.png",
                'url_logo_small'       =>  "/images/main/logo/logo-main-small.png",
                'url_logo_short'       =>  "/images/main/logo-short/logo-main.png",
                'url_logo_short_small' =>  "/images/main/logo-short/logo-main-small.png",
                'url_logo_white'        =>  "/images/main/logo/logo-main-white.png",
                'division_id' =>  1,
                'created_at' => now(),
                'updated_at' => now(),
            ]);


            #Mexico
            DB::table('logos')->insert([
                'url_logo'             => "/images/mexico/logo/logo-mexico.png",
                'url_logo_small'       =>  "/images/mexico/logo/logo-mexico-small.png",
                'url_logo_short'       =>  "/images/mexico/logo-short/logo-mexico.png",
                'url_logo_short_small' =>  "/images/mexico/logo-short/logo-mexico-small.png",
                'url_logo_white'       =>  "/images/mexico/logo/logo-mexico-white.png",
                'division_id' =>  2,
                'created_at' => now(),
                'updated_at' => now(),
            ]);

            #Argentina
            DB::table('logos')->insert([
                'url_logo'             => "/images/argentina/logo/logo-argentina.png",
                'url_logo_small'       =>  "/images/argentina/logo/logo-argentina-small.png",
                'url_logo_short'       =>  "/images/argentina/logo-short/logo-argentina.png",
                'url_logo_short_small' =>  "/images/argentina/logo-short/logo-argentina-small.png",
                'url_logo_white'       =>  "/images/argentina/logo/logo-argentina-white.png",
                'division_id' =>  3,
                'created_at' => now(),
                'updated_at' => now(),
            ]);

            #Brasil
            DB::table('logos')->insert([
                'url_logo'             => "/images/brazil/logo/logo-brazil.png",
                'url_logo_small'       =>  "/images/brazil/logo/logo-brazil-small.png",
                'url_logo_short'       =>  "/images/brazil/logo-short/logo-brazil.png",
                'url_logo_short_small' =>  "/images/brazil/logo-short/logo-brazil-small.png",
                'url_logo_white'       =>  "/images/brazil/logo/logo-brazil-white.png",
                'division_id' =>  4,
                'created_at' => now(),
                'updated_at' => now(),
            ]);

            #Colombia
            DB::table('logos')->insert([
                'url_logo'             => "/images/colombia/logo/logo-colombia.png",
                'url_logo_small'       =>  "/images/colombia/logo/logo-colombia-small.png",
                'url_logo_short'       =>  "/images/colombia/logo-short/logo-colombia.png",
                'url_logo_short_small' =>  "/images/colombia/logo-short/logo-colombia-small.png",
                'url_logo_white'       =>  "/images/colombia/logo/logo-colombia-white.png",
                'division_id' =>  5,
                'created_at' => now(),
                'updated_at' => now(),
            ]);

            #Peru
            DB::table('logos')->insert([
                'url_logo'             => "/images/peru/logo/logo-peru.png",
                'url_logo_small'       =>  "/images/peru/logo/logo-peru-small.png",
                'url_logo_short'       =>  "/images/peru/logo-short/logo-peru.png",
                'url_logo_short_small' =>  "/images/peru/logo-short/logo-peru-small.png",
                'url_logo_white'       =>  "/images/peru/logo/logo-peru-white.png",
                'division_id' =>  6,
                'created_at' => now(),
                'updated_at' => now(),
            ]);

            #Italia
            DB::table('logos')->insert([
                'url_logo'             => "/images/italia/logo/logo-italia.png",
                'url_logo_small'       =>  "/images/italia/logo/logo-italia-small.png",
                'url_logo_short'       =>  "/images/italia/logo-short/logo-italia.png",
                'url_logo_short_small' =>  "/images/italia/logo-short/logo-italia-small.png",
                'url_logo_white'       =>  "/images/italia/logo/logo-italia-white.png",
                'division_id' =>  7,
                'created_at' => now(),
                'updated_at' => now(),
            ]);

            #China
            DB::table('logos')->insert([
                'url_logo'             => "/images/china/logo/logo-china.png",
                'url_logo_small'       =>  "/images/china/logo/logo-china-small.png",
                'url_logo_short'       =>  "/images/china/logo-short/logo-china.png",
                'url_logo_short_small' =>  "/images/china/logo-short/logo-china-small.png",
                'url_logo_white'       =>  "/images/china/logo/logo-china-white.png",
                'division_id' =>  8,
                'created_at' => now(),
                'updated_at' => now(),
            ]);
        }
    }
}
