<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;

class DivisionSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Check if we are sowing or reversing
        $rollback = env('SEED_ROLLBACK', false);

        if ($rollback) {
            // Temporarily disable foreign key restrictions
            DB::statement('SET FOREIGN_KEY_CHECKS = 0;');
            // Truncate all divisions
            DB::table('divisions')->truncate();
        } else {
            //inserting divisions

            DB::table('divisions')->insert([
                'id' =>  1,
                'name' =>  "main",
                'default_language' => 2,
                'created_at' => now(),
                'updated_at' => now(),
            ]);

            DB::table('divisions')->insert([
                'id' =>  2,
                'name' =>  "mexico",
                'default_language' => 1,
                'created_at' => now(),
                'updated_at' => now(),
            ]);

            DB::table('divisions')->insert([
                'id' =>  3,
                'name' =>  "argentina",
                'default_language' => 1,
                'created_at' => now(),
                'updated_at' => now(),
            ]);

            DB::table('divisions')->insert([
                'id' =>  4,
                'name' =>  "brasil",
                'default_language' => 4,
                'created_at' => now(),
                'updated_at' => now(),
            ]);

            DB::table('divisions')->insert([
                'id' =>  5,
                'name' =>  "colombia",
                'default_language' => 1,
                'created_at' => now(),
                'updated_at' => now(),
            ]);

            DB::table('divisions')->insert([
                'id' =>  6,
                'name' =>  "peru",
                'default_language' => 1,
                'created_at' => now(),
                'updated_at' => now(),
            ]);

            DB::table('divisions')->insert([
                'id' =>  7,
                'name' =>  "italia",
                'default_language' => 3,
                'created_at' => now(),
                'updated_at' => now(),
            ]);

            DB::table('divisions')->insert([
                'id' =>  8,
                'name' =>  "china",
                'default_language' => 6,
                'created_at' => now(),
                'updated_at' => now(),
            ]);
        }
    }
}
