<?php

namespace Database\Seeders;

// use Faker\Factory as Faker;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class BlogImageSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Check if we are sowing or reversing
        $rollback = env('SEED_ROLLBACK', false);

        if ($rollback) {
            // Temporarily disable foreign key restrictions
            DB::statement('SET FOREIGN_KEY_CHECKS = 0;');
            // Truncate all blogs
            DB::table('blog_images')->truncate();
        } else {


            $images = [
                // '1' => [
                //     'image_large' => [
                //         "Articulo Existente_Kern.ESP.jpg",
                //         "Articulo Existente_Kern. ENG.jpg",
                //         "Articulo Existente_Kern. ENG.jpg",
                //         "Articulo Existente_Kern. ENG.jpg",
                //         "Articulo Existente_Kern. ENG.jpg",
                //         "Articulo Existente_Kern. ENG.jpg",
                //     ],
                //     'image' => [
                //         'Articulo Existente_Kern.5.jpg',
                //         'Articulo Existente_Kern.5.jpg',
                //         'Articulo Existente_Kern.5.jpg',
                //         'Articulo Existente_Kern.5.jpg',
                //         'Articulo Existente_Kern.5.jpg',
                //         'Articulo Existente_Kern.5.jpg',
                //     ],
                // ],
                // '2' => [
                //     'image_large' => [
                //         "Articulo Existente_Henghui. ESP.jpg",
                //         "Articulo Existente_Henghui. ENG.jpg",
                //         "Articulo Existente_Henghui. ENG.jpg",
                //         "Articulo Existente_Henghui. ENG.jpg",
                //         "Articulo Existente_Henghui. ENG.jpg",
                //         "Articulo Existente_Henghui. ENG.jpg",
                //     ],
                //     'image' => [
                //         "Articulo Existente_Henghui.10.jpg",
                //         "Articulo Existente_Henghui.10.jpg",
                //         "Articulo Existente_Henghui.10.jpg",
                //         "Articulo Existente_Henghui.10.jpg",
                //         "Articulo Existente_Henghui.10.jpg",
                //         "Articulo Existente_Henghui.10.jpg",
                //     ],
                // ],
                // '3' => [
                //     'image_large' => [
                //         "Data_ESP.jpg",
                //         "Data_ENG.jpg",
                //         "Data_ENG.jpg",
                //         "Data_ENG.jpg",
                //         "Data_ENG.jpg",
                //         "Data_ENG.jpg",
                //     ],
                //     'image' => [
                //         "Miniatura_Data.jpg",
                //         "Miniatura_Data.jpg",
                //         "Miniatura_Data.jpg",
                //         "Miniatura_Data.jpg",
                //         "Miniatura_Data.jpg",
                //         "Miniatura_Data.jpg",
                //     ],
                // ],
                // '4' => [
                //     'image_large' => [
                //         "Sustainable_ESP.jpg",
                //         "Sustainable_ENG.jpg",
                //         "Sustainable_ENG.jpg",
                //         "Sustainable_ENG.jpg",
                //         "Sustainable_ENG.jpg",
                //         "Sustainable_ENG.jpg",
                //     ],
                //     'image' => [
                //         "Miniatura_Sustainable.jpg",
                //         "Miniatura_Sustainable.jpg",
                //         "Miniatura_Sustainable.jpg",
                //         "Miniatura_Sustainable.jpg",
                //         "Miniatura_Sustainable.jpg",
                //         "Miniatura_Sustainable.jpg",
                //     ],
                // ],
                // '5' => [
                //     'image_large' => [
                //         "TDPP_ES.jpg",
                //         "TDPP_EN.jpg",
                //         "TDPP_EN.jpg",
                //         "TDPP_EN.jpg",
                //         "TDPP_EN.jpg",
                //         "TDPP_EN.jpg",
                //     ],
                //     'image' => [
                //         "Miniatura_TDPP.jpg",
                //         "Miniatura_TDPP.jpg",
                //         "Miniatura_TDPP.jpg",
                //         "Miniatura_TDPP.jpg",
                //         "Miniatura_TDPP.jpg",
                //         "Miniatura_TDPP.jpg",
                //     ],
                // ],
                // '6' => [
                //     'image_large' => [
                //         "UT2025_ESP.jpg",
                //         "UT2025_ENG.jpg",
                //         "UT2025_ENG.jpg",
                //         "UT2025_ENG.jpg",
                //         "UT2025_ENG.jpg",
                //         "UT2025_ENG.jpg",
                //     ],
                //     'image' => [
                //         "Miniatura_UT2025.jpg",
                //         "Miniatura_UT2025.jpg",
                //         "Miniatura_UT2025.jpg",
                //         "Miniatura_UT2025.jpg",
                //         "Miniatura_UT2025.jpg",
                //         "Miniatura_UT2025.jpg",
                //     ],
                // ],

                // '7' => [
                //     'image_large' => [
                //         "chile/Encabezados/Header_ESP.jpg",
                //         "chile/Encabezados/Header_EN.jpg",
                //         "chile/Encabezados/Header_EN.jpg",
                //         "chile/Encabezados/Header_EN.jpg",
                //         "chile/Encabezados/Header_EN.jpg",
                //         "chile/Encabezados/Header_EN.jpg",
                //     ],
                //     'image' => [
                //         "chile/Miniatura/Miniatura_Chile.jpg",
                //         "chile/Miniatura/Miniatura_Chile.jpg",
                //         "chile/Miniatura/Miniatura_Chile.jpg",
                //         "chile/Miniatura/Miniatura_Chile.jpg",
                //         "chile/Miniatura/Miniatura_Chile.jpg",
                //         "chile/Miniatura/Miniatura_Chile.jpg",
                //     ],
                // ],
                // '8' => [
                //     'image_large' => [
                //         "Adidas/Encabezados/Adidas_ESP.jpg",
                //         "Adidas/Encabezados/Adidas_ENG.jpg",
                //         "Adidas/Encabezados/Adidas_ENG.jpg",
                //         "Adidas/Encabezados/Adidas_ENG.jpg",
                //         "Adidas/Encabezados/Adidas_ENG.jpg",
                //         "Adidas/Encabezados/Adidas_ENG.jpg",
                //     ],
                //     'image' => [
                //         "Adidas/Miniatura/Adidas_Miniatura.jpg",
                //         "Adidas/Miniatura/Adidas_Miniatura.jpg",
                //         "Adidas/Miniatura/Adidas_Miniatura.jpg",
                //         "Adidas/Miniatura/Adidas_Miniatura.jpg",
                //         "Adidas/Miniatura/Adidas_Miniatura.jpg",
                //         "Adidas/Miniatura/Adidas_Miniatura.jpg",
                //     ],
                // ],
                // '9' => [
                //     'image_large' => [
                //         "Ia/Encabezado/Header_ES.jpg",
                //         "Ia/Encabezado/Header_EN.jpg",
                //         "Ia/Encabezado/Header_EN.jpg",
                //         "Ia/Encabezado/Header_EN.jpg",
                //         "Ia/Encabezado/Header_EN.jpg",
                //         "Ia/Encabezado/Header_EN.jpg",
                //     ],
                //     'image' => [
                //         "Ia/Miniatura/Miniatura_IA.jpg",
                //         "Ia/Miniatura/Miniatura_IA.jpg",
                //         "Ia/Miniatura/Miniatura_IA.jpg",
                //         "Ia/Miniatura/Miniatura_IA.jpg",
                //         "Ia/Miniatura/Miniatura_IA.jpg",
                //         "Ia/Miniatura/Miniatura_IA.jpg",
                //     ],
                // ],
                // '10' => [
                //     'image_large' => [
                //         'Consumidor/Encabezados/Consumidor_ESP.jpg',
                //         'Consumidor/Encabezados/Consumidor_ENG.jpg',
                //         'Consumidor/Encabezados/Consumidor_ENG.jpg',
                //         'Consumidor/Encabezados/Consumidor_ENG.jpg',
                //         'Consumidor/Encabezados/Consumidor_ENG.jpg',
                //         'Consumidor/Encabezados/Consumidor_ENG.jpg',
                //     ],
                //     'image' => [
                //         'Consumidor/Miniatura/Consumidor_Miniatura.jpg',
                //         'Consumidor/Miniatura/Consumidor_Miniatura.jpg',
                //         'Consumidor/Miniatura/Consumidor_Miniatura.jpg',
                //         'Consumidor/Miniatura/Consumidor_Miniatura.jpg',
                //         'Consumidor/Miniatura/Consumidor_Miniatura.jpg',
                //         'Consumidor/Miniatura/Consumidor_Miniatura.jpg',
                //     ],
                // ],
                // '11' => [
                //     'image_large' => [
                //         'blog 4.0 industria/Encabezados/241203_Articulo-ES.jpg',
                //         'blog 4.0 industria/Encabezados/241203_Articulo-ENG.jpg',
                //         'blog 4.0 industria/Encabezados/241203_Articulo-ENG.jpg',
                //         'blog 4.0 industria/Encabezados/241203_Articulo-ENG.jpg',
                //         'blog 4.0 industria/Encabezados/241203_Articulo-ENG.jpg',
                //         'blog 4.0 industria/Encabezados/241203_Articulo-ENG.jpg',
                //     ],
                //     'image' => [
                //         'blog 4.0 industria/Miniatura/Industria_Miniatura.jpg',
                //         'blog 4.0 industria/Miniatura/Industria_Miniatura.jpg',
                //         'blog 4.0 industria/Miniatura/Industria_Miniatura.jpg',
                //         'blog 4.0 industria/Miniatura/Industria_Miniatura.jpg',
                //         'blog 4.0 industria/Miniatura/Industria_Miniatura.jpg',
                //         'blog 4.0 industria/Miniatura/Industria_Miniatura.jpg',
                //     ],
                // ]


                // '12' => [
                //     'image_large' => [
                //         'crafting/Encabezados/Customization_ESP.jpg',
                //         'crafting/Encabezados/Customization_ENG.jpg',
                //         'crafting/Encabezados/Customization_ENG.jpg',
                //         'crafting/Encabezados/Customization_ENG.jpg',
                //         'crafting/Encabezados/Customization_ENG.jpg',
                //         'crafting/Encabezados/Customization_ENG.jpg',
                //     ],
                //     'image' => [
                //         'crafting/Miniatura/Customization_Miniatura.jpg',
                //         'crafting/Miniatura/Customization_Miniatura.jpg',
                //         'crafting/Miniatura/Customization_Miniatura.jpg',
                //         'crafting/Miniatura/Customization_Miniatura.jpg',
                //         'crafting/Miniatura/Customization_Miniatura.jpg',
                //         'crafting/Miniatura/Customization_Miniatura.jpg',
                //     ],
                // ],

                // '13' => [
                //     'image_large' => [
                //         'Athleisure/Encabezados/Athleisure_Header_ESP.jpg',
                //         'Athleisure/Encabezados/Athleisure_Header_ENG.jpg',
                //         'Athleisure/Encabezados/Athleisure_Header_ENG.jpg',
                //         'Athleisure/Encabezados/Athleisure_Header_ENG.jpg',
                //         'Athleisure/Encabezados/Athleisure_Header_ENG.jpg',
                //         'Athleisure/Encabezados/Athleisure_Header_ENG.jpg',
                //     ],
                //     'image' => [
                //         'Athleisure/Miniatura/Athleisure_Miniatura.jpg',
                //         'Athleisure/Miniatura/Athleisure_Miniatura.jpg',
                //         'Athleisure/Miniatura/Athleisure_Miniatura.jpg',
                //         'Athleisure/Miniatura/Athleisure_Miniatura.jpg',
                //         'Athleisure/Miniatura/Athleisure_Miniatura.jpg',
                //         'Athleisure/Miniatura/Athleisure_Miniatura.jpg',
                //     ],
                // ]

                '14' => [
                    'image_large' => [
                        'Sustainable/Encabezado/SF_Header-ESP.jpg',
                        'Sustainable/Encabezado/SF_Header-ENG.jpg',
                        'Sustainable/Encabezado/SF_Header-ENG.jpg',
                        'Sustainable/Encabezado/SF_Header-ENG.jpg',
                        'Sustainable/Encabezado/SF_Header-ENG.jpg',
                        'Sustainable/Encabezado/SF_Header-ENG.jpg',
                    ],
                    'image' => [
                        'Sustainable/Miniatura/SF_Miniatura.jpg',
                        'Sustainable/Miniatura/SF_Miniatura.jpg',
                        'Sustainable/Miniatura/SF_Miniatura.jpg',
                        'Sustainable/Miniatura/SF_Miniatura.jpg',
                        'Sustainable/Miniatura/SF_Miniatura.jpg',
                        'Sustainable/Miniatura/SF_Miniatura.jpg',
                    ],
                ]


                //  '' => [
                //      'image_large' => [
                //      ],
                //       'image' => [
                //       ] ,
                //  ] 
            ];

            foreach ($images as $key => $image) {
                foreach ($image['image'] as $index => $imag) {
                    $image_large = $image['image_large'][$index];

                    DB::table('blog_images')->insert([
                        // 'id' => $index,
                        'image' => $imag,
                        'image_large' => $image_large,
                        'blog_id'     => $key,
                        'language_id' =>  $index + 1,
                        'created_at' => now(),
                        'updated_at' => now(),
                    ]);
                }
            }
        }
    }
}
