<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Faker\Factory as Faker;

class BlogCategoryTranslationSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {

        // Check if we are sowing or reversing
        $rollback = env('SEED_ROLLBACK', false);

        if ($rollback) {
            // Temporarily disable foreign key restrictions
            DB::statement('SET FOREIGN_KEY_CHECKS = 0;');
            // Truncate all blog_category_translations
            DB::table('blog_category_translations')->truncate();
        } else {

            //? languageS -------------   [1] = Español, [2] 2 = Inglés, [3]  3 = Italiano, [4]  4 = Portugués, [5]   5 = Francés, [6]  6 = Chino ------------------------------

            $translations = [
                '1' => ["Industria textil", "Textile industry", " Industria tessile", " Indústria têxtil", " Industrie textile", "纺织业"],
                '2' => ["Innovación", "Innovation", "Innovazione", "Inovação", "Innovation", "创新"],
            ];



            foreach ($translations as $key => $specialty) {
                foreach ($specialty as $position => $translation) {
                    DB::table('blog_category_translations')->insert([
                        // 'id' => $index,
                        'name' => $translation,
                        'blog_category_id' => $key,
                        'language_id' =>  $position+1,
                        'created_at' => now(),
                        'updated_at' => now(),
                    ]);
                }
            }
        }
    }
}
