<?php

namespace Database\Seeders;

use Faker\Factory as Faker;
use Illuminate\Support\Str;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class BlogCategorySeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {

        // Check if we are sowing or reversing
        $rollback = env('SEED_ROLLBACK', false);

        if ($rollback) {
            // Temporarily disable foreign key restrictions
            DB::statement('SET FOREIGN_KEY_CHECKS = 0;');
            // Truncate all blog_categories
            DB::table('blog_categories')->truncate();
        } else {

                    DB::table('blog_categories')->insert([
                        'id' => 1,
                        'name' => Str::slug("Textile industry"),
                        'created_at' => now(),
                        'updated_at' => now(),
                    ]);

                    DB::table('blog_categories')->insert([
                        'id' => 2,
                        'name' => Str::slug("Innovation"),
                        'created_at' => now(),
                        'updated_at' => now(),
                    ]);
            
        }
    }
}
