<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('blog_images', function (Blueprint $table) {
            //
            $table->foreignId('language_id')->default(2)->constrained()->onDelete('cascade')->comment('Foreing Id table languages');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('blog_images', function (Blueprint $table) {
            $table->dropForeign(['language_id']); // Elimina la restricción de clave foránea
            $table->dropColumn('language_id'); // Elimina la columna 'language_id'
        });
    }
};
