<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::table('machines', function (Blueprint $table) {
            $table->string('main_image')->comment('Main image')->change();
            $table->integer('status')->default(0)->comment('status of machine: 0 = active, 1 = inactive')->change();
            $table->dropColumn('data_sheet');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('machines', function (Blueprint $table) {
            $table->integer('main_image')->comment('Main image')->change();
            $table->integer('status')->default(1)->comment('status of machine: 1 = active, 0 = inactive')->change();
            $table->string('data_sheet')->comment('data sheet of machine');
        });
    }
};


