<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('contact_requests', function (Blueprint $table) {
            //add : company, file
            $table->string('company')->comment('Company');
            $table->string('file')->comment('File')->nullable();
            //drop : phone, 
            $table->dropColumn('phone');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('contact_requests', function (Blueprint $table) {
            $table->dropColumn('company');
            $table->dropColumn('file');
            $table->string('phone', 15)->comment('Telephone contact');
        });
    }
};
