<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('machine_features', function (Blueprint $table) {
            $table->id();
            $table->string('name', 50)->comment('machine feature name');
            $table->foreignId('machine_id')->constrained()->onDelete('cascade')->comment('Foreig Id table machines');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('machine_features');
    }
};
