<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('blog_tag_rels', function (Blueprint $table) {
            $table->id();
            $table->foreignId('blog_tag_id')->constrained()->onDelete('cascade')->comment('Foreing Id table blog_tag');
            $table->foreignId('blog_id')->constrained()->onDelete('cascade')->comment('Foreing Id table blog');
            
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('blog_tag_rels');
    }
};
