<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('blogs', function (Blueprint $table) {
            $table->id();
            $table->integer('views')->default(0)->comment('view count');
            $table->string('video', 100)->comment('video url');
            $table->integer('main_image')->comment('Main image of blog');
            $table->foreignId('blog_category_id')->constrained()->onDelete('cascade')->comment('Foreing Id table category_blogs');
            $table->foreignId('division_id')->constrained()->onDelete('cascade')->comment('Foreing Id table divisions');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('blogs');
    }
};
