<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('contact_products', function (Blueprint $table) {
            $table->id();
            $table->string('email', 100)->comment('Contact E-Mail');;
            $table->string('name', 100)->comment('Full name');
            $table->string('country', 100)->comment('Contry');
            $table->text('message')->comment('Message to send');
            $table->foreignId('division_id')->constrained()->onDelete('cascade')->comment('Foreing Id table divisions');
            $table->timestamps();
            //! ask if you want it to save the sector where it is located
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('contact_products');
    }
};
