<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('specialty_translations', function (Blueprint $table) {
            $table->id()->comment('Id');
            $table->string('name_translation', 50)->comment('Traslation specialty name');
            $table->foreignId('language_id')->constrained()->onDelete('cascade')->comment('Foreing Id table languages');
            $table->foreignId('specialty_id')->constrained()->onDelete('cascade')->comment('Foreing Id table specialties');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('specialty_translations');
    }
};
