<?php

namespace App\View\Components;

use Illuminate\View\Component;

class Modal extends Component
{
    public $modalId;
    public $title;
    public $size;
    public $footer;

    /**
     * Constructor del componente.
     *
     * @param string $modalId - El ID del modal
     * @param string $title - El título del modal
     * @param string|null $size - El tamaño del modal ('modal-sm', 'modal-lg', etc.)
     * @param string|null $footer - El contenido del pie del modal (botones u otros elementos)
     */
    public function __construct($modalId, $title, $size = 'w-md', $footer = null)
    {
        $this->modalId = $modalId;
        $this->title = $title;
        $this->size = $size;
        $this->footer = $footer;
    }

    /**
     * Renderiza la vista del componente.
     *
     * @return \Illuminate\View\View
     */
    public function render()
    {
        return view('components.modal');
    }
}
