<?php

namespace App\Utils;

class GeneralUtil
{

    public $sliderHome;
    public $partnersHome;
    public $productsHome;
    public $popularProductsHome;
    public $machineryHome;
    public $divisionsHome;
    public $blogsHome;
    public $ourValuesAbout;
    public $ourClientsAbout;
    public $ourPeople;
    public $partners;
    public $timeLine;
    public $contactDivisions;
    public $continents;
    public $partnersBrazil;
    public $partnersMexico;
    public $partnersColombia;
    public $partnersArgentina;
    public $productsHomeItalia;
    public $customerReviews;

    public function __construct()
    {
        // Inicializar las propiedades con los datos
        $this->sliderHome           = $this->getSliderHome();
        $this->partnersHome         = $this->getPartnersHome();
        $this->productsHome         = $this->getProductsHome();
        $this->popularProductsHome  = $this->getPopularProductsHome();
        $this->machineryHome        = $this->getMachineryHome();
        $this->divisionsHome        = $this->getDivisionsHome();
        $this->blogsHome            = $this->getBlogsHome();
        $this->ourValuesAbout       = $this->getOurValuesAbout();
        $this->ourClientsAbout      = $this->getOurClientsAbout();
        $this->ourPeople            = $this->getOurPeople();
        $this->partners             = $this->getPartners();
        $this->timeLine             = $this->getTimeLine();
        $this->contactDivisions     = $this->getContactDivisions();
        $this->continents           = $this->getContinents();
        $this->partnersArgentina    = $this->getPartnersArgentina();
        $this->partnersColombia     = $this->getPartnersColombia();
        $this->partnersBrazil       = $this->getPartnersBrazil();
        $this->partnersMexico       = $this->getPartnersMexico();
        $this->productsHomeItalia   = $this->getProductsHomeItalia();
        // $this->customerReviews      = $this->getReviews();
    }

    public static function convertArrayToObject(array $array)
    {
        return json_decode(json_encode($array));
    }
    //slider home (Slider)
    public static function getSliderHome()
    {
        $data = [
            //weaving success
            'slider1' => [
                'img' => "/images/resource/home-slider/Slide_1.jpg",
                'title1' => "messages.bn-home-title1",
                'title2' => "messages.together",
                'text1' => "messages.bn-home-subtitle2"
            ],
            //itg LIne
            'slider2' => [
                'img' => "/images/resource/home-slider/Slide_2.jpg",
                'title1' => "messages.homet-itg",
                'title2' => "messages.homet-line",
                'text1' => "messages.sl2-bn-home-subtitle2"
            ],
            //china
            // 'slider3' => [
            //     'img' => "/images/resource/home-slider/Slide_3.jpg",
            //     'title1' => "messages.sl3-bn-home-title1",
            //     'title2' => "messages.sl3-bn-home-subtitle1",
            //     'text1' => "messages.sl3-bn-home-subtitle2"
            // ],
            //itg Group
            'slider4' => [
                'img' => "/images/resource/home-slider/Slide_4.jpg",
                'title1' => "messages.sl4-bn-home-title1",
                'title2' => "messages.sl4-bn-home-subtitle1",
                'text1' => "messages.sl4-bn-home-subtitle2"
            ],
        ];

        return self::convertArrayToObject($data);
    }
    // carousel home  (OUR PARTNERS)
    public static function getPartnersHome()
    {
        $data = [
            'titan' => [
                'id' => "titan",
                'icon' => "images/resource/partners/Titan-Icono.png",
                'img'  => "/images/resource/home-partners/titan.jpg",
                'url'  => "#",
                'class' => "mw-50",
                'name' => "Titan",
            ],
            'iro' => [
                'id' => "iro",
                'icon' => "images/resource/partners/Iro-Icono.png",
                'img'   => "/images/resource/home-partners/iro-roj.png",
                'url'  => "#",
                'class' => "mw-50",
                'name' => "IRO/ROJ",
            ],
            'molyguard' => [
                'id' => "moly",
                'icon' => "images/resource/partners/Moly-Icono.png",
                'img' => "/images/resource/home-partners/molyguard.png",
                'class' => "mw-35",
                'url'  => "#",
                'name'  => "Molyguard",
            ],
            'dky' => [
                'id' => "dky",
                'icon' => "images/resource/partners/DKY-Icono.png",
                'img' => "/images/resource/home-partners/DKY.jpeg",
                'url'  => "#",
                'class' => "mw-35",
                'name'  => "DKY",
            ],
            'henghui' => [
                'id' => "henghui",
                'icon' => "images/resource/partners/Henghui-Icono.png",
                'img' => "/images/resource/home-partners/Henghui.jpg",
                'url'  => "#",
                'class' => "mw-35",
                'name'  => "Henghui",
            ],
            'bonas' => [
                'id' => "bonas",
                'icon' => "images/resource/partners/Bonas-Icono.png",
                'img' => "/images/resource/home-partners/bonas.jpeg",
                'url'  => "#",
                'class' => "mw-35",
                'name'  => "Bonas",
            ],
            'comsat' => [
                'id' =>  "comsat",
                'icon' => "images/resource/partners/Comsat-Icono.png",
                'img' => "/images/resource/home-partners/comsat.jpg",
                'url'  => "#",
                'class' => "mw-35",
                'name'  => "Comsat",
            ],
            'rifa-telar' => [
                'id' => "rifa",
                'icon' => "images/resource/partners/RIFA-Icono.png",
                'img' => "/images/resource/home-partners/RIFA-TELAR.jpg",
                'url'  => "#",
                'class' => "mw-35",
                'name'  => "RIFA",
            ],
        ];
        return self::convertArrayToObject($data);
    }
    // producsts home (OUR PRODUCTS)
    public static function getProductsHome()
    {

        // $selectedSector = ProductSector::find($sector->id ?? 1);


        $data = [
            'weaving' => [
                'active' => true,
                'id' => "prod-weaving",
                'img'  => "/images/resource/home-products/weaving.png",
                'url'  => route('products.sector', 'weaving'),
            ],
            'knitting' => [
                'active' => false,
                'id' => "prod-knitting",
                'img'  => "/images/resource/home-products/Knitting.jpg",
                'url'  => route('products.sector', 'knitting'),
            ],
            'braiding' => [
                'active' => false,
                'id' => "prod-braiding",
                'img'  => "/images/resource/home-products/Braiding.jpg",
                'url'  => route('products.sector', 'braiding'),
            ],
            'yarn' => [
                'active' => false,
                'id' => "prod-yarn",
                'img'  => "/images/resource/home-products/Yarn.jpg",
                'url'  => route('products.sector', 'yarn'),
            ],
            'machinery' => [
                'active' => false,
                'id' => "prod-machinery",
                'img'  => "/images/resource/home-products/Machinery.jpg",
                'url'  => route('machinery.new-machinery'),
            ],
        ];
        return self::convertArrayToObject($data);
    }

    // producsts home (OUR PRODUCTS)
    public static function getProductsHomeItalia()
    {

        $data = [
            'weaving' => [
                'active' => true,
                'id' => "prod-weaving",
                'img'  => "/images/resource/home-products/weaving.png",
                'url'  => route('products.sector', 'weaving'),
            ],
            'flat-fabric' => [
                'active' => false,
                'id' => "prod-flat-fabric",
                'img'  => "images/italia/home/Productos - Tejido plano.png",
                'url'  => route('products.sector', 'braiding'),
            ],
        ];
        return self::convertArrayToObject($data);
    }




    // Popular Products
    public static function getPopularProductsHome()
    {
        $data = [
            'grippers' => [
                'img'  => "/images/resource/popular-products/Grippers.jpg",
                'url'  => route('products.index'),
            ],
            'heald' => [
                'img'  => "/images/resource/popular-products/Heald.jpg",
                'url'  => route('products.index'),
            ],
            'tapes' => [
                'img'  => "/images/resource/popular-products/Tapes.jpg",
                'url'  => route('products.index'),
            ],
        ];
        return self::convertArrayToObject($data);
    }

    //textile machinery 
    public static function getMachineryHome()
    {
        $data = [
            'warping' => [
                'img'  => "/images/resource/home-machinery/Sectional.jpg",
                'url'  => route('machinery.index',),
            ],
            'stenters' => [
                'img'  => "/images/resource/home-machinery/Stenters.jpg",
                'url'  => route('machinery.index',),
            ],
            'braiding' => [
                'img'  => "/images/resource/home-machinery/Braiding.jpg",
                'url'  => route('machinery.index',),
            ],
            'folding-machine' => [
                'img'  => "/images/resource/home-machinery/Folding-machine.jpg",
                'url'  => route('machinery.index',),
            ],
            'jigger' => [
                'img'  => "/images/resource/home-machinery/Jigger.jpg",
                'url'  => route('machinery.index',),
            ],
            'sizing' => [
                'img'  => "/images/resource/home-machinery/Sizing.jpg",
                'url'  => route('machinery.index',),
            ],
        ];
        return self::convertArrayToObject($data);
    }

    // Divisions
    public static function getDivisionsHome()
    {
        $data = [
            'argentina' => [
                'img'  => "/images/resource/home-divisions/ITGArgentina.png",
                'url' => "https://argentina.group-itg.com/",
            ],
            'brasil' => [
                'img'  => "/images/resource/contacts/Sao Paulo_1.jpg",
                'url' => "https://brasil.group-itg.com/",
            ],
            'china' => [
                'img'  => "/images/resource/home-divisions/ITGChina.jpg",
                'url' => "https://china.group-itg.com/",
            ],
            'colombia' => [
                'img'  => "/images/resource/contacts/ITG Colombia.jpg",
                'url' => "https://colombia.group-itg.com/",
            ],
            'italia' => [
                'img'  => "/images/resource/home-divisions/ITGItalia.jpg",
                'url' => "https://italia.group-itg.com/"
            ],
            'mexico' => [
                'img'  => "/images/resource/home-divisions/ITGMexico.jpg",
                'url' => "https://mexico.group-itg.com/",
            ],
            'peru' => [
                'img'  => "/images/resource/home-divisions/ITGPeru.jpg",
                'url' => "https://peru.group-itg.com/",
            ],
        ];
        return self::convertArrayToObject($data);
    }

    // Cards Blog
    public static function getBlogsHome()
    {
        $data = [
            'industria' => [
                'img'  => "/images/blogs/Blog-Industria.jpg",
                'url'  => "#",
            ],
            'Saxonia' => [
                'img'  => "images/blogs/Blog-Saxonia.jpg",
                'url'  => "#",
            ],
            'trenzadora' => [
                'img'  => "images/blogs/Blog-Trenzadoras.jpg",
                'url'  => "#",
            ],
        ];
        return self::convertArrayToObject($data);
    }

    public static function getOurValuesAbout()
    {

        $data = [
            'our-vision' => [
                'img'  => "images/resource/about-us/Vision.png",
                'name'  => "about-title-vision",
                'text'  => "about-text-vision",
            ],
            'our-mission' => [
                'img'  => "images/resource/about-us/Mision.png",
                'name'  => "about-title-mission",
                'text'  => "about-text-mission",

            ],
            'our-values' => [
                'img'  => "images/resource/about-us/Valores.png",
                'name'  => "about-title-values",
                'text'  => "about-text-values",
            ],
        ];
        return self::convertArrayToObject($data);
    }

    public static function getOurClientsAbout()
    {

        $data = [
            'client1' => [
                'name'  => "about-title-client1",
                'text'  => "about-text-client1",
            ],
            'client2' => [
                'name'  => "about-title-client2",
                'text'  => "about-text-client2",
            ],
            'client3' => [
                'name'  => "about-title-client3",
                'text'  => "about-text-client3",
            ],

        ];

        return self::convertArrayToObject($data);
    }

    #view People
    public static function getOurPeople()
    {

        $data = [
            'people' => [
                'img'  => "images/resource/about-us/Rectangle 213.png",
                'title'  => "people-card-title1",
            ],
            'people1' => [
                'img'  => "images/resource/about-us/Rectangle 214.png",
                'title'  => "people-card-title1",
            ],
            'people2' => [
                'img'  => "images/resource/about-us/Rectangle215.png",
                'title'  => "people-card-title1",
            ],
            'people3' => [
                'img'  => "images/resource/about-us/Rectangle 216.png",
                'title'  => "people-card-title1",
            ],
            'people4' => [
                'img'  => "images/resource/about-us/Rectangle 217.png",
                'title'  => "people-card-title1",
            ],
            'people5' => [
                'img'  => "images/resource/about-us/Rectangle 220.png",
                'title'  => "people-card-title1",
            ],
            'people6' => [
                'img'  => "images/resource/about-us/Rectangle 219.png",
                'title'  => "people-card-title1",
            ],
            'people7' => [
                'img'  => "images/resource/about-us/Rectangle 218.png",
                'title'  => "people-card-title1",
            ],
        ];

        return self::convertArrayToObject($data);
    }
    #------------------------------------------------------------------------------------------------------------
    //view Parner
    public static function getPartners()
    {

        $data = [
            'partner1' =>  [
                'id' => "moly",
                'img' => "images/resource/partners/Moly.png",
                'icon' => "images/resource/partners/Moly-Icono.png",
                'title' => "Molyguard",
                'url' => "#",
            ],
            'partner2' =>  [
                'id' => "iro",
                'img' => "images/resource/partners/Iro Roj.png",
                'icon' => "images/resource/partners/Iro-Icono.png",
                'title' => "IRO ROJ",
                'url' => "#",
            ],
            'partner3' =>  [
                'id' => "titan",
                'img' => "images/resource/partners/Titan.png",
                'icon' => "images/resource/partners/Titan-Icono.png",
                'title' => "Titan",
                'url' => "#",
            ],
            'partner4' =>  [
                'id' => "rifa",
                'img' => "images/resource/partners/Rifa.png",
                'icon' => "images/resource/partners/RIFA-Icono.png",
                'title' => "RIFA",
                'url' => "#",
            ],
            'partner5' =>  [
                'id' => "henghui",
                'img' => "images/resource/partners/Henghui.png",
                'icon' => "images/resource/partners/Henghui-Icono.png",
                'title' => "Henghui",
                'url' => "#",
            ],
            'partner6' =>  [
                'id' => "dky",
                'img' => "images/resource/partners/DKY.png",
                'icon' => "images/resource/partners/DKY-Icono.png",
                'title' => "DKY",
                'url' => "#",
            ],
            'partner7' =>  [
                'id' => "kern",
                'img' => "images/resource/partners/Kern Liebers.png",
                'icon' => "images/resource/partners/Kern Libers-Icono.png",
                'title' => "Kern Liebers",
                'url' => "#",
            ],
            'partner8' =>  [
                'id' => "fiber",
                'img' => "images/resource/partners/Fiber.png",
                'icon' => "images/resource/partners/Fiber-Icono.png",
                'title' => "Fiber Compositi",
                'url' => "#",
            ],
            'partner9' =>  [
                'id' => "comsat",
                'img' => "images/resource/partners/Comsat.png",
                'title' => "Comsat",
                'icon' => "images/resource/partners/Comsat-Icono.png",
                'url' => "#",
            ],
            'partner10' =>  [
                'id' => "bonas",
                'img' => "images/resource/partners/Bonas.png",
                'title' => "Bonas",
                'icon' => "images/resource/partners/Bonas-Icono.png",
                'url' => "#",
            ],
            'partner11' =>  [
                'id' => "ferber",
                'img' => "images/resource/partners/Ferber.png",
                'icon' => "images/resource/partners/Ferber-Icono.png",
                'title' => "Ferber",
                'url' => "",
            ],
            'partner12' =>  [
                'id' => "martl",
                'img' => "images/resource/partners/Martl.png",
                'icon' => "images/resource/partners/Martel-Icono.png",
                'title' => "Martel",
                'url' => "#",
            ],

        ];
        return self::convertArrayToObject($data);
    }

    public function getPartnersBrazil()
    {


        $data = [
            'partner1' =>  [
                'id' => "moly",
                'img' => "images/resource/partners/Moly.png",
                'icon' => "images/resource/partners/Moly-Icono.png",
                'title' => "Molyguard",
                'url' => "#",
            ],
            'partner3' =>  [
                'id' => "titan",
                'img' => "images/resource/partners/Titan.png",
                'icon' => "images/resource/partners/Titan-Icono.png",
                'title' => "Titan",
                'url' => "#",
            ],
            'partner4' =>  [
                'id' => "rifa",
                'img' => "images/resource/partners/Rifa.png",
                'icon' => "images/resource/partners/RIFA-Icono.png",
                'title' => "RIFA",
                'url' => "#",
            ],
            'partner7' =>  [
                'id' => "kern",
                'img' => "images/resource/partners/Kern Liebers.png",
                'icon' => "images/resource/partners/Kern Libers-Icono.png",
                'title' => "Kern Liebers",
                'url' => "#",
            ],


        ];
        return self::convertArrayToObject($data);
    }

    public function getPartnersArgentina()
    {

        $data = [
            'partner1' =>  [
                'id' => "moly",
                'img' => "images/resource/partners/Moly.png",
                'icon' => "images/resource/partners/Moly-Icono.png",
                'title' => "Molyguard",
                'url' => "#",
            ],
            'partner2' =>  [
                'id' => "iro",
                'img' => "images/resource/partners/Iro Roj.png",
                'icon' => "images/resource/partners/Iro-Icono.png",
                'title' => "IRO ROJ",
                'url' => "#",
            ],
            'partner3' =>  [
                'id' => "titan",
                'img' => "images/resource/partners/Titan.png",
                'icon' => "images/resource/partners/Titan-Icono.png",
                'title' => "Titan",
                'url' => "#",
            ],
            'partner4' =>  [
                'id' => "rifa",
                'img' => "images/resource/partners/Rifa.png",
                'icon' => "images/resource/partners/RIFA-Icono.png",
                'title' => "RIFA",
                'url' => "#",
            ],
            'partner5' =>  [
                'id' => "henghui",
                'img' => "images/resource/partners/Henghui.png",
                'icon' => "images/resource/partners/Henghui-Icono.png",
                'title' => "Henghui",
                'url' => "#",
            ],
            'partner6' =>  [
                'id' => "dky",
                'img' => "images/resource/partners/DKY.png",
                'icon' => "images/resource/partners/DKY-Icono.png",
                'title' => "DKY",
                'url' => "#",
            ],
            'partner9' =>  [
                'id' => "comsat",
                'img' => "images/resource/partners/Comsat.png",
                'title' => "Comsat",
                'icon' => "images/resource/partners/Comsat-Icono.png",
                'url' => "#",
            ],
            'partner10' =>  [
                'id' => "bonas",
                'img' => "images/resource/partners/Bonas.png",
                'title' => "Bonas",
                'icon' => "images/resource/partners/Bonas-Icono.png",
                'url' => "#",
            ],
            'partner12' =>  [
                'id' => "martl",
                'img' => "images/resource/partners/Martl.png",
                'icon' => "images/resource/partners/Martel-Icono.png",
                'title' => "Martel",
                'url' => "#",
            ],

        ];
        return self::convertArrayToObject($data);
    }

    public function getPartnersMexico()
    {

        $data = [
            'partner1' =>  [
                'id' => "moly",
                'img' => "images/resource/partners/Moly.png",
                'icon' => "images/resource/partners/Moly-Icono.png",
                'title' => "Molyguard",
                'url' => "#",
            ],
            'partner2' =>  [
                'id' => "iro",
                'img' => "images/resource/partners/Iro Roj.png",
                'icon' => "images/resource/partners/Iro-Icono.png",
                'title' => "IRO ROJ",
                'url' => "#",
            ],
            'partner4' =>  [
                'id' => "rifa",
                'img' => "images/resource/partners/Rifa.png",
                'icon' => "images/resource/partners/RIFA-Icono.png",
                'title' => "RIFA",
                'url' => "#",
            ],
            'partner5' =>  [
                'id' => "henghui",
                'img' => "images/resource/partners/Henghui.png",
                'icon' => "images/resource/partners/Henghui-Icono.png",
                'title' => "Henghui",
                'url' => "#",
            ],
            'partner6' =>  [
                'id' => "dky",
                'img' => "images/resource/partners/DKY.png",
                'icon' => "images/resource/partners/DKY-Icono.png",
                'title' => "DKY",
                'url' => "#",
            ],
            'partner8' =>  [
                'id' => "fiber",
                'img' => "images/resource/partners/Fiber.png",
                'icon' => "images/resource/partners/Fiber-Icono.png",
                'title' => "Fiber Compositi",
                'url' => "#",
            ],
            'partner11' =>  [
                'id' => "ferber",
                'img' => "images/resource/partners/Ferber.png",
                'icon' => "images/resource/partners/Ferber-Icono.png",
                'title' => "Ferber",
                'url' => "",
            ],


        ];
        return self::convertArrayToObject($data);
    }

    public function getPartnersColombia()
    {

        $data = [
            'partner1' =>  [
                'id' => "moly",
                'img' => "images/resource/partners/Moly.png",
                'icon' => "images/resource/partners/Moly-Icono.png",
                'title' => "Molyguard",
                'url' => "#",
            ],
            'partner2' =>  [
                'id' => "iro",
                'img' => "images/resource/partners/Iro Roj.png",
                'icon' => "images/resource/partners/Iro-Icono.png",
                'title' => "IRO ROJ",
                'url' => "#",
            ],
            'partner5' =>  [
                'id' => "henghui",
                'img' => "images/resource/partners/Henghui.png",
                'icon' => "images/resource/partners/Henghui-Icono.png",
                'title' => "Henghui",
                'url' => "#",
            ],
            'partner6' =>  [
                'id' => "dky",
                'img' => "images/resource/partners/DKY.png",
                'icon' => "images/resource/partners/DKY-Icono.png",
                'title' => "DKY",
                'url' => "#",
            ],
            'partner9' =>  [
                'id' => "comsat",
                'img' => "images/resource/partners/Comsat.png",
                'title' => "Comsat",
                'icon' => "images/resource/partners/Comsat-Icono.png",
                'url' => "#",
            ],

        ];
        return self::convertArrayToObject($data);
    }



    #--------------------------------------------------------------------------------------------------------------------
    public static function getTimeLine()
    {
        $data = [
            "1967",
            "1985",
            "1990",
            "2008",
            "2014",
            "2024",
        ];
        return self::convertArrayToObject($data);
    }


    public static function getContactDivisions()
    {
        $data = [
            'ITG Argentina' =>  [
                'img' => "images/resource/contacts/Argentina.png",
                'id' => "argentina",
            ],
            'ITG Brasil' =>     [
                'img' => "images/resource/contacts/Sao Paulo_1.jpg",
                'id' => "brasil",
            ],
            'ITG China' =>  [
                'img' =>  "images/resource/contacts/China.png",
                'id' => "china",
                'text' => true,
            ],
            'ITG Colombia' =>      [
                'img' => "images/resource/contacts/ITG Colombia.jpg",
                'id' => "colombia",
            ],
            'Guatemala' => [
                'img' => "images/resource/contacts/Guatemala.png",
                'id' => "guatemala",
            ],
            'ITG Italia' =>  [
                'img' => "images/resource/contacts/Italy.png",
                'id' => "italia",
                'text' => true,
            ],
            'ITG México' =>  [
                'img' =>  "images/resource/contacts/Mexico.png",
                'id' => "mexico",
            ],
            'ITG Perú' =>   [
                'img' => "images/resource/contacts/Peru.png",
                'id' => "peru",
            ],

        ];
        return  collect(self::convertArrayToObject($data));
    }
    public static function getContinents()
    {
        $data = [
            'europe' => [
                'id' => "1",
                'img' => "images/resource/contacts/europa.jpg"
            ],
            'asia' => [
                'id' => "2",
                'img' => "images/resource/contacts/asia.jpg"
            ],
            'africa' =>  [
                'id' => "3",
                'img' => "images/resource/contacts/africa.jpg"
            ]
        ];

        return  self::convertArrayToObject($data);
    }

    public static function getReviews()
    {
        $data = [
            [
                'division' => ["main", "italia", "china", "peru"],
                'review' => [
                    [
                        'name' => "Donna Tessile Argentina - Claudio Barros, Socio Gerente",
                        'text' => "We would like to thank ITG Argentina for their trust, experience and constant support in the creation of Donna Tessile SRL. After evaluating different options for the acquisition of machinery, we chose ITG for its extensive experience in the textile sector and the confidence that its team transmitted to us."
                    ],
                    [
                        'name' => "SAJUBA Argentina - Juan Ignacio Balian, Presidente",
                        'text' => "For 20 years, we have been working with ITG Group in our growth. They have been key in the incorporation of technology, spare parts and technical support, always with a close relationship and efficient solutions that bring great value to our industry.",
                    ],
                    [
                        'name' => "Reliance FATIMA GROUP Pakistan - Muhammad Rizwan",
                        'text' => "For many years ITG has supplied Reliance with a stable and professional service, we are delighted with the assistance and after sales service they have provided and hope to continue this important relationship. ",
                    ],
                    [
                        'name' => "Toptex - Tomás Alvarada, Jefe de mecánicos telares - Colombia",
                        'text' => "Experiencia con ITG desde hace más de 10 años. Me siento tranquilo y confiado con lo que nosotros trabajamos con ITG. Me parece magnífico la forma en la que hemos trabajo con ellos y nos coordinamos. Sus repuestos están garantizados en calidad y su atención es excelente. ",
                    ],
                    [
                        'name' => "Cordones y Trenzados - Colombia",
                        'text' => "ITG ha sido un proveedor confiable y se ha convertido en un aliado estratégico por casi 10 años, en ITG  encontramos soluciones para todo nuestro proceso de producción, desde materia prima hasta maquinaria de la mejor calidad y con el mejor soporte.",
                    ],
                    [
                        'name' => "TABORELLI Italia",
                        'text' => "Textile accessories are always available, speed of delivery and competitive prices , together with the expertise of the operators, make ITG an important supplier of ours. A real help in dealing with a world, that of weaving, where speed of service, quality and price are of primary importance.",
                    ],
                    [
                        'name' => "Engotex Textil Brazil - Gilmar Schwamberger",
                        'text' => "I have been an ITG customer for years and have always had an excellent experience. They are reliable, offer quality service at every stage and their after-sales service is exceptional. I highly recommend ITG for their reliability and commitment to their customers.",
                    ],
                    [
                        'name' => "Paraguaçu Têxtil Brazil - Felipe Machado, Operations Manager ",
                        'text' => "We have been collaborating with ITG for seven years, highlighting its seriousness in customer service, always providing the best solutions and products of excellent quality, which gives us confidence and peace of mind in each negotiation.",
                    ],
                    [
                        'name' => "Votex Indústria Têxtil Brazil - Renato Heckmann, Weaving Maintenance Coordinator",
                        'text' => "I have been working with ITG for five years. Their extensive knowledge of the industry and the quality of their service and materials give us confidence and security in each application. They are professional and approachable, thank you ITG!",
                    ],
                ],
            ],

            [
                'division' => ["argentina"],
                'review' => [
                    [
                        'name' => "Donna Tessile - Claudio Barros, Socio Gerente",
                        'text' => "Queremos agradecer a ITG Argentina por su confianza, experiencia y constante apoyo en la creación de Donna Tessile SRL. Tras evaluar diferentes opciones para la adquisición de maquinaria, elegimos ITG por su amplia trayectoria en el sector textil y la confianza que nos transmitió su equipo."
                    ],
                    [
                        'name' => "SADASA - Ezequiel D´Agostino, Director",
                        'text' => "Desde que comenzamos a trabajar con ITG Group, nos hicieron sentir parte de su familia. Como empresa familiar en Argentina, la calidez de su equipo marcó la diferencia que necesitábamos. Estamos muy contentos de crecer junto a ellos y sin duda continuaremos colaborando en el futuro.",
                    ],
                    [
                        'name' => "SAJUBA - Juan Ignacio Balian, President",
                        'text' => "Desde hace 20 años, trabajamos con ITG Group en nuestro crecimiento. Han sido clave en la incorporación de tecnología, repuestos y soporte técnico, siempre con un trato cercano y soluciones eficientes que aportan gran valor a nuestra industria.",
                    ],
                ],
            ],
            [
                'division' => ["brasil"],
                'review' =>  [
                    [
                        'name' => "Engotex Textil - Gilmar Schwamberger",
                        'text' => "Sou cliente da ITG há anos e sempre tive uma excelente experiência. A empresa é confiável e oferece atendimento de qualidade em todas as etapas, com um pós-venda excepcional. Recomendo a ITG pela seriedade e comprometimento com os clientes."
                    ],
                    [
                        'name' => "Anderson Westphal - Área de manutenção",
                        'text' => "Trabalho há quase um ano com a ITG e posso afirmar que nunca fui tão bem atendido como por eles. O Mário e a Pamela oferecem um atendimento rápido e prestativo, muito acima da média. O destaque vai para o pós-venda, onde, ao contrário de outras empresas que criam burocracias, com a ITG basta uma mensagem para resolver proble",
                    ],
                    [
                        'name' => "Paraguaçu Têxtil - Felipe Machado, Gerente de Operações da empresa ",
                        'text' => "Nossa parceria com a ITG já dura sete anos. A empresa se destaca pelo atendimento ao cliente, sempre priorizando nossas expectativas e apresentando as melhores soluções. A qualidade de seus produtos nos proporciona confiança e tranquilidade nas negociações, sabendo que estamos sempre bem atendidos!",
                    ],
                    [
                        'name' => "Departamento de Compras da empresa Teka - Leonardo e Coutinho",
                        'text' => "Nossa parceria com o grupo Giamminola já é de tempo. As pessoas mudam mais a dedicação e o profissionalismo que esta empresa frisa em passar para seus colaboradores não mudam.Eles são mais que fornecedores, são verdadeiros parceiros de negócios.",
                    ],
                    [
                        'name' => "Votex Indústria Têxtil - Renato Heckmann, Coordenador de manutenção em tecelagem ",
                        'text' => "Em cinco anos de parceria com a ITG, o diferencial está no amplo conhecimento da área, garantindo qualidade no atendimento e nas peças. Isso nos proporciona segurança e confiança, tornando-os extremamente profissionais e amigos. Obrigado, ITG",
                    ],
                    [
                        'name' => "Santa Margarida - Wanderlei Junior, Gerente ",
                        'text' => "Trabalhamos com a ITG há mais de 15 anos. Parceiro confiável, com excelência no Atendimento e muito Profissionalismo. Gostamos de trabalhar com a IT",
                    ],

                ]
            ],
            [
                'division' => ["colombia"],
                'review' =>  [
                    [
                        'name' => "Unoxuno - José Vicente García, Gerente de Producción",
                        'text' => "He tenido relaciones comerciales con ITG desde hace más de 20 años, mi anterior cargo era director de producción en textiles Romanos hasta Mayo del 2024, siempre me ha atendido el señor Rodrigo Cañas con la mejor disposición y siempre presto a solucionar mis problemas en todo lo referente a repuesto y asesorías técnicas"
                    ],
                    [
                        'name' => "Toptex - Tomás Alvarada, Jefe de mecánicos telares",
                        'text' => "Experiencia con ITG desde hace más de 10 años. Me siento tranquilo y confiado con lo que nosotros trabajamos con ITG. Me parece magnífico la forma en la que hemos trabajo con ellos y nos coordinamos. Sus repuestos están garantizados en calidad y su atención es excelente. ",
                    ],
                    [
                        'name' => "Toptex - Jhon Silva, Jefe de producción telares ",
                        'text' => "Ha sido un gran aliado en la guía de repuestos y suministros de estos mismos para garantizar el funcionamiento de nuestra maquinaria..cumpliendo con estándares de calidad.",
                    ],
                    [
                        'name' => "Lamitextil",
                        'text' => "El tiempo que llevo laborando con ITG Colombia me he sentido muy respaldado en todas mis necesidades. ¡Buen servicio!",
                    ],
                    [
                        'name' => "Cordones y Trenzados",
                        'text' => "ITG ha sido un proveedor confiable y se ha convertido en un aliado estratégico por casi 10 años, en ITG  encontramos soluciones para todo nuestro proceso de producción, desde materia prima hasta maquinaria de la mejor calidad y con el mejor soporte.",
                    ],
                    [
                        'name' => "Anónimo",
                        'text' => "Estoy muy contento y agradecido por el trabajo que venimos realizando con ITG Colombia para todos los repuestos de máquinas circulares, el tiempo de respuesta, los precios y el acompañamiento técnico hacen que uno se sienta seguro y satisfecho.",
                    ],
                    [
                        'name' => "Tejidos Planos de Soacha - Juan vargas",
                        'text' => "Somos una empresa con telares Vamatex y por medio de ITG hemos adquirido los repuestos para el mantenimiento de las máquinas por más de 20 años. A pesar de que mis máquinas ya tienen aproximadamente 40 años, ITG me suministra los repuesto y me han ayudado mucho. ",
                    ],

                    [
                        'name' => "Technihilos - Fulton Gutierrez, gerente de división de tejido ",
                        'text' => "Experiencia agradable. ITG siempre ha estado muy disponible y dispuesto, siempre atienden necesidades como empresa, con buena atención.Cuando los técnicos están aquí, me visitan y me ayudan con mis inquietudes. Son una empresa reconocida con una relación muy buena, siempre dispuestos y disponibles. ",
                    ],
                    [
                        'name' => "Ronnantex - Tito Garzón, Gerente Mantenimiento",
                        'text' => "Tenemos más de 20 años trabajando con ITG Colombia. La experiencia ha sido muy grata. Comprometido con los repuestos al igual de buena calidad. Agradecidos con ITG por su excelente compromiso y responsabilidad. ",
                    ],
                    [
                        'name' => "El punto de los Insumos - Camilo bustamante, Supervisor de planta ",
                        'text' => "Experiencia agradable, ya que siempre tienen disponibilidad para ayudarnos en el crecimiento de la empresa. Dispuestos a ayudarnos, a estar pendiente de nosotros con todo:productos,  logística, entrega. La calidad del hilo es muy buena, Nunca hemos tenido ningún inconveniente. Ha sido importante para nosotros porque fue un proyecto de cero y se recibió ayuda de parte de ITG y hasta el día de hoy estamos agradecidos con ITG porque sin ellos no seriamos la empresa que somos hoy en día. Agradecidos siempre con la empresa. ",
                    ],
                ]
            ],




        ];

        return  $data;
    }
}
