<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ProductCategory extends Model
{
    use HasFactory;

    #consult to productCategorytranslations (hasMany)
    public function productCategoryTranslations()
    {
        return  $this->hasMany(ProductCategoryTranslation::class);
    }

    #consult to ProductCategoryTranslation(hasOne)
    public function translation()
    {
        $lang  = session('langSet');
        return $this->hasOne(ProductCategoryTranslation::class)->where('language_id', $lang->id);
    }
}
