<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class MachineFeature extends Model
{
    use HasFactory;

    #consult to Machine (belongsTo)
    public function machine()
    {
        return $this->belongsTo(Machine::class);
    }

    #consult to MachineFeatureTranslation (hasOne)
    public function translation()
    {
        $lang  = session('langSet');
        return $this->hasOne(MachineFeatureTranslation::class)->where('language_id', $lang->id);
    }
}
