<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Division extends Model
{
    use HasFactory;

    #query of corresponding logo by division
    public function logo()
    {
        return $this->hasOne(Logo::class);
    }

    #query corresponding languages ​​by division
    public function  languages()
    {
        return $this->belongsToMany(Language::class, 'divisions_languages');
    }

    #query language Default
    public function languageDefault()
    {
        return $this->belongsTo(Language::class, 'default_language');
    }
}
