<?php

namespace App\Models;

use App\Models\BlogImage;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Blog extends Model
{
    use HasFactory;


    #query to BlogCategory (belonsTo)
    public function blogCategory()
    {
        return $this->belongsTo(BlogCategory::class);
    }

    #query to BlogTranslation (hasMany)
    public function blogTranslation()
    {
        return  $this->hasMany(BlogTranslation::class);
    }

    #query to BlogTranslation(hasOne)
    public function translation()
    {
        // $lang = Language::getLanguage();
        $lang  = session('langSet');
        return $this->hasOne(BlogTranslation::class)->where('language_id', $lang->id);
    }

    #query to BlogTags(belogsToMany)
    public function blogTags(){
        return $this->belongsToMany(BlogTag::class, 'blog_tag_rels');
    }

    #query to BlogImage(HasOne) - For lang
    public function image()
    {
        $lang  = session('langSet');
        return $this->hasOne(BlogImage::class)->where('language_id', $lang->id);
    }

    #query to GalleryBlog(hasMany)
    public function blogImages(){
        return $this->hasMany(GalleryBlogImage::class);
    }

}
