<?php

namespace App\Livewire;

use Livewire\Component;
use App\Mail\ContactMailable;
use App\Models\ContactInterestMail;
use Illuminate\Support\Facades\Mail;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use Illuminate\Validation\ValidationException;

//! NO Use

class ContactInterestMailPost extends Component
{

    use LivewireAlert;

    public $email;
    public $dataDivision;

    protected $rules = [
        'email' => 'required|email',
    ];

    public function render()
    {
        return view('livewire.contact-interest-mail-post');
    }

    public function store()
    {

        //try for validate
        try {
            $this->validate();
            //try for send Email
            try {
                //content Email
                $title        = "New contact message";
                $subject      = 'New contact message';
                //send email
                Mail::to('info@group-itg.com')
                ->bcc(['ismaharo18@gmail.com', 'luiscastellanos.dv@gmail.com'])
                ->send(new ContactMailable($this->emailContent(), $title, $subject, $file = null));
                //save information
                ContactInterestMail::create([
                    'email'         => $this->email,
                    'division_id'   => $this->dataDivision->id,
                ]);
                //clean form & alert
                $this->cleanForm();
                $this->alert('success', __('messages.success-email'));
            } catch (\Exception  $e) {
                $this->alert('error', __('messages.error-email'));
            }
        } catch (ValidationException $e) {
            $firstError = $e->validator->errors()->first();
            $this->alert('error',   $firstError);
        }
    }

    public function emailContent()
    {
        $emailContent =        '
        <h3 style="margin-bottom: 20px;">Hello, ' . $this->email   . ' wants to
            contact you!
        </h3>
        <p><strong>Email: </strong>' . $this->email  . '</p>
        <p><strong>Division visited: </strong>'. $this->dataDivision->name  .'</p>
        ';

        return $emailContent;
    }



    public function cleanForm()
    {
        $this->email = '';
    }
}
