<?php

namespace App\Livewire;

use Livewire\Component;
use App\Models\Division;
use App\Models\Specialty;
use Illuminate\Support\Str;
use App\Mail\ContactMailable;
use Livewire\WithFileUploads;
use App\Models\ContactCareers;
use Illuminate\Support\Facades\Mail;
use Jantinnerezo\LivewireAlert\LivewireAlert;

//! NO Use

class ContactCareersPost extends Component
{
    use WithFileUploads;
    use LivewireAlert;


    public $division;
    public $specialty;
    public $email;
    public $name;
    public $messageEmail;
    public $cv;
    public $dataDivision;

    protected  $rules = [
        'division' => "required|integer",
        'specialty' =>   "required|integer",
        'email' => 'required|email',
        'name' => 'required|string',
        'messageEmail' => 'required|string',
        'cv' => 'required|file|mimes:jpg,jpeg,png,pdf,doc,docx|max:3072',
    ];


    public function render()
    {

        $divisions   = Division::where('id', '!=', 1)->get();
        $specialties = Specialty::all();

        return view('livewire.contact-careers-post', compact('divisions', 'specialties'));
    }

    public function store()
    {
        #validate
        $this->validate();
        try {
            //content Email
            $title        = "New contact message - Carrers";
            $subject      = 'New contact message - Carrers';
            //save information cv
            $nameCv = Str::uuid() .  "." . $this->cv->extension();
            $file   = $this->cv->storeAs('cv-documents', $nameCv);
            #send email
            Mail::to('info@group-itg.com')
            ->bcc(['ismaharo18@gmail.com', 'luiscastellanos.dv@gmail.com'])
            ->send(new ContactMailable($this->emailContent(), $title, $subject, $file));
            ContactCareers::create([
                'email'         => $this->email,
                'name'          => $this->name,
                'message'       => $this->messageEmail,
                'file_cv'       => $nameCv,
                'division'      => $this->division,
                'specialty_id'  => $this->specialty,
                'division_id'   => $this->dataDivision->id,
            ]);
            #Clean form
            $this->alert('success', __('messages.success-email'));
            session()->flash('messageSuccess', __('messages.success-email'));
            $this->cleanForm();
        } catch (\Exception $e) {
            session()->flash('error_message', $e);
            $this->alert('error', __('messages.error-email'));
        }
    }

    public function emailContent()
    {
        $division   = Division::find($this->division);
        $specialty = Specialty::find($this->specialty);
        //info form email
        $content = '
        <h3 style="margin-bottom: 20px;">Hello, ' . $this->name  . '
            is interested in working with us!
        </h3>
        <p><strong>Name: </strong>' . $this->name  . '</p>
        <p><strong>Email: </strong>' . $this->email  . '</p>
        <p><strong>Selected Specialty: </strong>' . $specialty->name . '</p>
        <p><strong>Selected Division: </strong>' . $division->name  . '</p>
        <p><strong>Message: </strong></p>
        <p>' . $this->messageEmail  . '</p> 
        ';

        return $content;
    }

    public function cleanForm()
    {
        $this->division = '';
        $this->specialty = '';
        $this->email = '';
        $this->name = '';
        $this->messageEmail = '';
        $this->cv = '';
    }
}
