<?php

namespace App\Livewire;

use Livewire\Component;
use App\Mail\ContactMailable;
use App\Models\CatalogueContact;
use Illuminate\Support\Facades\Mail;
use Jantinnerezo\LivewireAlert\LivewireAlert;


class CatalogueContactForm extends Component
{

    use LivewireAlert;


    public $email;
    public $name;
    public $country;
    public $dataDivision;
    public $product_type;
    public $product_name;
    public $urlCatalogue;


    protected  $rules = [
        'email' => 'required|email|max:100',
        'name' => "required|string|max:100",
        'country' =>   "required|string|max:50",

    ];



    public function render()
    {
        return view('livewire.catalogue-contact-form');
    }

    public function store()
    {
        #validate
        $this->validate();

        //content Email
        $contentEmail = $this->emailContent();
        $title        = "New product contact message";
        $subject      = 'New contact message sent from Catalogue';


        try {
            #send email
            Mail::to('info@group-itg.com')
                ->bcc(['ismaharo18@gmail.com', 'luiscastellanos.dv@gmail.com'])
                ->send(new ContactMailable($contentEmail, $title, $subject, $file = null));
            #save information
            CatalogueContact::create([
                'email'         => $this->email,
                'name'          => $this->name,
                'country'       => $this->country,
                'product_type' => $this->product_type,
                'product_name' => $this->product_name,
                'division_id'   => $this->dataDivision->id,
            ]);

            $this->alert('success', __('messages.success-email'));


            #Clean form
            $this->dispatch('postForm');
            if (!empty($this->urlCatalogue)) {
                $filePath = public_path($this->urlCatalogue);
                return response()->download($filePath);
            }


            #message success
        } catch (\Exception $e) {
            // dd($e);
            #message error
            session()->flash('error_message', $e);
            $this->alert('error', __('messages.error-email'));
        }
    }


    public function emailContent()
    {
        //info form email
        $content = '
        
        <h3 style="margin-bottom: 20px;">Hello, ' . $this->name  . ' saw some of your products and downloaded the catalog !
        </h3>
        <p><strong>Name: </strong>' . $this->name  . '</p>
        <p><strong>Email: </strong>' . $this->email  . '</p>
        <p><strong>Country: </strong>' . $this->country  . '</p>
        <p><strong>Product type: </strong>' . $this->product_type  . '</p>
        <p><strong>Product name: </strong>' . $this->product_name  . '</p>
        <p><strong>Division visited: </strong>' . $this->dataDivision->name  . '</p>
        ';

        return $content;
    }
}
