<?php

namespace App\Http\Middleware;

use Closure;
use App\Models\Division;
use App\Models\Language;
use App\Utils\SubdomainUtil;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\App;
use PhpParser\Node\Expr\Cast\Bool_;
use Symfony\Component\HttpFoundation\Response;

class SetLanguage
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {

        if ($this->isValidate()) {
            #get the subdomain
            $subdomain = SubdomainUtil::extract($request);
            #get info Division
            $division = Division::with('logo')->with('languages')->where('name', $subdomain)->first() ?? Division::with('logo')->with('languages')->find(1);
            #save Data in sessson
            session(['division' => $division,  'subdomain' => $subdomain]);
        }


        $language_code = session()->get('locale');
        $lagOld        = session('langSet')->language_code ?? null;

        if ($language_code && $language_code !== $lagOld) {
            $language = Language::where('language_code', $language_code)->first();
            session()->put('langSet', $language);
        } elseif (is_null($lagOld)) {
            $language =  session('division')->languageDefault;
            session()->put('langSet', $language);
        }
        
        App::setLocale(session('langSet')->language_code);
        #shered info language
        view()->share('info_language', session('langSet'));
        return $next($request);
    }


    public function isValidate(): bool
    {
        $subdomain = session('subdomain');
        $division  =  session('division');

        return (!isset($subdomain) && !isset($division));
    }
}
