<?php

namespace App\Http\Controllers;


use App\Models\Blog;
use App\Utils\GeneralUtil;
use App\Utils\DataPageUtil;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\View;

class ViewManagerController extends Controller
{


  protected $dataUtil;
  protected $util;
  public function __construct(DataPageUtil $dataUtil, GeneralUtil $util)
  {
    $this->dataUtil = $dataUtil;
    $this->util     = $util;
  }

  #Page Home
  public function home()
  {
    #util
    $division =  $this->dataUtil->dataPAge();
    $util =  $this->util;
    $blogsQuery = Blog::with('image', 'translation')->get();

    $nameDivision = 'homes.'. $division->name . '-home';

    if (View::exists($nameDivision)) {
      return view($nameDivision, compact('division', 'util', 'blogsQuery'));
  } 


    return view('homes.main-home', compact('division', 'util', 'blogsQuery'));
  }

  #Page About-us
  public function about()
  {
    $division =  $this->dataUtil->dataPAge();
    $util =  $this->util;

    return view('about.about-us', compact('division', 'util'));
  }

  #Page Partners
  public function partners()
  {

    $util =  $this->util;
    $division =  $this->dataUtil->dataPAge();

    // dd($division);

    return view('partners', compact('division', 'util'));
  }
  #Page Contacts
  public function contact()
  {
    $division =  $this->dataUtil->dataPAge();
    $util =  $this->util;


    return view('contact', compact('division', 'util'));
  }

    #Page Contacts
    // public function notFound()
    // {
    //   $division =  $this->dataUtil->dataPAge();
    //   $util =  $this->util;
  
  
    //   return response()->view('errors.404', compact('division'), 404);
    // }
  


  public function sitemap()
  {
    $division =  $this->dataUtil->dataPAge();
    $xmlFilePath = public_path("sitemaps/{$division->name}.sitemap.xml");

    if (file_exists($xmlFilePath)) {
      return response()->file($xmlFilePath, [
        'Content-Type' => 'application/xml',
        'Content-Disposition' => 'inline; filename="' . $division->name . '.xml"',
      ]);
    }

    return abort(404);
  }
}
