<?php

namespace App\Http\Controllers;

use App\Utils\GeneralUtil;
use App\Utils\DataPageUtil;
use App\Utils\ProductsUtil;
use Illuminate\Http\Request;
use App\Models\ProductSector;

class ProductController extends Controller
{

    protected $dataUtil;
    public function __construct(DataPageUtil $dataUtil)
    {
        $this->dataUtil = $dataUtil;
    }


    public function index(ProductSector $sector = null)
    {
        $sectors  = ProductSector::with('translation')->get();
        $selectedSector = ProductSector::find($sector->id ?? 1);
        $division = $this->dataUtil->dataPage($selectedSector->name ?? null);
        $selectedNameView = 'products.' . $selectedSector->name;

        $products = new ProductsUtil();

        $catalogue = ['braiding','yarn'];

        $util = new GeneralUtil();
        return view('products.products', compact('division', 'sectors', 'util', 'selectedSector', 'products', 'selectedNameView','catalogue'));
    }
}
