<?php

namespace App\Http\Controllers;

use App\Models\Machine;
use App\Utils\GeneralUtil;
use App\Utils\DataPageUtil;
use App\Models\MachineCategory;

class MachineryController extends Controller
{
    protected $dataUtil;
    protected $util;

    public function __construct(DataPageUtil $dataUtil, GeneralUtil $util)
    {
        $this->dataUtil = $dataUtil;
        $this->util     = $util;
    }

    #New
    public function index(MachineCategory $category = null, $condition = 0)
    {
        //! order to show 
        $customOrder = [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 18, 14, 15, 16, 17, 19, 20, 21, 22, 23, 25, 24];


        $division   = $this->dataUtil->dataPage($category->name ?? null);

        $machineQuery = Machine::with('translation', 'machineCategory.translation')->orderByRaw('FIELD(id, ' . implode(',', $customOrder) . ')');

        $categories = MachineCategory::with('translation')->get();

        $machines = empty($category) ? $machineQuery->paginate(4) : $machineQuery->where('machine_category_id', $category->id)->paginate(4);

        return view('machinery.machinery', compact('division', 'machines', 'categories', 'category', 'condition'));
    }

    #Used
    // public function used()
    // {
    //     $division   = $this->dataUtil->dataPage();


    //     return view('machinery.machinery', compact('division', 'used'));
    // }


    public function show(Machine $machine)
    {

        $machine  =  Machine::with('translation', 'machineDetails.translation', 'machineFeatures.translation')->find($machine->id);

        if (empty($machine)) {
            return redirect()->route('machinery.index');
        }
        $division = $this->dataUtil->dataPage($machine->name ?? null);

        $representation = [1, 2, 3, 4, 5];

        return view('machinery.machinery-show', compact('division', 'machine', 'representation'));
    }

    public function newMachinery()
    {

        $division   = $this->dataUtil->dataPage();
        $util =  $this->util;


        return view('machinery.new-machinery', compact('division', 'util'));
    }
}
