<?php

namespace App\Http\Controllers;

// use App\Utils\GeneralUtil;

use App\Models\Blog;
use App\Models\Language;
use App\Utils\DataPageUtil;
use App\Models\BlogCategory;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Gate;

class BlogController extends Controller
{
    protected $dataUtil;
    public function __construct(DataPageUtil $dataUtil)
    {
        $this->dataUtil = $dataUtil;
    }

    #view for search and category
    public function index(Request $request, BlogCategory $blogCategory = null)
    {
        $division   = $this->dataUtil->dataPage($blogCategory->name ?? null);
        $query      = $request->input('query');

        $blogsQuery = Blog::with('image', 'translation');
        $categories = BlogCategory::with('translation')->withCount('blogs')->get();

        $latestBlog = $blogsQuery->orderBy('id', 'desc')->take(4)->get();

        if (!empty($blogCategory)) {
            $blogs =  $blogsQuery->with('blogCategory.translation')->where('blog_category_id', $blogCategory->id)->latest()->paginate(4);
        } else {
            $lang  = session('langSet');
            $blogs =  $blogsQuery->with('blogCategory.translation')->whereHas('translation', function ($q) use ($query, $lang) {
                $q->where('language_id', $lang->id)->where('name', 'like', "%{$query}%");
            })->with('blogCategory')->orderBy('id', 'desc')->paginate(4);
            $blogs->appends(['query' => $query]);
        }

        return view('blogs.blog', compact('division', 'blogs', 'categories', 'latestBlog', 'blogCategory', 'query'));
    }






    #view detail fot blog
    public function show(Request $request, Blog $blog)
    {
        // $blog       =  Blog::find($blogSelect);
        $division   = $this->dataUtil->dataPage($blog->name);


        $categories = BlogCategory::with('translation')->withCount('blogs')->get();
        // $blogsQuery = Blog::where('division_id', $division->id);
        $latestBlog = Blog::orderBy('id', 'desc')->take(4)->get();
        // $blogsRel   = Blog::whereKeyNot($blog->id)->where('blog_category_id', $blog->blog_category_id)->get();
        // dd($blogsRel);

        return view('blogs.blog-show', compact('division', 'blog', 'categories', 'latestBlog'));
    }
}
